/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.CallIgs;
import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.logging.Location;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class IgsComponent {
    private static Location log;
    private static String className;
    protected boolean mustCallIgs = true;
    protected long lastCall = 0L;
    protected CallIgs caller;
    protected String igsError;
    protected URL igsUrl;
    protected boolean finest = log.beLogged(100);
    protected String interpreterName;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$IgsComponent;

    public IgsComponent() {
        this.caller = new CallIgs();
    }

    public void setIgsUrl(URL igsUrl) {
        this.mustCallIgs = true;
        this.igsUrl = igsUrl;
        this.caller.setUrl(igsUrl, this.interpreterName);
    }

    public void setIgsUrlString(String igsUrlString) {
        if (igsUrlString == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(igsUrlString);
        }
        catch (MalformedURLException e) {
            log.debugT("setIgsUrlString", "fatal: invalid igsUrlString: " + igsUrlString);
            return;
        }
        this.setIgsUrl(url);
    }

    protected void callIgs() {
        this.igsError = null;
        this.clearResults();
        this.caller.clearParameters();
        if (this.igsUrl == null) {
            String errorMessage = "fatal: Trying to call igs, but url was null";
            this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
            log.debugT("callIgs", this.igsError);
            return;
        }
        try {
            if (!this.addParameters()) {
                String errorMessage = "fatal: could not add request parameters";
                this.igsError = this.igsError == null ? errorMessage : this.igsError + " " + errorMessage;
                log.debugT("addParameters", errorMessage);
                return;
            }
            this.caller.execute();
            this.extractResults();
        }
        catch (GraphicsException e) {
            log.debugT("callIgs", "fatal: " + Util.extractCallstack(e));
            this.igsError = e.getMessage();
        }
        this.mustCallIgs = false;
        this.lastCall = System.currentTimeMillis();
    }

    protected void callIgsIfNecessary() {
        if (this.mustCallIgs || System.currentTimeMillis() - 600000L >= this.lastCall) {
            this.callIgs();
        }
    }

    public void clearAll() {
        this.mustCallIgs = true;
        this.lastCall = 0L;
        this.igsError = null;
        this.igsUrl = null;
        this.clearResults();
    }

    protected abstract void clearResults();

    protected abstract boolean addParameters();

    protected abstract void extractResults();

    public abstract boolean execute();

    public abstract String getErrors();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "IgsComponent";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$IgsComponent == null ? (class$com$sap$tc$graphics$igs$IgsComponent = IgsComponent.class$("com.sap.tc.graphics.igs.IgsComponent")) : class$com$sap$tc$graphics$igs$IgsComponent).getName());
    }
}

