/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IChartData;
import com.sap.tc.graphics.igs.Util;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicDC
implements IChartData {
    private static Location log;
    private static String className;
    private boolean finest = log.beLogged(100);
    private ArrayList series = new ArrayList();
    private ArrayList categories = new ArrayList();
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$ChartDataContainer;

    public void addSeries(Series series) {
        this.series.add(series);
    }

    public String getData() {
        Document document = null;
        try {
            document = XmlUtil.createDocument();
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: XmlUtil.createDocument() failed";
            log.debugT("getData", errorMessage);
            return null;
        }
        Element root = document.createElement("ChartData");
        if (root == null) {
            String errorMessage = "fatal: creating of root element failed";
            log.debugT("getData", errorMessage);
            return null;
        }
        document.appendChild(root);
        try {
            Node categoriesNode = XmlUtil.appendNode(document.getDocumentElement(), "Categories");
            Iterator it = ((AbstractList)this.categories).iterator();
            while (it.hasNext()) {
                Category currentCategory = (Category)it.next();
                Element categoryNode = (Element)XmlUtil.appendNode(categoriesNode, "Category", currentCategory.value);
                if (Util.isEmpty(currentCategory.extension)) continue;
                categoryNode.setAttribute("extension", currentCategory.extension);
            }
            Iterator it2 = ((AbstractList)this.series).iterator();
            while (it2.hasNext()) {
                Series currentSeries = (Series)it2.next();
                if (currentSeries == null) continue;
                Element seriesNode = (Element)XmlUtil.appendNode(document.getDocumentElement(), "Series");
                if (!Util.isEmpty(currentSeries.label)) {
                    seriesNode.setAttribute("label", currentSeries.label);
                }
                if (!Util.isEmpty(currentSeries.extension)) {
                    seriesNode.setAttribute("extension", currentSeries.extension);
                }
                if (!Util.isEmpty(currentSeries.customizing)) {
                    seriesNode.setAttribute("customizing", currentSeries.customizing);
                }
                if (currentSeries.points == null) continue;
                Object[] points = currentSeries.points.toArray();
                int j = 0;
                while (j < points.length) {
                    Point point = (Point)points[j];
                    Element pointNode = (Element)XmlUtil.appendNode(seriesNode, "Point");
                    if (!Util.isEmpty(point.label)) {
                        pointNode.setAttribute("label", point.label);
                    }
                    if (!Util.isEmpty(point.extension)) {
                        pointNode.setAttribute("extension", point.extension);
                    }
                    if (!Util.isEmpty(point.customizing)) {
                        pointNode.setAttribute("customizing", point.customizing);
                    }
                    if (point.values != null) {
                        Iterator pointIt = ((AbstractList)point.values).iterator();
                        while (pointIt.hasNext()) {
                            Value value = (Value)pointIt.next();
                            Element valueNode = (Element)XmlUtil.appendNode(pointNode, "Value", value.value);
                            valueNode.setAttribute("type", value.getType());
                        }
                    }
                    ++j;
                }
            }
        }
        catch (GraphicsException e) {
            log.debugT("getData", "fatal: failed to append nodes");
            return null;
        }
        String retVal = XmlUtil.serialize(document);
        if (this.finest) {
            log.debugT("getData", "data: " + retVal);
        }
        return retVal;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public void addCategory(String extension, String value) {
        this.categories.add(new Category(extension, value));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "ChartDataContainer";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$ChartDataContainer == null ? (class$com$sap$tc$graphics$igs$ChartDataContainer = DynamicDC.class$("com.sap.tc.graphics.igs.ChartDataContainer")) : class$com$sap$tc$graphics$igs$ChartDataContainer).getName());
    }

    public static class Value {
        public static final byte X = 0;
        public static final byte Y = 1;
        public static final byte SIZE = 2;
        public static final byte TREND_X = 3;
        public static final byte TREND_Y = 4;
        public static final byte CHART = 5;
        public static final byte TIME = 6;
        private byte type;
        private String value;

        public Value(String yValue) {
            this.type = 1;
            this.value = yValue;
        }

        public Value(double yValue) {
            this(String.valueOf(yValue));
        }

        public Value() {
            this.type = 1;
        }

        public Value(byte type, String value) {
            this.type = type;
            this.value = value;
        }

        public void setType(byte type) {
            this.type = type;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            switch (this.type) {
                case 0: {
                    return "x";
                }
                case 1: {
                    return "y";
                }
                case 2: {
                    return "size";
                }
                case 3: {
                    return "trendX";
                }
                case 4: {
                    return "trendY";
                }
                case 5: {
                    return "chart";
                }
                case 6: {
                    return "time";
                }
            }
            return null;
        }
    }

    public static class Point {
        private String label;
        private String extension;
        private String customizing;
        private ArrayList values;

        public Point() {
        }

        public Point(String yValue) {
            this.addValue(new Value(yValue));
        }

        public Point(double value) {
            this(String.valueOf(value));
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setCustomizing(String customizing) {
            this.customizing = customizing;
        }

        public void addValue(Value value) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.values.add(value);
        }
    }

    public static class Series {
        private ArrayList points = new ArrayList();
        private String label;
        private String extension;
        private String customizing;

        public void setLabel(String label) {
            this.label = label;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setCustomizing(String customizing) {
            this.customizing = customizing;
        }

        public void addPoint(Point point) {
            this.points.add(point);
        }
    }

    public class Category {
        private String extension;
        private String value;

        public Category() {
        }

        public Category(String extension, String value) {
            this.extension = extension;
            this.value = value;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

