/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.graphics.igs;

import com.sap.tc.graphics.igs.GraphicsException;
import com.sap.tc.graphics.igs.IChartData;
import com.sap.tc.graphics.igs.XmlUtil;
import com.sap.tc.logging.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChartDataContainer
implements IChartData {
    private static Location log;
    private static String className;
    private boolean finest = log.beLogged(100);
    private Point[][] data;
    private Category[] categories;
    private Series[] series;
    static /* synthetic */ Class class$com$sap$tc$graphics$igs$ChartDataContainer;

    public ChartDataContainer() {
        this(1, 1);
    }

    public ChartDataContainer(int series, int categories) {
        this.initDimensions(series, categories);
    }

    public void initDimensions(int seriesNumber, int categoryNumber) {
        if (seriesNumber <= 0) {
            String message = "fatal: invalid number of series: " + this.series;
            log.debugT(className, message);
            throw new IllegalArgumentException(message);
        }
        if (categoryNumber <= 0) {
            String message = "fatal: invalid number of categories: " + this.categories;
            log.debugT(className, message);
            throw new IllegalArgumentException(message);
        }
        this.data = new Point[seriesNumber][];
        int i = 0;
        while (i < seriesNumber) {
            this.data[i] = new Point[categoryNumber];
            int j = 0;
            while (j < categoryNumber) {
                this.data[i][j] = new Point();
                ++j;
            }
            ++i;
        }
        this.categories = new Category[categoryNumber];
        int i2 = 0;
        while (i2 < categoryNumber) {
            this.categories[i2] = new Category();
            ++i2;
        }
        this.series = new Series[seriesNumber];
        int i3 = 0;
        while (i3 < seriesNumber) {
            this.series[i3] = new Series();
            ++i3;
        }
    }

    private void checkIndices(int seriesIndex, int categoryIndex) {
        if (seriesIndex < 0 || seriesIndex >= this.series.length) {
            String message = "fatal: series index out of Bounds: " + seriesIndex;
            log.debugT("checkIndices", message);
            throw new IllegalArgumentException(message);
        }
        if (categoryIndex < 0 || categoryIndex >= this.categories.length) {
            String message = "fatal: category index out of Bounds: " + categoryIndex;
            log.debugT("checkIndices", message);
            throw new IllegalArgumentException(message);
        }
    }

    public void setPointValue(int seriesIndex, int categoryIndex, double value) {
        this.checkIndices(seriesIndex, categoryIndex);
        this.data[seriesIndex][categoryIndex].value = String.valueOf(value);
    }

    public void setPointValue(int seriesIndex, int categoryIndex, String value) {
        this.checkIndices(seriesIndex, categoryIndex);
        this.data[seriesIndex][categoryIndex].value = value;
    }

    public void setPointValue(int seriesIndex, int categoryIndex, double value, String label, String extension, String cuID) {
        this.setPointValue(seriesIndex, categoryIndex, String.valueOf(value), label, extension, cuID);
    }

    public void setPointValue(int seriesIndex, int categoryIndex, String value, String label, String extension, String cuID) {
        this.setPointValue(seriesIndex, categoryIndex, value);
        this.data[seriesIndex][categoryIndex].label = label;
        this.data[seriesIndex][categoryIndex].extension = extension;
        this.data[seriesIndex][categoryIndex].cuID = cuID;
    }

    public void setPointLabel(int seriesIndex, int categoryIndex, String label) {
        this.checkIndices(seriesIndex, categoryIndex);
        this.data[seriesIndex][categoryIndex].label = label;
    }

    public void setPointExtension(int seriesIndex, int categoryIndex, String extension) {
        this.checkIndices(seriesIndex, categoryIndex);
        this.data[seriesIndex][categoryIndex].extension = extension;
    }

    public void setPointCustomizing(int seriesIndex, int categoryIndex, String cuID) {
        this.checkIndices(seriesIndex, categoryIndex);
        this.data[seriesIndex][categoryIndex].cuID = cuID;
    }

    public void setCategoryExtension(int categoryIndex, String extension) {
        if (categoryIndex < 0 || categoryIndex >= this.categories.length) {
            String message = "fatal: category index out of Bounds: " + categoryIndex;
            log.debugT("setCategoryExtension", message);
            throw new IllegalArgumentException(message);
        }
        this.categories[categoryIndex].extension = extension;
    }

    public void setCategoryValue(int categoryIndex, String value) {
        if (categoryIndex < 0 || categoryIndex >= this.categories.length) {
            String message = "fatal: category index out of Bounds: " + categoryIndex;
            log.debugT("setCategoryExtension", message);
            throw new IllegalArgumentException(message);
        }
        this.categories[categoryIndex].value = value;
    }

    public void setSeriesLabel(int seriesIndex, String label) {
        if (seriesIndex < 0 || seriesIndex >= this.series.length) {
            String message = "fatal: series index out of Bounds: " + this.series;
            log.debugT("setSeriesExtension", message);
            throw new IllegalArgumentException(message);
        }
        this.series[seriesIndex].label = label;
    }

    public void setSeriesExtension(int seriesIndex, String extension) {
        if (seriesIndex < 0 || seriesIndex >= this.series.length) {
            String message = "fatal: series index out of Bounds: " + this.series;
            log.debugT("setSeriesExtension", message);
            throw new IllegalArgumentException(message);
        }
        this.series[seriesIndex].extension = extension;
    }

    public void setSeriesCustomizing(int seriesIndex, String cuID) {
        if (seriesIndex < 0 || seriesIndex >= this.series.length) {
            String message = "fatal: series index out of Bounds: " + this.series;
            log.debugT("setSeriesCustomizing", message);
            throw new IllegalArgumentException(message);
        }
        this.series[seriesIndex].cuId = cuID;
    }

    public String getData() {
        Document document = null;
        try {
            document = XmlUtil.createDocument();
        }
        catch (GraphicsException e) {
            String errorMessage = "fatal: XmlUtil.createDocument() failed";
            log.debugT("getData", errorMessage);
            return null;
        }
        Element root = document.createElement("ChartData");
        if (root == null) {
            String errorMessage = "fatal: creating of root element failed";
            log.debugT("getData", errorMessage);
            return null;
        }
        document.appendChild(root);
        try {
            Node categoriesNode = XmlUtil.appendNode(document.getDocumentElement(), "Categories");
            int i = 0;
            while (i < this.categories.length) {
                Element categoryNode = (Element)XmlUtil.appendNode(categoriesNode, "Category", this.categories[i].value);
                if (this.categories[i].extension != null) {
                    categoryNode.setAttribute("extension", this.categories[i].extension);
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.series.length) {
                Element seriesNode = (Element)XmlUtil.appendNode(document.getDocumentElement(), "Series");
                if (this.series[i2].label != null) {
                    seriesNode.setAttribute("label", this.series[i2].label);
                }
                if (this.series[i2].extension != null) {
                    seriesNode.setAttribute("extension", this.series[i2].extension);
                }
                if (this.series[i2].cuId != null) {
                    seriesNode.setAttribute("customizing", this.series[i2].cuId);
                }
                int j = 0;
                while (j < this.categories.length) {
                    Element pointNode = (Element)XmlUtil.appendNode(seriesNode, "Point");
                    if (this.data[i2][j].label != null) {
                        pointNode.setAttribute("label", this.data[i2][j].label);
                    }
                    if (this.data[i2][j].extension != null) {
                        pointNode.setAttribute("extension", this.data[i2][j].extension);
                    }
                    if (this.data[i2][j].cuID != null) {
                        pointNode.setAttribute("customizing", this.data[i2][j].cuID);
                    }
                    if (this.data[i2][j].value != null) {
                        Element valueNode = (Element)XmlUtil.appendNode(pointNode, "Value", String.valueOf(this.data[i2][j].value));
                        valueNode.setAttribute("type", "y");
                    }
                    ++j;
                }
                ++i2;
            }
        }
        catch (GraphicsException e) {
            log.debugT("getData", "fatal: failed to append nodes");
            return null;
        }
        String retVal = XmlUtil.serialize(document);
        if (this.finest) {
            log.debugT("getData", "data: " + retVal);
        }
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        className = "ChartDataContainer";
        log = Location.getLocation((String)(class$com$sap$tc$graphics$igs$ChartDataContainer == null ? (class$com$sap$tc$graphics$igs$ChartDataContainer = ChartDataContainer.class$("com.sap.tc.graphics.igs.ChartDataContainer")) : class$com$sap$tc$graphics$igs$ChartDataContainer).getName());
    }

    class Point {
        String value;
        String label;
        String extension;
        String cuID;

        Point() {
        }
    }

    class Series {
        String label;
        String extension;
        String cuId;

        Series() {
        }
    }

    class Category {
        String extension;
        String value;

        Category() {
        }
    }
}

