/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey;

import com.sap.security.core.server.likey.LogAndTrace;
import java.io.PrintStream;

public class StdLogAndTrace
implements LogAndTrace {
    private static boolean debug = false;
    private static final String PROP_NAME = "com.sap.security.core.server.likey.debug";
    private static final int LINELENGTH = 79;

    public StdLogAndTrace() {
        String value = System.getProperty(PROP_NAME);
        if (value != null && value.equals("1")) {
            debug = true;
        }
    }

    static void formatAndPrint(PrintStream stream, String msg) {
        msg = msg.trim();
        while (msg.length() > 79) {
            int lastWhitespace = 0;
            for (int index = 0; index <= 79; ++index) {
                if (!Character.isWhitespace(msg.charAt(index))) continue;
                lastWhitespace = index;
            }
            if (lastWhitespace == 0) {
                stream.println(msg.substring(0, 79));
                msg = msg.substring(79).trim();
                continue;
            }
            stream.println(msg.substring(0, lastWhitespace).trim());
            msg = msg.substring(lastWhitespace + 1).trim();
        }
        if (msg.length() > 0) {
            stream.println(msg);
        }
    }

    public void writeError(String msg) {
        StdLogAndTrace.formatAndPrint(System.err, msg);
    }

    public void writeTrace(String msg) {
        if (debug) {
            StdLogAndTrace.formatAndPrint(System.out, msg);
        }
    }

    public static void main(String[] args) {
        StdLogAndTrace lat = new StdLogAndTrace();
        lat.writeError("Hello, World!");
        String test = "123456789 ";
        test = test + test + test + test + test + test + test + test;
        lat.writeError(test);
        test = test + "123456789 ";
        lat.writeError(test);
        test = "1234567890";
        test = test + test + test + test + test + test + test + "12345678";
        lat.writeError(test);
        test = "1234567890";
        test = test + test + test + test + test + test + test + "123456789";
        lat.writeError(test);
        test = "1234567890";
        test = test + test + test + test + test + test + test + test;
        lat.writeError(test);
        test = test + "1";
        lat.writeError(test);
        test = "This is almost a story. It has to be very very long because of the required test. We already had quite a few shorter cases but never a case in which the message spans more than two lines. And the class must work in this case, too. Let's see whether it does...";
        lat.writeError(test);
    }
}

