/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.wizard;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.patternfwk.ISourcePatternWizard;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternExtender;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternManager;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternTypeExtender;
import com.sap.ide.tools.core.patternfwk.internal.SourceInfomation;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PatternSelectionPage
extends WizardPage {
    private SourcePatternExtender[] mPatternExtenders = null;
    private SourcePatternTypeExtender[] mPatternTypeExtenders = null;
    private SourceInfomation mSourceInformation = null;
    private SourcePatternManager mManager = null;
    private TreeViewer mTreeViewer = null;
    private SourcePatternExtender mSelectedSourcePatternExtender = null;

    public PatternSelectionPage(SourcePatternExtender[] patternExtenders, SourcePatternTypeExtender[] patternTypeExtenders, DevelopmentObject containingObject, SourcePatternManager manager) {
        super("Template Selection");
        this.mPatternExtenders = patternExtenders;
        this.mPatternTypeExtenders = patternTypeExtenders;
        this.mSourceInformation = new SourceInfomation(containingObject);
        this.mManager = manager;
        this.setTitle("Template Selection");
        this.setDescription("Select a template below.");
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        this.mTreeViewer = glp.addTreeViewer(false, gd);
        this.mTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mTreeViewer.setInput((Object)this);
        this.mTreeViewer.getTree().deselectAll();
        this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
        this.validatePage();
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        super.setErrorMessage(errorMessage);
    }

    public SourcePatternExtender getSelectedSourcePatternExtender() {
        return this.mSelectedSourcePatternExtender;
    }

    private boolean validatePage() {
        if (this.mSelectedSourcePatternExtender == null) {
            this.setErrorMessage("Please select a source template");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public IWizardPage getNextPage() {
        ISourcePatternWizard wizard;
        IWizardPage page = null;
        if (this.mSelectedSourcePatternExtender != null && (wizard = this.mSelectedSourcePatternExtender.getWizardClass()) != null) {
            page = wizard.getStartingPage();
        }
        return page;
    }

    private class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof SourcePatternExtender) {
                    PatternSelectionPage.this.mSelectedSourcePatternExtender = (SourcePatternExtender)selection.getFirstElement();
                } else {
                    PatternSelectionPage.this.mSelectedSourcePatternExtender = null;
                }
            }
            PatternSelectionPage.this.setPageComplete(PatternSelectionPage.this.validatePage());
            PatternSelectionPage.super.getContainer().updateButtons();
        }
    }

    private class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof SourcePatternExtender) {
                text = ((SourcePatternExtender)element).getName();
            } else if (element instanceof SourcePatternTypeExtender) {
                text = ((SourcePatternTypeExtender)element).getName();
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof SourcePatternTypeExtender) {
                ArrayList<Object> list = new ArrayList<Object>();
                SourcePatternTypeExtender extender = (SourcePatternTypeExtender)parentElement;
                int i = 0;
                while (i < PatternSelectionPage.this.mPatternTypeExtenders.length) {
                    if (extender.getID().equals(PatternSelectionPage.this.mPatternTypeExtenders[i].getParent())) {
                        list.add(PatternSelectionPage.this.mPatternTypeExtenders[i]);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < PatternSelectionPage.this.mPatternExtenders.length) {
                    if (extender.getID().equals(PatternSelectionPage.this.mPatternExtenders[i2].getParent()) && PatternSelectionPage.this.mPatternExtenders[i2].getImplementingClass().canContribute(PatternSelectionPage.this.mSourceInformation)) {
                        list.add(PatternSelectionPage.this.mPatternExtenders[i2]);
                    }
                    ++i2;
                }
                children = new Object[list.size()];
                children = list.toArray(children);
            }
            return children;
        }

        public Object getParent(Object element) {
            SourcePatternTypeExtender parent = null;
            if (element instanceof SourcePatternTypeExtender) {
                SourcePatternTypeExtender extender = (SourcePatternTypeExtender)element;
                String parentID = extender.getParent();
                parent = PatternSelectionPage.this.mManager.getSourcePatternTypeExtender(parentID);
            }
            return parent;
        }

        public boolean hasChildren(Object element) {
            return element instanceof SourcePatternTypeExtender;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (inputElement instanceof PatternSelectionPage) {
                int i = 0;
                while (i < PatternSelectionPage.this.mPatternTypeExtenders.length) {
                    if (PatternSelectionPage.this.mPatternTypeExtenders[i].getParent() == null) {
                        list.add(PatternSelectionPage.this.mPatternTypeExtenders[i]);
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < PatternSelectionPage.this.mPatternExtenders.length) {
                    if (PatternSelectionPage.this.mPatternExtenders[i2].getParent() == null && PatternSelectionPage.this.mPatternExtenders[i2].getImplementingClass().canContribute(PatternSelectionPage.this.mSourceInformation)) {
                        list.add(PatternSelectionPage.this.mPatternExtenders[i2]);
                    }
                    ++i2;
                }
            }
            Object[] elements = new Object[list.size()];
            elements = list.toArray(elements);
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

