/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.wizard;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternExtender;
import com.sap.ide.tools.core.patternfwk.internal.SourceInfomation;
import com.sap.ide.tools.core.patternfwk.selection.IListSelection;
import com.sap.ide.tools.core.patternfwk.wizard.ListWizardData;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ListWizardPage
extends WizardPage {
    private TreeViewer mTreeViewer = null;
    private SourcePatternExtender mSourcePatternExtender = null;
    private ListWizardData mData = null;
    private SourceInfomation mSourceInformation = null;

    public ListWizardPage(ListWizardData data, SourcePatternExtender sourcePatternExtender) {
        super("Object Selection");
        this.mData = data;
        this.mSourcePatternExtender = sourcePatternExtender;
        this.mSourceInformation = new SourceInfomation(this.mSourcePatternExtender.getContainingObject());
        this.setTitle("Object Selection");
        this.setDescription("Select an object below.");
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new FillLayout());
        this.setControl((Control)root);
        IGridLayoutPane glp = PaneFactory.createGridLayoutPane((Composite)root, (int)1);
        IGridLayoutData gd = glp.createGridLayoutData(4, 4, true, true);
        this.mTreeViewer = glp.addTreeViewer(false, gd);
        this.mTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mTreeViewer.setInput((Object)this);
        this.mTreeViewer.getTree().deselectAll();
        this.mTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeSelectionChangedListener());
        this.validatePage();
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        super.setErrorMessage(errorMessage);
    }

    private void validatePage() {
        if (this.mData.getSelectedObject() == null) {
            this.setErrorMessage("Please select an object.");
            return;
        }
        this.setErrorMessage(null);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private class TreeSelectionChangedListener
    implements ISelectionChangedListener {
        private TreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof StructuredSelection) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof DevelopmentObject) {
                    ListWizardPage.this.mData.setSelectedObject((DevelopmentObject)selection.getFirstElement());
                } else {
                    ListWizardPage.this.mData.setSelectedObject(null);
                }
            }
            ListWizardPage.this.validatePage();
        }
    }

    private class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof DevelopmentObject) {
                text = ((DevelopmentObject)element).getName();
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<DevelopmentObject> list = new ArrayList<DevelopmentObject>();
            if (inputElement instanceof ListWizardPage && ListWizardPage.this.mSourcePatternExtender.getImplementingClass() instanceof IListSelection) {
                IListSelection listSelection = (IListSelection)((Object)ListWizardPage.this.mSourcePatternExtender.getImplementingClass());
                DevelopmentObject[] objects = listSelection.getElements(ListWizardPage.this.mSourceInformation);
                int i = 0;
                while (i < objects.length) {
                    list.add(objects[i]);
                    ++i;
                }
            }
            Object[] elements = new Object[list.size()];
            elements = list.toArray(elements);
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

