/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.wizard;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.patternfwk.ISourcePattern;
import com.sap.ide.tools.core.patternfwk.ISourcePatternData;
import com.sap.ide.tools.core.patternfwk.ISourcePatternResult;
import com.sap.ide.tools.core.patternfwk.ISourcePatternWizard;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternExtender;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternManager;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternTypeExtender;
import com.sap.ide.tools.core.patternfwk.internal.SourceInfomation;
import com.sap.ide.tools.core.patternfwk.startup.SourcePatternService;
import com.sap.ide.tools.core.patternfwk.wizard.PatternSelectionPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CompleteSourcePatternWizard
extends Wizard {
    private SourcePatternManager mManager = null;
    private DevelopmentObject mContainingObject = null;
    private SourcePatternExtender[] mPatternExtenders = null;
    private SourcePatternTypeExtender[] mPatternTypeExtenders = null;
    private PatternSelectionPage mPatternSelectionPage = null;
    private ISourcePatternResult mPatternResult = null;

    public CompleteSourcePatternWizard() {
        this(null);
    }

    public CompleteSourcePatternWizard(DevelopmentObject containingObject) {
        this.mManager = new SourcePatternManager(containingObject);
        this.mPatternExtenders = this.mManager.getSourcePatternExtenders();
        this.mPatternTypeExtenders = this.mManager.getSourcePatternTypeExtenders();
        this.mContainingObject = containingObject;
        this.setWindowTitle("Web Dynpro Source Template Wizard");
        int i = 0;
        while (i < this.mPatternExtenders.length) {
            ISourcePatternWizard wizard = this.mPatternExtenders[i].getWizardClass();
            if (wizard != null) {
                wizard.setContainer(this.getContainer());
            }
            ++i;
        }
    }

    public boolean performFinish() {
        SourcePatternExtender extender = this.mPatternSelectionPage.getSelectedSourcePatternExtender();
        ISourcePatternWizard wizard = this.mPatternSelectionPage.getSelectedSourcePatternExtender().getWizardClass();
        if (wizard != null) {
            wizard.performFinish();
        }
        ISourcePatternData data = null;
        if (extender.getWizardClass() != null) {
            data = extender.getWizardClass().getData();
        }
        this.mPatternResult = SourcePatternService.generateSourcePatternResult(extender, data);
        return true;
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(true);
        this.mPatternSelectionPage = new PatternSelectionPage(this.mPatternExtenders, this.mPatternTypeExtenders, this.mContainingObject, this.mManager);
        this.addPage((IWizardPage)this.mPatternSelectionPage);
        int i = 0;
        while (i < this.mPatternExtenders.length) {
            ISourcePatternWizard wizard;
            ISourcePattern implementingClass = this.mPatternExtenders[i].getImplementingClass();
            if (implementingClass.canContribute(new SourceInfomation(this.mContainingObject)) && (wizard = this.mPatternExtenders[i].getWizardClass()) != null) {
                wizard.addPages();
                IWizardPage[] pages = wizard.getPages();
                int j = 0;
                while (j < pages.length) {
                    this.addPage(pages[j]);
                    ++j;
                }
                wizard.setContainingObject(this.mContainingObject);
            }
            ++i;
        }
    }

    public ISourcePatternResult getPatternResult() {
        return this.mPatternResult;
    }

    public boolean canFinish() {
        if (!this.mPatternSelectionPage.isPageComplete()) {
            return false;
        }
        ISourcePatternWizard wizard = this.mPatternSelectionPage.getSelectedSourcePatternExtender().getWizardClass();
        if (wizard != null) {
            return wizard.canFinish();
        }
        return true;
    }
}

