/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.internal;

import com.sap.ide.tools.core.patternfwk.ISourcePatternResult;
import com.sap.ide.tools.core.patternfwk.editor.ISourcePatternEditor;
import com.sap.ide.tools.core.patternfwk.internal.PatternFwkPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;

public class PatternResultHandler {
    private ISourcePatternEditor mEditor = null;
    private String mIndent = null;
    private String mLineDelimiter = null;
    private StyledText mText = null;
    private IDocument mDocument = null;

    public PatternResultHandler(ISourcePatternEditor editor) {
        this.mEditor = editor;
        this.initialize();
    }

    private void initialize() {
        this.mLineDelimiter = this.mEditor.getViewer().getTextWidget().getLineDelimiter();
        this.mText = this.mEditor.getViewer().getTextWidget();
        this.mDocument = this.mEditor.getViewer().getDocument();
        this.mIndent = this.getIndentString(this.mEditor.getViewer());
    }

    public void insertPatternResult(ISourcePatternResult result) {
        this.insertCoding(result.getCoding());
        this.insertImports(result.getImports());
    }

    private void insertCoding(String coding) {
        if (coding == null || coding.length() < 1) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(new StringReader(coding));
        try {
            String line = reader.readLine();
            if (line != null) {
                buffer.append(line);
            }
            while (reader.ready() && line != null) {
                line = reader.readLine();
                if (line == null) continue;
                buffer.append(this.mLineDelimiter);
                buffer.append(this.mIndent);
                buffer.append(line);
            }
        }
        catch (IOException e) {
            PatternFwkPlugin.internalError(this.getClass(), "insertCoding(String)", e.getMessage(), e, false);
            return;
        }
        if (this.mText != null) {
            try {
                this.mDocument.replace(this.mText.getCaretOffset(), this.mText.getSelectionCount(), buffer.toString());
            }
            catch (BadLocationException e) {
                PatternFwkPlugin.internalError(this.getClass(), "insertCoding(String)", e.getMessage(), e, false);
                return;
            }
        } else {
            PatternFwkPlugin.internalError(this.getClass(), "insertCoding(String)", "No active text widget found", new Exception(), false);
            return;
        }
    }

    private String getIndentString(ISourceViewer viewer) {
        String indent = "";
        if (this.mText != null) {
            int positionToInsert = this.mText.getCaretOffset();
            int line = this.mText.getLineAtOffset(positionToInsert);
            int positionAtLine = this.mText.getOffsetAtLine(line);
            String lineStart = this.mText.getTextRange(positionAtLine, positionToInsert - positionAtLine);
            char[] lineStartChar = lineStart.toCharArray();
            int index = 0;
            index = 0;
            while (index < lineStartChar.length) {
                if (lineStartChar[index] != ' ' && lineStartChar[index] != '\t') break;
                ++index;
            }
            indent = indent.concat(new String(lineStartChar, 0, index));
        }
        return indent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertImports(String[] imports) {
        IEditorInput input = this.mEditor.getEditorInput();
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        try {
            try {
                manager.connect(input);
                ICompilationUnit workingCopy = manager.getWorkingCopy(input);
                int i = 0;
                while (i < imports.length) {
                    workingCopy.createImport(imports[i], null, null);
                    ++i;
                }
            }
            catch (CoreException e) {
                PatternFwkPlugin.internalError(this.getClass(), "insertImports(String[])", e.getMessage(), e, false);
                Object var7_8 = null;
                manager.disconnect(input);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            manager.disconnect(input);
            throw throwable;
        }
        manager.disconnect(input);
    }

    private void setCursorPosition(int position) {
        this.mEditor.getViewer().setSelectedRange(position, 0);
    }
}

