/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.generation;

import com.sap.ide.generationfwk.GenerationBase;
import com.sap.ide.generationfwk.configuration.GenerationConfigurationBase;
import com.sap.ide.generationfwk.eclipse.GenerationFwkPlugin;
import com.sap.ide.generationfwk.eclipse.configuration.GenerationConfiguration;
import com.sap.ide.generationfwk.eclipse.marker.GenerationMarker;
import com.sap.ide.generationfwk.logging.ILogging;
import com.sap.ide.tools.core.patternfwk.ISourcePatternData;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternExtender;
import com.sap.ide.tools.core.patternfwk.generation.GenerationPluginDataProvider;
import com.sap.ide.tools.core.patternfwk.internal.PatternFwkPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class GenerationEclipse
extends GenerationBase {
    public static final String EXTENSION_POINT_ID_PATTERN_GENERATION = "com.sap.ide.tools.core.patternfwk.GenerationPluginDataProvider";
    public static final String GENERATION_TEMPLATE_ID_PREFIX = "PatternFWK_";
    public static final String CONTEXT_ID_DATA = "dataClass";
    private IProgressMonitor mProgessMonitor = new NullProgressMonitor();
    private int mProgress = 0;
    private static boolean mErrorIndicator = false;

    public GenerationEclipse(IProgressMonitor monitor) {
        super(2);
        this.setErrorIndicator(false);
        this.setExtensionId(EXTENSION_POINT_ID_PATTERN_GENERATION);
        this.setConfiguration((GenerationConfigurationBase)new GenerationConfiguration(GenerationFwkPlugin.getInstance().getGenerationDataProvider(this.getExtensionId()), (ILogging)this));
        this.setProgressMonitor(monitor);
        GenerationMarker.deleteProblemMarkers((String)PatternFwkPlugin.getPluginId(), (IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    public GenerationPluginDataProvider getGenerationPluginDataProvider() {
        return (GenerationPluginDataProvider)GenerationFwkPlugin.getInstance().getGenerationDataProvider(this.getExtensionId());
    }

    public final String generateTransientSourcePattern(SourcePatternExtender extender, ISourcePatternData data) {
        HashMap<String, ISourcePatternData> context = new HashMap<String, ISourcePatternData>();
        context.put(CONTEXT_ID_DATA, data);
        return this.doTransientGeneration(extender.getGenerationTemplateId(), context, extender.getName());
    }

    public final void printMessage(int category, String messageText) {
        try {
            switch (category) {
                case 1: {
                    if (this.isLogging()) {
                        this.getProgressMonitor().subTask(messageText);
                        ++this.mProgress;
                        this.getProgressMonitor().worked(this.mProgress);
                    }
                    break;
                }
                case 3: {
                    if (this.isLogging()) {
                        GenerationMarker.createMarker((String)PatternFwkPlugin.getPluginId(), null, (int)1, (String)(this.getGenerationConfiguration().getId() + ": " + messageText));
                        this.getProgressMonitor().subTask(messageText);
                    }
                    break;
                }
                case 2: {
                    this.setErrorIndicator(true);
                    GenerationMarker.createMarker((String)PatternFwkPlugin.getPluginId(), null, (int)2, (String)(this.getGenerationConfiguration().getId() + ": " + messageText));
                    this.getProgressMonitor().subTask(messageText);
                    break;
                }
                default: {
                    if (this.isLogging()) {
                        this.getProgressMonitor().subTask(messageText);
                        ++this.mProgress;
                        this.getProgressMonitor().worked(this.mProgress);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            PatternFwkPlugin.internalError(((Object)((Object)this)).getClass(), "printMessage(int, String)", "Log entry could not created with message \"" + this.getGenerationConfiguration().getId() + ": " + messageText, e, true);
        }
    }

    private void setProgressMonitor(IProgressMonitor monitor) {
        if (monitor != null) {
            this.mProgessMonitor = monitor;
        }
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.mProgessMonitor;
    }

    protected final void setErrorIndicator(boolean errorIndicator) {
        mErrorIndicator = errorIndicator;
    }

    public static final boolean isErrorIndicator() {
        return mErrorIndicator;
    }
}

