/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.extensionmanagement;

import com.sap.ide.generationfwk.eclipse.configuration.GenerationConfiguration;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternExtender;
import com.sap.ide.tools.core.patternfwk.extensionmanagement.SourcePatternTypeExtender;
import com.sap.ide.tools.core.patternfwk.generation.GenerationEclipse;
import com.sap.ide.tools.core.patternfwk.internal.PatternFwkPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SourcePatternManager {
    private static final String EXTENSION_PATTERN = "pattern";
    private static final String EXTENSION_PATTERN_TYPE = "patternType";
    private static SourcePatternManager mInstance = null;
    private IConfigurationElement[] mExtenders = this.getValidExtensions();
    private SourcePatternExtender[] mSourcePatterns = null;
    private SourcePatternTypeExtender[] mSourcePatternTypes = null;
    private DevelopmentObject mContainingObject = null;
    private GenerationEclipse mGenerationEclipse = null;
    private GenerationConfiguration mGenerationConfiguration = null;

    public SourcePatternManager(DevelopmentObject containingObject) {
        this.mContainingObject = containingObject;
        this.mGenerationEclipse = new GenerationEclipse((IProgressMonitor)new NullProgressMonitor());
        this.mGenerationConfiguration = (GenerationConfiguration)this.mGenerationEclipse.getGenerationConfiguration();
        this.mGenerationConfiguration.setId("com.sap.ide.tools.core.patternfwk.GenerationPluginDataProvider");
        this.initializeSourcePatterns();
    }

    private IConfigurationElement[] getValidExtensions() {
        ArrayList<IConfigurationElement> patternList = new ArrayList<IConfigurationElement>();
        PatternFwkPlugin plugin = PatternFwkPlugin.getDefault();
        IExtensionPoint extensionPoint = plugin.getDescriptor().getExtensionPoint("sourcepattern");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if (this.checkExtendingElement(elements[j])) {
                        patternList.add(elements[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        IConfigurationElement[] extenders = new IConfigurationElement[patternList.size()];
        extenders = patternList.toArray(extenders);
        return extenders;
    }

    private boolean checkExtendingElement(IConfigurationElement element) {
        return true;
    }

    private void initializeSourcePatterns() {
        ArrayList<Object> patternList = new ArrayList<Object>();
        ArrayList<Object> typeList = new ArrayList<Object>();
        int i = 0;
        while (i < this.mExtenders.length) {
            Object extender;
            if (this.mExtenders[i].getName().equals(EXTENSION_PATTERN)) {
                extender = new SourcePatternExtender(this.mExtenders[i], this.mContainingObject, this.mGenerationEclipse, this.mGenerationConfiguration);
                if (((SourcePatternExtender)extender).isValid()) {
                    patternList.add(extender);
                }
            } else if (this.mExtenders[i].getName().equals(EXTENSION_PATTERN_TYPE) && ((SourcePatternTypeExtender)(extender = new SourcePatternTypeExtender(this.mExtenders[i]))).isValid()) {
                typeList.add(extender);
            }
            ++i;
        }
        this.mSourcePatterns = new SourcePatternExtender[patternList.size()];
        this.mSourcePatterns = patternList.toArray(this.mSourcePatterns);
        this.mSourcePatternTypes = new SourcePatternTypeExtender[typeList.size()];
        this.mSourcePatternTypes = typeList.toArray(this.mSourcePatternTypes);
    }

    public SourcePatternExtender[] getSourcePatternExtenders() {
        return this.mSourcePatterns;
    }

    public SourcePatternExtender getSourcePatternExtender(String id) {
        int i = 0;
        while (i < this.mSourcePatterns.length) {
            if (this.mSourcePatterns[i].getId().equals(id)) {
                return this.mSourcePatterns[i];
            }
            ++i;
        }
        return null;
    }

    public SourcePatternTypeExtender[] getSourcePatternTypeExtenders() {
        return this.mSourcePatternTypes;
    }

    public SourcePatternTypeExtender getSourcePatternTypeExtender(String id) {
        int i = 0;
        while (i < this.mSourcePatternTypes.length) {
            if (this.mSourcePatternTypes[i].getID().equals(id)) {
                return this.mSourcePatternTypes[i];
            }
            ++i;
        }
        return null;
    }
}

