/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.tools.core.patternfwk.extensionmanagement;

import com.sap.ide.generationfwk.eclipse.configuration.GenerationConfiguration;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.tools.core.patternfwk.ISourcePattern;
import com.sap.ide.tools.core.patternfwk.ISourcePatternWizard;
import com.sap.ide.tools.core.patternfwk.generation.GenerationEclipse;
import com.sap.ide.tools.core.patternfwk.internal.PatternFwkPlugin;
import com.sap.ide.tools.core.patternfwk.wizard.ListWizard;
import com.sap.ide.tools.core.patternfwk.wizard.TreeWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class SourcePatternExtender {
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SELECTION = "selection";
    private static final String ATTRIBUTE_WIZARD_CLASS = "wizardClass";
    private static final String ATTRIBUTE_PARENT = "parent";
    private static final String ATTRIBUTE_SOURCE_TEMPLATE = "sourceTemplate";
    private static final String ATTRIBUTE_SOURCE_TEMPLATE_HELPER = "templateHelper";
    public static final String SELECTION_NONE = "none";
    public static final String SELECTION_LIST = "list";
    public static final String SELECTION_TREE = "tree";
    public static final String SELECTION_WIZARD = "wizard";
    private IConfigurationElement mConfigurationElement = null;
    private ISourcePattern mSourcePatternClass = null;
    private ISourcePatternWizard mSourcePatternWizard = null;
    private DevelopmentObject mContainingObject = null;
    private GenerationEclipse mGenerationEclipse = null;
    private GenerationConfiguration mGenerationConfiguration = null;

    public SourcePatternExtender(IConfigurationElement element, DevelopmentObject containingObject, GenerationEclipse generationEclipse, GenerationConfiguration generationConfiguration) {
        this.mConfigurationElement = element;
        this.mSourcePatternClass = this.getSourcePatternClass(this.mConfigurationElement);
        this.mContainingObject = containingObject;
        this.mGenerationEclipse = generationEclipse;
        this.mGenerationConfiguration = generationConfiguration;
        this.mSourcePatternWizard = this.getSourcePatternWizardClass(this.mConfigurationElement);
        this.initializeGenerationTemplate();
    }

    public boolean isValid() {
        return this.mSourcePatternClass != null;
    }

    public DevelopmentObject getContainingObject() {
        return this.mContainingObject;
    }

    private ISourcePattern getSourcePatternClass(IConfigurationElement element) {
        ISourcePattern sourcePattern = null;
        Object object = null;
        try {
            object = element.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (CoreException e) {
            PatternFwkPlugin.internalError(this.getClass(), "getSourcePatternClass(IConfigurationElement)", e.getMessage(), e, false);
        }
        if (object instanceof ISourcePattern) {
            sourcePattern = (ISourcePattern)object;
        }
        return sourcePattern;
    }

    private ISourcePatternWizard getSourcePatternWizardClass(IConfigurationElement element) {
        ISourcePatternWizard sourcePatternWizard = null;
        String selection = element.getAttribute(ATTRIBUTE_SELECTION);
        if (selection != null && !selection.equals(SELECTION_NONE)) {
            if (selection.equals(SELECTION_LIST)) {
                sourcePatternWizard = new ListWizard(this);
            } else if (selection.equals(SELECTION_TREE)) {
                sourcePatternWizard = new TreeWizard(this);
            } else if (selection.equals(SELECTION_WIZARD)) {
                Object object = null;
                try {
                    object = element.createExecutableExtension(ATTRIBUTE_WIZARD_CLASS);
                }
                catch (CoreException e) {
                    PatternFwkPlugin.internalError(this.getClass(), "initializeSourcePatternWizardClass(IConfigurationElement)", e.getMessage(), e, false);
                }
                if (object instanceof ISourcePatternWizard) {
                    sourcePatternWizard = (ISourcePatternWizard)object;
                }
            }
        }
        return sourcePatternWizard;
    }

    private void initializeGenerationTemplate() {
        String templateName = this.getSourcePatternTemplateName();
        if (templateName != null) {
            this.mGenerationConfiguration.getGenerationUnits().add(this.mGenerationConfiguration.createGenerationUnitForTemplate(this.getGenerationTemplateId(), templateName, "resource", this.getGenerationTemplateHelper(), "UTF-8", "UTF-8"));
        }
    }

    public String getId() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_ID);
    }

    public String getName() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_NAME);
    }

    public ISourcePattern getImplementingClass() {
        return this.mSourcePatternClass;
    }

    public String getSelection() {
        String selection = this.mConfigurationElement.getAttribute(ATTRIBUTE_SELECTION);
        if (selection == null) {
            selection = SELECTION_NONE;
        }
        return selection;
    }

    public ISourcePatternWizard getWizardClass() {
        return this.mSourcePatternWizard;
    }

    public String getParent() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_PARENT);
    }

    public String getSourcePatternTemplateName() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_SOURCE_TEMPLATE);
    }

    public String getGenerationTemplateId() {
        return "PatternFWK_" + this.getId();
    }

    public String getGenerationTemplateHelper() {
        return this.mConfigurationElement.getAttribute(ATTRIBUTE_SOURCE_TEMPLATE_HELPER);
    }

    public GenerationEclipse getGenerationEclipse() {
        return this.mGenerationEclipse;
    }
}

