/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.CatalogsContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.CubesContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.DataSourcesContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.DatasetContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.DimensionsContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.DiscoverPropertiesContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.HierarchiesContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.LevelsContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.MeasuresContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.MembersContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.MyErrorHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.PropertiesContentHandler;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.SAPVariablesContentHandler;
import com.sap.ip.bi.sdk.dac.result.impl.BIDataSet;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XmlaParser {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaParser == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaParser = XmlaParser.class$("com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaParser")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaParser).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIConnectionInfo connectionInfo;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$XmlaParser;

    public XmlaParser(IBIConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    BIDataSet parse(BIDataSet dataset, InputSource is) throws BIResourceException {
        DatasetContentHandler datasetContent = new DatasetContentHandler(this.connectionInfo);
        datasetContent.setDataset(dataset);
        this.parse(datasetContent, is);
        return datasetContent.getDataset();
    }

    void parseCatalogs(List catalogs, InputSource is) throws BIResourceException {
        CatalogsContentHandler ch = new CatalogsContentHandler();
        ch.setCatalogs(catalogs);
        this.parse(ch, is);
    }

    void parseCubes(List cubes, InputSource is) throws BIResourceException {
        CubesContentHandler ch = new CubesContentHandler();
        ch.setCubes(cubes);
        this.parse(ch, is);
    }

    void parseDimensions(List dimensions, InputSource is) throws BIResourceException {
        DimensionsContentHandler ch = new DimensionsContentHandler();
        ch.setDimensions(dimensions);
        this.parse(ch, is);
    }

    void parseSAPVariables(List sapVariables, InputSource is) throws BIResourceException {
        SAPVariablesContentHandler ch = new SAPVariablesContentHandler();
        ch.setSAPVariables(sapVariables);
        this.parse(ch, is);
    }

    void parseHierarchies(List hierarchies, InputSource is) throws BIResourceException {
        HierarchiesContentHandler ch = new HierarchiesContentHandler();
        ch.setHierarchies(hierarchies);
        this.parse(ch, is);
    }

    void parseLevels(List levels, InputSource is) throws BIResourceException {
        LevelsContentHandler ch = new LevelsContentHandler();
        ch.setLevels(levels);
        this.parse(ch, is);
    }

    void parseMeasures(List measures, InputSource is) throws BIResourceException {
        MeasuresContentHandler ch = new MeasuresContentHandler();
        ch.setMeasures(measures);
        this.parse(ch, is);
    }

    void parseMembers(List members, InputSource is) throws BIResourceException {
        MembersContentHandler ch = new MembersContentHandler();
        ch.setMembers(members);
        this.parse(ch, is);
    }

    void parseProperties(List properties, InputSource is) throws BIResourceException {
        PropertiesContentHandler ch = new PropertiesContentHandler();
        ch.setProperties(properties);
        this.parse(ch, is);
    }

    String parseDataSources(InputSource is) throws BIResourceException {
        DataSourcesContentHandler ch = new DataSourcesContentHandler();
        ArrayList list = new ArrayList();
        ch.setProviders(list);
        this.parse(ch, is);
        if (list.size() >= 1) {
            return (String)list.get(0);
        }
        return "";
    }

    String parseProviderName(InputSource is) throws BIResourceException {
        DiscoverPropertiesContentHandler ch = new DiscoverPropertiesContentHandler();
        ArrayList list = new ArrayList();
        ch.setProviders(list);
        this.parse(ch, is);
        if (list.size() >= 1) {
            return (String)list.get(0);
        }
        return "";
    }

    private void parse(ContentHandler contentHandler, InputSource p0) throws BIResourceException {
        MyErrorHandler errorHandler = new MyErrorHandler();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                SAXParserFactory factory = null;
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setContentHandler(contentHandler);
                reader.setErrorHandler(errorHandler);
                reader.parse(p0);
            }
            catch (Exception e) {
                cat.errorT(loc, "Parser fails, xml source: " + p0.toString());
                throw new BIResourceException(this.connectionInfo.getLocale(), cat, 500, loc, "sdk.dac.connector.xmla_1005", (Throwable)e);
            }
            Object var9_9 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

