/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.BIRestriction;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMDRConnectionRelational;
import com.sap.ip.bi.sdk.dac.connector.relational.schema.TableType;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class XmlaMDRConnectionRelational
extends OlapMDRConnectionRelational {
    public XmlaMDRConnectionRelational(CommonConnection connection, IBIConnectionInfo connectionInfo) throws BIResourceException {
        super(connection, connectionInfo);
    }

    protected OlapMDRConnectionRelational.RemappedRecordSet getCatalogRecordSet() throws BIResourceException {
        return new XmlaRemappedRecordSet(((Connection)this.connection).discoverSchemaRowsetasList("MDSCHEMA_CUBES"));
    }

    protected OlapMDRConnectionRelational.RemappedRecordSet getDimensionRecordSet(String catalogName, String schemaName, String tableName) throws BIResourceException {
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("CATALOG_NAME", catalogName));
        res.add(new BIRestriction("CUBE_NAME", tableName));
        return new XmlaRemappedRecordSet(((Connection)this.connection).discoverSchemaRowsetasList("MDSCHEMA_DIMENSIONS", res));
    }

    protected OlapMDRConnectionRelational.RemappedRecordSet getLevelRecordSet(String catalogName, String schemaName, String tableName) throws BIResourceException {
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("CATALOG_NAME", catalogName));
        res.add(new BIRestriction("CUBE_NAME", tableName));
        return new XmlaRemappedRecordSet(((Connection)this.connection).discoverSchemaRowsetasList("MDSCHEMA_LEVELS", res));
    }

    protected OlapMDRConnectionRelational.RemappedRecordSet getMeasureRecordSet(String catalogName, String schemaName, String tableName) throws BIResourceException {
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("CATALOG_NAME", catalogName));
        res.add(new BIRestriction("CUBE_NAME", tableName));
        return new XmlaRemappedRecordSet(((Connection)this.connection).discoverSchemaRowsetasList("MDSCHEMA_MEASURES", res));
    }

    protected OlapMDRConnectionRelational.RemappedRecordSet getTableRecordSet(String catalog, String schemaPattern, String tableNamePattern, TableType[] type) throws BIResourceException {
        return new XmlaRemappedRecordSet(((Connection)this.connection).discoverSchemaRowsetasList("MDSCHEMA_CUBES"));
    }

    class XmlaRemappedRecordSet
    implements OlapMDRConnectionRelational.RemappedRecordSet {
        private final List mapList;
        private int index = -1;

        public XmlaRemappedRecordSet(List mapList) throws BIResourceException {
            this.mapList = mapList;
        }

        public void first() throws BIResourceException {
            this.index = 0;
        }

        public int getInt(String key) throws BIResourceException {
            return Integer.parseInt((String)((HashMap)this.mapList.get(this.index)).get(key));
        }

        public short getShort(String key) throws BIResourceException {
            return Short.parseShort((String)((HashMap)this.mapList.get(this.index)).get(key));
        }

        public String getString(String key) throws BIResourceException {
            return (String)((HashMap)this.mapList.get(this.index)).get(key);
        }

        public boolean hasNext() throws BIResourceException {
            return this.mapList != null && this.index < this.mapList.size();
        }

        public void next() throws BIResourceException {
            ++this.index;
        }
    }
}

