/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.AxisData;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.CellData;
import com.sap.ip.bi.sdk.dac.result.IBICellStatus;
import com.sap.ip.bi.sdk.dac.result.impl.BIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSet;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DatasetContentHandler
implements ContentHandler {
    private static final String AXIS = "AXIS";
    private static final String ROW_AXIS = "1";
    private static final String COL_AXIS = "0";
    private static IBIAxisCursor rowCursor;
    private static IBIAxisCursor colCursor;
    private BIDataSet dataset;
    private AxisData axisData;
    private AxisData rowData;
    private AxisData colData;
    private CellData cellData;
    private Object[] cellData_v = new Object[4];
    private Hashtable hashTable = new Hashtable();
    private HashMap memberTypes = new HashMap();
    private HashMap cellDataTypes = new HashMap();
    private String valueStr;
    private int valueDataType;
    private boolean cellTypeLookup;
    private String memberValue = "";
    private boolean isInDataDefinition;
    private boolean isInOlapInfo;
    private boolean isInAxes;
    private boolean isInCellData;
    private boolean isInMemberType;
    private boolean isInCellDataType;
    private int complexTypeStartCount;
    private boolean isInAxesInfo;
    private boolean isInHierarchyInfo;
    private boolean isInCellInfo;
    private boolean isInSlicer;
    private boolean isInAxis;
    private boolean isInTuples;
    private boolean isInTuple;
    private boolean isInMember;
    private boolean isInCrossProduct;
    private int crossProductSize;
    private boolean isInCell;
    private boolean isInCellValue;
    private int cellOrdinal;
    private int cellLastOrdinal;
    private String axisMemberName;
    private static final Location loc;
    private static final Category cat;
    private IBIConnectionInfo connectionInfo;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$DatasetContentHandler;

    public DatasetContentHandler(IBIConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.rowData = new AxisData(connectionInfo);
        this.colData = new AxisData(connectionInfo);
        this.cellData = new CellData(connectionInfo);
    }

    public void setDataset(BIDataSet dataset) {
        this.dataset = dataset;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.isInDataDefinition = false;
        this.isInOlapInfo = false;
        this.isInAxes = false;
        this.isInCellData = false;
        this.isInMemberType = false;
        this.isInCellDataType = false;
        this.isInAxesInfo = false;
        this.isInHierarchyInfo = false;
        this.isInCellInfo = false;
        this.isInSlicer = false;
        this.isInAxis = false;
        this.isInTuples = false;
        this.isInTuple = false;
        this.isInMember = false;
        this.isInCrossProduct = false;
        this.isInCell = false;
        this.isInCellValue = false;
        this.cellOrdinal = -1;
        this.cellLastOrdinal = -1;
        this.crossProductSize = 0;
        this.complexTypeStartCount = 0;
    }

    public void endDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        loc.debugT(cat, "startElement::name space URI:" + namespaceURI + "," + "localName:" + localName + "," + "rawName:" + rawName);
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                loc.debugT(cat, "Attributes:" + i + ":" + atts.getValue(i));
                ++i;
            }
        }
        if (!this.isInDataDefinition && (localName.equals("schema") || localName.equals("xsd:schema"))) {
            this.isInDataDefinition = true;
            return;
        }
        if (!this.isInOlapInfo && localName.equals("OlapInfo")) {
            this.isInOlapInfo = true;
            return;
        }
        if (!this.isInAxes && localName.equals("Axes")) {
            this.isInAxes = true;
            return;
        }
        if (!this.isInCellData && localName.equals("CellData")) {
            this.isInCellData = true;
            return;
        }
        if (this.isInDataDefinition) {
            if (localName.equals("complexType") || localName.equals("xsd:complexType")) {
                if (this.isInMemberType || this.isInCellDataType) {
                    ++this.complexTypeStartCount;
                    return;
                }
                String nameValue = atts.getValue("name");
                if (nameValue == null) {
                    return;
                }
                if (nameValue.equals("MemberType")) {
                    this.isInMemberType = true;
                    return;
                }
                if (!nameValue.equals("CellData")) return;
                this.isInCellDataType = true;
                return;
            }
            if (!localName.equals("element")) {
                if (!localName.equals("xsd:element")) return;
            }
            if (this.isInMemberType) {
                this.memberTypes.put(atts.getValue("name"), new Integer(this.getSQLDataType(atts.getValue("type").substring(4))));
                return;
            }
            if (!this.isInCellDataType) return;
            String cellType = "";
            if (atts.getValue("type") != null) {
                cellType = atts.getValue("type").substring(4);
            }
            this.cellDataTypes.put(atts.getValue("name"), new Integer(this.getSQLDataType(cellType)));
            return;
        }
        if (this.isInOlapInfo) {
            if (localName.equals("AxesInfo")) {
                this.isInAxesInfo = true;
                return;
            }
            if (localName.equals("CellInfo")) {
                this.isInCellInfo = true;
                this.cellData.setCellTypes(this.cellDataTypes);
                return;
            }
            if (!this.isInAxesInfo) {
                if (!this.isInCellInfo) return;
                this.cellData.setupTempMetaData(localName, atts.getValue("name"));
                return;
            }
            if (localName.equals("AxisInfo")) {
                String axisname = atts.getValue("name");
                if (!axisname.startsWith("Axis")) {
                    this.isInSlicer = true;
                    return;
                }
                int axisNo = Integer.parseInt(axisname = axisname.substring(4));
                if (axisNo == 0) {
                    this.hashTable.put(axisname, this.colData);
                    this.axisData = this.colData;
                } else if (axisNo == 1) {
                    this.hashTable.put(axisname, this.rowData);
                    this.axisData = this.rowData;
                } else {
                    AxisData axisData = new AxisData(this.connectionInfo);
                    this.hashTable.put(axisname, axisData);
                    this.axisData = axisData;
                }
                this.axisData.setMemberTypes(this.memberTypes);
                return;
            }
            if (localName.equals("HierarchyInfo") && !this.isInSlicer) {
                this.axisMemberName = atts.getValue("name");
                this.axisData.addAxisMember(this.axisMemberName);
                this.isInHierarchyInfo = true;
                return;
            }
            if (!this.isInHierarchyInfo) return;
            if (this.isInSlicer) return;
            String keyname = atts.getValue("name");
            this.axisData.setupTempMetaData(this.axisMemberName, localName, keyname);
            return;
        }
        if (this.isInAxes) {
            if (localName.equals("Axis")) {
                String axisname = atts.getValue("name");
                if (axisname.startsWith("Axis")) {
                    axisname = axisname.substring(4);
                    this.axisData = (AxisData)this.hashTable.get(axisname);
                    return;
                }
                this.isInSlicer = true;
                return;
            }
            if (localName.equals("Tuples")) {
                this.isInTuples = true;
                return;
            }
            if (localName.equals("CrossProduct")) {
                this.crossProductSize = Integer.parseInt(atts.getValue("Size"));
                this.isInCrossProduct = true;
                return;
            }
            if (localName.equals("Members") && this.isInCrossProduct) {
                this.axisMemberName = atts.getValue("Hierarchy");
            } else {
                if (localName.equals("Member") && this.isInCrossProduct && !this.isInSlicer) {
                    this.isInMember = true;
                    return;
                }
                if (localName.equals("Member") && this.isInTuples && !this.isInSlicer) {
                    this.axisMemberName = atts.getValue("Hierarchy");
                    this.isInMember = true;
                    return;
                }
            }
            if (!this.isInMember) return;
            this.memberValue = "";
            return;
        }
        if (!this.isInCellData) return;
        if (localName.equals("Cell")) {
            String ato = atts.getValue("CellOrdinal");
            this.cellOrdinal = Integer.parseInt(ato.trim());
            this.isInCellValue = true;
            return;
        }
        if (!this.isInCellValue) return;
        String attValue = atts.getValue("xsi:type");
        if (attValue != null) {
            this.valueDataType = this.getSQLDataType(attValue.substring(4));
            this.cellTypeLookup = false;
            return;
        }
        this.cellTypeLookup = true;
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        loc.debugT(cat, "endElement::name space URI:" + namespaceURI + "," + "localName:" + localName + "," + "rawName:" + rawName);
        if (this.isInDataDefinition && (localName.equals("schema") || localName.equals("xsd:schema"))) {
            this.isInDataDefinition = false;
            return;
        }
        if (this.isInOlapInfo && localName.equals("OlapInfo")) {
            this.isInOlapInfo = false;
            return;
        }
        if (this.isInAxes && localName.equals("Axes")) {
            this.isInAxes = false;
            return;
        }
        if (this.isInCellData && localName.equals("CellData")) {
            this.isInCellData = false;
            this.cellData.setupcellsData();
            return;
        }
        if (this.isInDataDefinition) {
            if (localName.equals("complexType") || localName.equals("xsd:complexType")) {
                if (this.complexTypeStartCount > 0) {
                    --this.complexTypeStartCount;
                    return;
                }
                if (this.isInMemberType) {
                    this.isInMemberType = false;
                    return;
                }
                if (this.isInCellDataType) {
                    this.isInCellDataType = false;
                    return;
                }
                return;
            }
        } else if (this.isInOlapInfo) {
            if (localName.equals("AxesInfo")) {
                this.isInAxesInfo = false;
                return;
            }
            if (localName.equals("CellInfo")) {
                this.cellData.setupCellsMetaData();
                this.isInCellInfo = false;
                return;
            }
            if (localName.equals("AxisInfo")) {
                if (!this.isInSlicer) {
                    this.axisData.setupAxisMetaData();
                } else {
                    this.isInSlicer = false;
                }
                return;
            }
            if (localName.equals("HierarchyInfo")) {
                this.isInHierarchyInfo = false;
                return;
            }
        } else if (this.isInAxes) {
            if (localName.equals("Tuples")) {
                this.isInTuples = false;
                return;
            }
            if (localName.equals("CrossProduct")) {
                this.isInCrossProduct = false;
                if (!this.isInSlicer) {
                    this.axisData.calculateCrossJoin(this.crossProductSize);
                }
                this.crossProductSize = 0;
                return;
            }
            if (this.isInTuples) {
                if (localName.equals("Member")) {
                    this.isInMember = false;
                    return;
                }
                if (localName.equals("Tuple")) {
                    if (!this.isInSlicer) {
                        this.axisData.addMemberToArray();
                    }
                } else if (this.isInMember) {
                    this.axisData.addMemberDataToArray(this.axisMemberName, this.memberValue, localName);
                }
            } else if (this.isInCrossProduct) {
                if (localName.equals("Member")) {
                    this.axisData.addMemberCP(this.axisMemberName);
                    this.isInMember = false;
                    return;
                }
                if (!localName.equals("Members") && this.isInMember) {
                    this.axisData.addMemberDataToArray(this.axisMemberName, this.memberValue, localName);
                }
            } else if (localName.equals("Axis")) {
                if (this.isInSlicer) {
                    this.isInSlicer = false;
                } else {
                    this.axisData.setupAxisData();
                }
            }
        } else if (this.isInCellData) {
            if (localName.equals("Cell")) {
                while (this.cellOrdinal > this.cellLastOrdinal + 1) {
                    Object[] cell = new Object[this.cellData.getCellsMataData().length];
                    cell[2] = IBICellStatus.NULL;
                    this.cellData.addToDataArray(cell);
                    ++this.cellLastOrdinal;
                }
                this.cellData.addToDataArray(this.cellData_v);
                this.cellData_v = new Object[4];
                this.cellLastOrdinal = this.cellOrdinal;
                this.cellOrdinal = -1;
                this.isInCellValue = false;
            } else if (this.isInCellValue && this.cellOrdinal != -1) {
                if (localName.equals("Value")) {
                    this.cellData_v[0] = DatasetContentHandler.getValueObject(this.valueStr, this.valueDataType);
                    this.cellData_v[1] = new Integer(this.valueDataType);
                    this.cellData_v[2] = IBICellStatus.OK;
                } else if (localName.equals("FmtValue")) {
                    this.cellData_v[3] = DatasetContentHandler.getValueObject(this.valueStr, 12);
                } else {
                    int size = this.cellData_v.length;
                    Object[] tempCellData = new Object[size + 1];
                    System.arraycopy(this.cellData_v, 0, tempCellData, 0, size);
                    tempCellData[size] = DatasetContentHandler.getValueObject(this.valueStr, this.getCellDataType(localName));
                    this.cellData_v = tempCellData;
                }
            }
        } else if (localName.equals("root")) {
            try {
                this.dataset = new BIDataSet(this.connectionInfo, this.cellData.getCellsData(), this.cellData.getCellsMataData(), IBIResultSet.Type.ACCESS, true, false);
                int offset = 0;
                int n = this.hashTable.size() - 1;
                while (n >= 0) {
                    if (n == Integer.parseInt(COL_AXIS)) {
                        this.colData = (AxisData)this.hashTable.get(COL_AXIS);
                        colCursor = this.dataset.createAxisCursor(this.colData.getAxisData(), this.colData.getAxisMataData());
                        offset = 0;
                        int i = 0;
                        while (i < this.colData.getAxisMemberCount()) {
                            colCursor.createDimensionCursor(this.colData.getAxisMemberName(i), offset, this.colData.getAxisMemberSize(i));
                            offset += this.colData.getAxisMemberSize(i);
                            ++i;
                        }
                    } else if (n == Integer.parseInt(ROW_AXIS)) {
                        this.rowData = (AxisData)this.hashTable.get(ROW_AXIS);
                        if (this.rowData != null) {
                            rowCursor = this.dataset.createAxisCursor(this.rowData.getAxisData(), this.rowData.getAxisMataData());
                            offset = 0;
                            int i = 0;
                            while (i < this.rowData.getAxisMemberCount()) {
                                rowCursor.createDimensionCursor(this.rowData.getAxisMemberName(i), offset, this.rowData.getAxisMemberSize(i));
                                offset += this.rowData.getAxisMemberSize(i);
                                ++i;
                            }
                        }
                    } else {
                        String axisName = String.valueOf(n).trim();
                        AxisData axisData = (AxisData)this.hashTable.get(axisName);
                        if (axisData != null) {
                            IBIAxisCursor axisCursor = this.dataset.createAxisCursor(axisData.getAxisData(), axisData.getAxisMataData());
                            offset = 0;
                            int i = 0;
                            while (i < axisData.getAxisMemberCount()) {
                                axisCursor.createDimensionCursor(axisData.getAxisMemberName(i), offset, axisData.getAxisMemberSize(i));
                                offset += axisData.getAxisMemberSize(i);
                                ++i;
                            }
                        }
                    }
                    --n;
                }
            }
            catch (SQLException e) {
                throw new SAXException(e);
            }
        }
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        if (this.isInCellValue) {
            this.valueStr = new String(ch, start, end);
            loc.debugT(cat, "Cell Value:" + this.valueStr);
        } else if (this.isInMember) {
            this.memberValue = this.memberValue + new String(ch, start, end);
            loc.debugT(cat, "Member Value:" + this.memberValue);
        }
    }

    private int getSQLDataType(String type) {
        if (type.equals("int")) {
            return 4;
        }
        if (type.equals("byte")) {
            return -6;
        }
        if (type.equals("double")) {
            return 8;
        }
        if (type.equals("string")) {
            return 12;
        }
        if (type.equals("unsignedInt")) {
            return 4;
        }
        if (type.equals("decimal")) {
            return 3;
        }
        if (type.equals("float")) {
            return 6;
        }
        if (type.equals("date")) {
            return 91;
        }
        if (type.equals("time")) {
            return 92;
        }
        if (type.equals("short")) {
            return 5;
        }
        if (type.equals("boolean")) {
            return -7;
        }
        return 1111;
    }

    static Object getValueObject(String valueString, int dataType) {
        switch (dataType) {
            case 4: {
                return new Integer(valueString);
            }
            case 8: {
                if (valueString != null) {
                    if (valueString.equals("INF")) {
                        return new Double(Double.POSITIVE_INFINITY);
                    }
                    if (valueString.equals("-INF")) {
                        return new Double(Double.NEGATIVE_INFINITY);
                    }
                }
                return new Double(valueString);
            }
            case 12: {
                return new String(valueString);
            }
            case 3: 
            case 6: {
                return new Float(valueString);
            }
            case 91: {
                return new String(valueString);
            }
            case 92: {
                return new String(valueString);
            }
            case 5: {
                return new Short(valueString);
            }
        }
        return new String(valueString);
    }

    public BIDataSet getDataset() {
        return this.dataset;
    }

    public void ignorableWhitespace(char[] ch, int start, int end) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private int getCellDataType(String localName) {
        Integer type = (Integer)this.cellDataTypes.get(localName);
        if (type == null) {
            return 12;
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$DatasetContentHandler == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$DatasetContentHandler = DatasetContentHandler.class$("com.sap.ip.bi.sdk.dac.connector.xmla.impl.DatasetContentHandler")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$DatasetContentHandler).getName());
        cat = BILoggingSetup.CONNECTION.getCategory();
    }
}

