/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRestriction;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.impl.IBINativeXmla;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonRelationalConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.odbo.BIOdboMetadataConstants;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaMDRConnectionRelational;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.XmlaParser;
import com.sap.ip.bi.sdk.dac.olap.query.IBIMemberFactory;
import com.sap.ip.bi.sdk.dac.olap.query.IBIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIDataSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BILogonLanguage;
import com.sap.ip.bi.sdk.util.impl.BIMonitor;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.ip.bi.sdk.util.impl.ServerRTCounter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import javax.xml.messaging.Endpoint;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;
import org.xml.sax.InputSource;

public class Connection
extends CommonRelationalConnection
implements IBINativeXmla,
IBIQueryExecute,
IBIConnectionDetails {
    private static Attributes attributes = null;
    private Properties properties;
    private String user;
    private String password;
    private String language;
    private String url;
    private String dataSource;
    private String statefulness;
    private String sessionId = null;
    private String providerName;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private IBIMonitor monitor;
    private boolean closeSession = false;
    private CorePackage corePackage = null;
    private LocalTransaction trans = null;
    private Locale locale = Locale.getDefault();
    private IBIConnection connection;
    private ServerRTCounter counter;
    private IBIQueryFactory queryFactory = null;
    private IBIOlap olap = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$impl$Connection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$xml$soap$SOAPMessage;
    static /* synthetic */ Class class$javax$xml$messaging$Endpoint;

    private Connection() {
    }

    private Connection(Properties prop) {
        if (prop != null) {
            loc.entering("Constructor(" + ((Hashtable)prop).toString() + ")");
        } else {
            loc.entering("Constructor(null)");
        }
        this.properties = new Properties();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)this.properties).put(key, prop.getProperty(key));
        }
        this.user = this.getProperty(BIConnectionConstants.USERNAME.toString());
        this.password = this.getProperty(BIConnectionConstants.PASSWORD.toString());
        this.language = this.getProperty(BIConnectionConstants.LANGUAGE.toString());
        this.url = this.getProperty(XmlaConnectionConstants.URL.toString());
        this.dataSource = this.getProperty(XmlaConnectionConstants.DATA_SOURCE.toString());
        this.statefulness = this.getProperty(XmlaConnectionConstants.STATEFULNESS.toString());
        loc.debugT(cat, " user:" + this.user + " passwd:" + "*****" + " language:" + this.language + " url:" + this.url + " dataSource:" + this.dataSource + " statefulness:" + this.statefulness);
        this.sessionId = null;
        this.locale = BILogonLanguage.getLocale((String)this.language);
        this.counter = ServerRTCounter.getInstance();
        this.monitor = BIMonitor.createMonitor();
        loc.exiting();
    }

    public static Connection connect(Properties props) throws ResourceException {
        Connection c = new Connection(props);
        ((CommonConnection)c).connectionInfo = c.new ConnectionInfo();
        return c;
    }

    public IBIConnectionInfo getConnectionInfo() throws BIResourceException {
        if (((CommonConnection)this).connectionInfo == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        return ((CommonConnection)this).connectionInfo;
    }

    public void connectMdr() throws BIResourceException {
        loc.entering("connectMdr");
        try {
            try {
                BIOlapDataSourceType providerType = this.getDataSourceType();
                ((CommonConnection)this).mdr = new XmlaMDRConnection(this, providerType);
                this.trans = ((CommonConnection)this).mdr.getLocalTransaction();
                this.trans.begin();
            }
            catch (ResourceException ex) {
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.mmr_1000", null, (Throwable)ex);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public BIOlapDataSourceType getDataSourceType() {
        String provider = this.getProviderName().toLowerCase();
        if (provider.indexOf("sap business information warehouse") >= 0) {
            return BIOlapDataSourceType.SAP_BW;
        }
        if (provider.indexOf("microsoft xml for analysis provider") >= 0) {
            return BIOlapDataSourceType.MS_OLAP;
        }
        return BIOlapDataSourceType.OTHER;
    }

    public void close() throws BIResourceException {
        loc.entering("close");
        this.closeSession();
        try {
            block5: {
                try {
                    if (((CommonConnection)this).mdr == null) break block5;
                    if (this.trans != null) {
                        this.trans.rollback();
                    }
                    ((CommonConnection)this).mdr.close();
                    ((CommonConnection)this).mdr = null;
                }
                catch (ResourceException ex) {
                    loc.errorT(cat, "can not close mdr connection");
                    throw new BIRuntimeException(this.locale, "sdk.dac.connector_2003");
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean isAlive() throws BIResourceException {
        loc.entering("isAlive()");
        ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
        res.add(new BIRestriction("PropertyName", "ProviderName"));
        String xml = this.discover("DISCOVER_PROPERTIES", res, null);
        XmlaParser xmlaParser = new XmlaParser(((CommonConnection)this).connectionInfo);
        this.providerName = xmlaParser.parseProviderName(new InputSource(new StringReader(xml)));
        loc.exiting();
        return true;
    }

    public Attributes getAttributes() {
        if (attributes == null) {
            attributes = new Attributes();
        }
        return attributes;
    }

    public String discover(String requestType, List restrictions, Properties properties) throws BIResourceException {
        loc.entering("discover(" + requestType + ")");
        String result = null;
        try {
            try {
                result = this.discovers(requestType, restrictions, properties);
            }
            catch (SOAPException e) {
                cat.errorT(loc, e.getLocalizedMessage());
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1001", new Object[]{requestType}, (Throwable)e);
            }
            catch (BIResourceException e) {
                e.log();
                throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1001", new Object[]{requestType}, (Throwable)e);
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
        return result;
    }

    public String discoverSchemaRowset(String requestType, List restrictions) throws BIResourceException {
        loc.entering("discoverSchemaRowset(" + requestType + "," + restrictions + ")");
        Properties properties = new Properties();
        ((Hashtable)properties).put("DataSourceInfo", this.dataSource);
        ((Hashtable)properties).put("Format", "Tabular");
        loc.exiting();
        return this.discover(requestType, restrictions, properties);
    }

    public String discoverSchemaRowset(String requestType) throws BIResourceException {
        loc.entering("discoverSchemaRowset(" + requestType + ")");
        loc.exiting();
        return this.discoverSchemaRowset(requestType, null);
    }

    public List discoverSchemaRowsetasList(String requestType, List restrictions) throws BIResourceException {
        loc.entering("discoverSchemaRowsetasList(" + requestType + "," + restrictions + ")");
        String xml = this.discoverSchemaRowset(requestType, restrictions);
        if (xml == null || xml.length() == 0) {
            cat.errorT(loc, "response xml is empty");
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1014", null);
        }
        long time = System.currentTimeMillis();
        ArrayList list_hm = new ArrayList();
        XmlaParser xmlaParser = new XmlaParser(((CommonConnection)this).connectionInfo);
        if (requestType.equalsIgnoreCase("DBSCHEMA_CATALOGS")) {
            xmlaParser.parseCatalogs(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_CUBES")) {
            xmlaParser.parseCubes(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_DIMENSIONS")) {
            xmlaParser.parseDimensions(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_HIERARCHIES")) {
            xmlaParser.parseHierarchies(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_LEVELS")) {
            xmlaParser.parseLevels(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_MEASURES")) {
            xmlaParser.parseMeasures(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_MEMBERS")) {
            xmlaParser.parseMembers(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("MDSCHEMA_PROPERTIES")) {
            xmlaParser.parseProperties(list_hm, new InputSource(new StringReader(xml)));
        } else if (requestType.equalsIgnoreCase("SAP_VARIABLES")) {
            xmlaParser.parseSAPVariables(list_hm, new InputSource(new StringReader(xml)));
        } else {
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1007", new Object[]{requestType}, null);
        }
        loc.exiting();
        return list_hm;
    }

    public List discoverSchemaRowsetasList(String requestType) throws BIResourceException {
        loc.entering("discoverSchemaRowsetasList(" + requestType + ")");
        loc.exiting();
        return this.discoverSchemaRowsetasList(requestType, null);
    }

    public String execute(String command, Properties properties) throws BIResourceException {
        loc.entering("execute(" + command + "," + properties + ")");
        String result = null;
        try {
            String catalog = null;
            if (properties != null) {
                catalog = (String)((Hashtable)properties).get("Catalog");
            }
            result = this.execute(command, properties, catalog);
        }
        catch (SOAPException e) {
            cat.errorT(loc, e.getLocalizedMessage());
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1003", new Object[]{command}, (Throwable)e);
        }
        loc.exiting();
        return result;
    }

    public IBIDataSet getDataSet(String mdx) throws BIResourceException {
        loc.entering("getDataset(" + mdx + ")");
        BIDataSet dataset = null;
        String dataset_xml = null;
        try {
            dataset_xml = this.execute(mdx, null, null);
        }
        catch (SOAPException e) {
            cat.errorT(loc, e.getLocalizedMessage());
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1003", new Object[]{mdx}, (Throwable)e);
        }
        if (dataset_xml == null || dataset_xml.length() == 0) {
            cat.errorT(loc, "response xml is empty");
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1014", null);
        }
        XmlaParser xmlaParser = new XmlaParser(((CommonConnection)this).connectionInfo);
        try {
            dataset = xmlaParser.parse(dataset, new InputSource(new StringReader(dataset_xml)));
        }
        catch (BIResourceException e) {
            cat.errorT(loc, "Exception:" + e.toString() + ";dataset_xml with error:" + dataset_xml);
            throw e;
        }
        loc.exiting();
        return dataset;
    }

    Locale getLocale() {
        return this.locale;
    }

    private Collection getTaggedValue(ModelElement element) throws BIResourceException {
        if (this.corePackage == null) {
            this.corePackage = (CorePackage)this.getTopLevelPackage().refPackage("org.omg.cwm.objectmodel.Core");
        }
        return this.corePackage.getTaggedElement().getTaggedValue(element);
    }

    private String discovers(String requestType, List restrictions, Properties properties) throws SOAPException, BIResourceException {
        loc.entering("discovers(" + requestType + "," + restrictions + "," + properties + ")");
        this.monitor.startRequest(IBIMonitor.Request.CONNECTION);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        MessageFactory messageFactory = null;
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            messageFactory = MessageFactory.newInstance();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
        SOAPMessage msg = messageFactory.createMessage();
        SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
        this.setStatefulness(envelope);
        MimeHeaders headers = msg.getMimeHeaders();
        headers.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Discover\"");
        envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        SOAPBody body = envelope.getBody();
        SOAPElement discoverElement = body.addChildElement("Discover");
        discoverElement.addNamespaceDeclaration("", "urn:schemas-microsoft-com:xml-analysis");
        discoverElement.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        SOAPElement params = discoverElement.addChildElement("RequestType", null);
        this.elementSetValue(params, requestType);
        SOAPElement restrictionsEle = discoverElement.addChildElement("Restrictions", null);
        SOAPElement restrictionListEle = restrictionsEle.addChildElement("RestrictionList", null);
        if (restrictions != null) {
            int i = 0;
            while (i < restrictions.size()) {
                BIRestriction res = (BIRestriction)restrictions.get(i);
                this.elementSetValue(restrictionListEle.addChildElement(res.name, null), res.value);
                loc.debugT(cat, "restriction: name:" + res.name + " value:" + res.value);
                ++i;
            }
        }
        SOAPElement propertiesEle = discoverElement.addChildElement("Properties", null);
        if (properties != null) {
            SOAPElement propertyListEle = propertiesEle.addChildElement("PropertyList", null);
            Enumeration keys = ((Hashtable)properties).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.elementSetValue(propertyListEle.addChildElement(key, null), (String)((Hashtable)properties).get(key));
                loc.debugT(cat, "properties: key:" + key + " value:" + (String)((Hashtable)properties).get(key));
            }
        }
        String ret = this.sendSOAPRequest(msg);
        this.monitor.endRequest(IBIMonitor.Request.CONNECTION);
        loc.exiting();
        return ret;
    }

    private String execute(String command, Properties properties, String catalogName) throws SOAPException, BIResourceException {
        loc.entering("execute(" + command + "," + properties + "," + catalogName + ")");
        this.monitor.startRequest(IBIMonitor.Request.CONNECTION);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        MessageFactory messageFactory = null;
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            messageFactory = MessageFactory.newInstance();
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw throwable;
        }
        SOAPMessage msg = messageFactory.createMessage();
        MimeHeaders headers = msg.getMimeHeaders();
        headers.setHeader("SOAPAction", "\"urn:schemas-microsoft-com:xml-analysis:Execute\"");
        SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
        envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        this.setStatefulness(envelope);
        SOAPBody body = envelope.getBody();
        SOAPElement methodName = body.addChildElement("Execute");
        methodName.addNamespaceDeclaration("", "urn:schemas-microsoft-com:xml-analysis");
        methodName.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        SOAPElement commandEle = methodName.addChildElement("Command", null);
        SOAPElement statementEle = commandEle.addChildElement("Statement", null);
        this.elementSetValue(statementEle, command);
        SOAPElement propertiesEle = methodName.addChildElement("Properties", null);
        SOAPElement propertyListEle = propertiesEle.addChildElement("PropertyList", null);
        this.elementSetValue(propertyListEle.addChildElement("DataSourceInfo", null), this.dataSource);
        if (catalogName != null && catalogName.length() > 0) {
            this.elementSetValue(propertyListEle.addChildElement("Catalog", null), catalogName);
        }
        this.elementSetValue(propertyListEle.addChildElement("Format", null), "Multidimensional");
        if (properties == null || !((Hashtable)properties).containsKey("AxisFormat")) {
            this.elementSetValue(propertyListEle.addChildElement("AxisFormat", null), "TupleFormat");
        }
        if (properties != null) {
            ((Hashtable)properties).remove("Format");
            ((Hashtable)properties).remove("Catalog");
            Enumeration keys = ((Hashtable)properties).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.elementSetValue(propertyListEle.addChildElement(key, null), (String)((Hashtable)properties).get(key));
                loc.debugT(cat, "properties: key:" + key + " value:" + (String)((Hashtable)properties).get(key));
            }
        }
        String ret = this.sendSOAPRequest(msg);
        this.monitor.endRequest(IBIMonitor.Request.CONNECTION);
        loc.exiting();
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private String sendSOAPRequest(SOAPMessage msg) throws SOAPException, BIResourceException {
        Connection.loc.entering("sendSOAPRequest(" + msg + ")");
        oldLoader = Thread.currentThread().getContextClassLoader();
        soapConnectionFactory = null;
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            soapConnectionFactory = SOAPConnectionFactory.newInstance();
            Connection.loc.debugT(Connection.cat, "SOAPConnectionFactory:" + soapConnectionFactory.getClass().getName());
            var5_4 = null;
            ** if (soapConnectionFactory != null) goto lbl-1000
        }
        catch (Throwable var4_6) {
            var5_5 = null;
            if (soapConnectionFactory == null) {
                Connection.loc.debugT(Connection.cat, "ClassLoader when SOAPConnectionFactory.newInstance():" + Thread.currentThread().getContextClassLoader() + ",oldClassLoader:" + oldLoader);
            }
            Thread.currentThread().setContextClassLoader(oldLoader);
            throw var4_6;
        }
lbl-1000:
        // 1 sources

        {
            Connection.loc.debugT(Connection.cat, "ClassLoader when SOAPConnectionFactory.newInstance():" + Thread.currentThread().getContextClassLoader() + ",oldClassLoader:" + oldLoader);
        }
lbl-1000:
        // 2 sources

        {
        }
        Thread.currentThread().setContextClassLoader(oldLoader);
        soapConnection = soapConnectionFactory.createConnection();
        connectionClass = soapConnection.getClass();
        if (this.user != null && this.user.length() > 0) {
            params = new Class[]{Connection.class$java$lang$String == null ? (Connection.class$java$lang$String = Connection.class$("java.lang.String")) : Connection.class$java$lang$String};
            paramValues = null;
            methodName = null;
            try {
                paramValues = new Object[]{this.user};
                methodName = connectionClass.getMethod("setUserName", params);
                methodName.invoke((Object)soapConnection, paramValues);
                Connection.loc.debugT(Connection.cat, "SOAPConnection.setUserName(" + this.user + ")");
                paramValues = new Object[]{this.password};
                methodName = connectionClass.getMethod("setUserPassword", params);
                methodName.invoke((Object)soapConnection, paramValues);
                Connection.loc.debugT(Connection.cat, "SOAPConnection.setUserPassword(***)");
            }
            catch (NoSuchMethodException ex_method_not_found) {
                Connection.cat.fatalT(Connection.loc, ex_method_not_found.getLocalizedMessage());
                throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1004", (Throwable)ex_method_not_found);
            }
            catch (IllegalAccessException ex_illegal_access) {
                Connection.cat.fatalT(Connection.loc, ex_illegal_access.getLocalizedMessage());
                throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1008", (Throwable)ex_illegal_access);
            }
            catch (InvocationTargetException ex_invocation) {
                Connection.cat.fatalT(Connection.loc, ex_invocation.getLocalizedMessage());
                throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1012", (Throwable)ex_invocation);
            }
        }
        if (this.url.endsWith("/sap/bw/xml/soap/xmla") && this.language != null && this.language.length() != 0) {
            this.url = this.url + "?sap-language=" + this.language;
            Connection.loc.debugT(Connection.cat, "BW URL with language: " + this.url + ";");
        }
        endPoint = new Endpoint(this.url);
        reply = null;
        Connection.loc.debugT(Connection.cat, "before SOAPConnection.call");
        Connection.loc.debugT(Connection.cat, "request msg:" + msg.getSOAPPart().getEnvelope().toString());
        params = new Class[]{Connection.class$javax$xml$soap$SOAPMessage == null ? (Connection.class$javax$xml$soap$SOAPMessage = Connection.class$("javax.xml.soap.SOAPMessage")) : Connection.class$javax$xml$soap$SOAPMessage, Connection.class$javax$xml$messaging$Endpoint == null ? (Connection.class$javax$xml$messaging$Endpoint = Connection.class$("javax.xml.messaging.Endpoint")) : Connection.class$javax$xml$messaging$Endpoint};
        paramValues = new Object[]{msg, endPoint};
        methodName = null;
        time = System.currentTimeMillis();
        try {
            methodName = connectionClass.getMethod("call", params);
            this.monitor.startComponent(soapConnection.getClass(), methodName.getName());
            reply = (SOAPMessage)methodName.invoke((Object)soapConnection, paramValues);
            this.counter.incrementCounter();
        }
        catch (NoSuchMethodException ex_method_not_found) {
            Connection.cat.fatalT(Connection.loc, ex_method_not_found.getLocalizedMessage());
            throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1004", (Throwable)ex_method_not_found);
        }
        catch (IllegalAccessException ex_illegal_access) {
            Connection.cat.fatalT(Connection.loc, ex_illegal_access.getLocalizedMessage());
            throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1008", (Throwable)ex_illegal_access);
        }
        catch (InvocationTargetException ex_invocation) {
            Connection.cat.fatalT(Connection.loc, ex_invocation.getLocalizedMessage() + " target Url: " + this.url + " user: " + this.user + " password: " + "password");
            throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1013", (Throwable)ex_invocation);
        }
        catch (Exception e) {
            Connection.cat.fatalT(Connection.loc, e.getLocalizedMessage());
            throw new BIResourceException(this.locale, Connection.cat, 500, Connection.loc, "sdk.dac.connector.xmla_1010", (Throwable)e);
        }
        Connection.loc.debugT(Connection.cat, "after SOAPConnection.call");
        replyPart = reply.getSOAPPart();
        replyEnvelope = replyPart.getEnvelope();
        this.monitor.endComponent(soapConnection.getClass(), methodName.getName(), replyEnvelope.toString().length());
        Connection.loc.debugT(Connection.cat, "SOAP envolope:" + replyEnvelope.toString());
        replyBody = replyEnvelope.getBody();
        replyXml = replyBody.toString();
        time = System.currentTimeMillis() - time;
        this.counter.addToCounter(2, (long)((int)time));
        if (replyBody.hasFault()) {
            fault = replyBody.getFault();
            falseMessages = fault.getDetail().getDetailEntries();
            falseMessage = null;
            faultCode = null;
            faultString = null;
            if (falseMessages.hasNext() && (falseMessage = (DetailEntry)falseMessages.next()) instanceof SOAPElement && falseMessage.getElementName().getLocalName().equalsIgnoreCase("error")) {
                it = falseMessage.getAllAttributes();
                while (it.hasNext()) {
                    att = (Name)it.next();
                    if (att.getLocalName().equalsIgnoreCase("ErrorCode")) {
                        faultCode = falseMessage.getAttributeValue(att);
                        continue;
                    }
                    if (!att.getLocalName().equalsIgnoreCase("Description")) continue;
                    faultString = falseMessage.getAttributeValue(att);
                }
            }
            Connection.cat.errorT(Connection.loc, "SOAPFault message, code:" + faultCode + " fault string:" + faultString + " fault Message: " + fault.toString() + " Request message: " + msg.getSOAPPart().getEnvelope().toString());
            throw new BIResourceException(this.locale, Connection.cat, 600, Connection.loc, "sdk.dac.connector.xmla_1002", new Object[]{faultCode, faultString}, null);
        }
        if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true") && this.sessionId == null && (replyHeader = replyEnvelope.getHeader()) != null) {
            elements = replyHeader.getChildElements();
            while (elements.hasNext()) {
                headerElement = elements.next();
                if (!(headerElement instanceof SOAPHeaderElement)) continue;
                it = ((SOAPHeaderElement)headerElement).getAllAttributes();
                while (it.hasNext()) {
                    att = (Name)it.next();
                    if (!att.getLocalName().equalsIgnoreCase("SessionId")) continue;
                    this.sessionId = ((SOAPHeaderElement)headerElement).getAttributeValue(att);
                }
            }
            Connection.loc.debugT(Connection.cat, "SOAP header: " + replyEnvelope.getHeader());
        }
        Connection.loc.exiting();
        this.counter.addToCounter(1, (long)replyXml.length());
        return replyXml;
    }

    private void elementSetValue(SOAPElement element, String value) throws BIResourceException {
        Class<?> elementClass = element.getClass();
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Connection.class$("java.lang.String")) : class$java$lang$String};
        Object[] paramValues = null;
        Method methodName = null;
        try {
            paramValues = new Object[]{value};
            methodName = elementClass.getMethod("setValue", params);
            methodName.invoke((Object)element, paramValues);
        }
        catch (NoSuchMethodException ex_method_not_found) {
            cat.fatalT(loc, ex_method_not_found.getLocalizedMessage());
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1004", (Throwable)ex_method_not_found);
        }
        catch (IllegalAccessException ex_illegal_access) {
            cat.fatalT(loc, ex_illegal_access.getLocalizedMessage());
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1008", (Throwable)ex_illegal_access);
        }
        catch (InvocationTargetException ex_invocation) {
            cat.fatalT(loc, ex_invocation.getLocalizedMessage());
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1012", (Throwable)ex_invocation);
        }
    }

    private void setStatefulness(SOAPEnvelope envelope) throws SOAPException {
        if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true")) {
            SOAPHeaderElement shElement;
            SOAPHeader sh;
            Name name_must;
            Name name_xsi;
            Name name;
            if (this.sessionId == null) {
                envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                name = envelope.createName("BeginSession", "XA", "urn:schemas-microsoft-com:xml-analysis");
                name_xsi = envelope.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
                name_must = envelope.createName("mustUnderstand");
                sh = envelope.getHeader();
                if (sh != null) {
                    sh.detachNode();
                }
                sh = envelope.addHeader();
                shElement = sh.addHeaderElement(name);
                shElement.addAttribute(name_xsi, "xsd:int");
                shElement.addAttribute(name_must, "1");
            } else {
                name = envelope.createName("Session", "XA", "urn:schemas-microsoft-com:xml-analysis");
                Name name_must2 = envelope.createName("mustUnderstand");
                Name name_sid = envelope.createName("SessionId");
                sh = envelope.getHeader();
                if (sh != null) {
                    sh.detachNode();
                }
                sh = envelope.addHeader();
                shElement = sh.addHeaderElement(name);
                shElement.addAttribute(name_must2, "1");
                shElement.addAttribute(name_sid, this.sessionId);
            }
            if (this.closeSession) {
                envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                envelope.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
                name = envelope.createName("EndSession", "XA", "urn:schemas-microsoft-com:xml-analysis");
                name_xsi = envelope.createName("type", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
                name_must = envelope.createName("mustUnderstand");
                Name name_sid = envelope.createName("SessionId");
                SOAPHeader sh2 = envelope.getHeader();
                if (sh2 != null) {
                    sh2.detachNode();
                }
                sh2 = envelope.addHeader();
                SOAPHeaderElement shElement2 = sh2.addHeaderElement(name);
                shElement2.addAttribute(name_xsi, "xsd:int");
                shElement2.addAttribute(name_must, "1");
                shElement2.addAttribute(name_sid, this.sessionId);
            }
        }
    }

    private void closeSession() throws BIResourceException {
        loc.entering("closeSession()");
        if (this.statefulness != null && this.statefulness.equalsIgnoreCase("true") && this.sessionId != null) {
            this.closeSession = true;
            this.discover("DISCOVER_PROPERTIES", null, null);
        }
        loc.exiting();
    }

    public IBIOlapObjectFinder getObjectFinder() throws BIResourceException {
        if (((CommonConnection)this).objectFinder == null) {
            if (this.queryFactory == null) {
                this.queryFactory = this.olap.getQueryFactory();
            }
            ((CommonConnection)this).objectFinder = new ObjectFinder(this.queryFactory);
        }
        return ((CommonConnection)this).objectFinder;
    }

    protected void connectMDRRelational() throws BIResourceException {
        try {
            this.mdrRelational = new XmlaMDRConnectionRelational((CommonConnection)this, ((CommonConnection)this).connectionInfo);
            this.outerMostRelational = this.mdrRelational.connect();
        }
        catch (ResourceException ex) {
            throw new BIResourceException(this.locale, "sdk.dac.connector.mmr_1000", (Throwable)ex);
        }
    }

    public void setOlap(IBIOlap olap) {
        this.olap = olap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Attributes {
        private String EISProductName = "";
        private String EISProductVersion = "";
        private String userName = "";

        protected Attributes() {
        }

        public String getEISProductName() {
            return this.EISProductName;
        }

        public String getEISProductVersion() {
            return this.EISProductVersion;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    private class ObjectFinder
    extends CommonConnection.AbstractObjectFinder {
        IBIQueryFactory queryFactory = null;

        private ObjectFinder(IBIQueryFactory queryFac) {
            super((CommonConnection)Connection.this);
            this.queryFactory = queryFac;
        }

        public List findMember(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            return this.findMember(schemaName, cubeName, dimensionName, hierarchyName, levelName, memberName, treeOperator, false);
        }

        private List findMember(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator, boolean findFirst) throws BIResourceException {
            loc.entering("findMember(" + schemaName + "," + cubeName + "," + dimensionName + "," + hierarchyName + "," + levelName + "," + "memberName:" + memberName);
            Connection.super.assertConnectedToMDR();
            if (dimensionName == null || dimensionName.length() == 0) {
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1011", null);
            }
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)Connection.this.locale, (String)schemaName);
            String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)Connection.this.locale, (String)schemaName);
            String dimensionUName = MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName);
            String levelUName = null;
            if (levelName != null) {
                levelUName = MetadataNameConverter.dimensionLevelNametoLevelUniqueName((String)dimensionName, (String)levelName);
            }
            if (lCatalogName != null) {
                res.add(new BIRestriction("CATALOG_NAME", lCatalogName));
            }
            if (lSchemaName != null) {
                res.add(new BIRestriction("SCHEMA_NAME", lSchemaName));
            }
            if (cubeName != null) {
                res.add(new BIRestriction("CUBE_NAME", cubeName));
            }
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
            boolean checkHryNam = false;
            if (hierarchyName != null && hierarchyName != "") {
                checkHryNam = true;
            }
            String hierarchyUName = null;
            if (checkHryNam) {
                List hie_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_HIERARCHIES", res);
                int i = 0;
                while (i < hie_hm.size()) {
                    HashMap hm = (HashMap)hie_hm.get(i);
                    loc.debugT(cat, "Hierarchy from XMLA:" + hm.toString());
                    if (hierarchyName.equalsIgnoreCase((String)hm.get("HIERARCHY_NAME"))) {
                        hierarchyUName = (String)hm.get("HIERARCHY_UNIQUE_NAME");
                        break;
                    }
                    ++i;
                }
            }
            String operator = null;
            if (treeOperator != null) {
                operator = treeOperator.toString();
            }
            if (hierarchyUName != null) {
                res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", hierarchyUName));
            }
            if (levelUName != null) {
                res.add(new BIRestriction("LEVEL_UNIQUE_NAME", levelUName));
            }
            Object memberUName = null;
            if (memberName != null) {
                res.add(new BIRestriction("MEMBER_NAME", memberName));
            }
            if (treeOperator != null) {
                res.add(new BIRestriction("TREE_OP", operator));
            }
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            ArrayList<IBIMember> members = new ArrayList<IBIMember>();
            List dimensions = this.findDimension(schemaName, cubeName, dimensionName);
            Dimension dim = (Dimension)dimensions.get(0);
            int k = 0;
            while (k < member_hm.size()) {
                HashMap properties = (HashMap)member_hm.get(k);
                loc.debugT(cat, "Members from XMLA:" + properties.toString());
                String memName = (String)properties.get("MEMBER_NAME");
                IBIMember member = null;
                member = this.createMember(dim, memName, properties);
                members.add(member);
                if (findFirst) break;
                ++k;
            }
            loc.exiting();
            return members;
        }

        public List findMember(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            return this.findMember(level, memberName, treeOperator, false);
        }

        private List findMember(Level level, String memberName, BITreeOperator treeOperator, boolean findFirst) throws BIResourceException {
            loc.entering("findMember(" + level + "," + "memberName:" + memberName);
            Connection.super.assertConnectedToMDR();
            Collection tvs = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)level);
            String operator = null;
            if (treeOperator != null) {
                operator = treeOperator.toString();
            }
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            res.add(new BIRestriction("CATALOG_NAME", Connection.super.getSchemaAttribute("CATALOG_NAME", tvs)));
            res.add(new BIRestriction("SCHEMA_NAME", Connection.super.getSchemaAttribute("SCHEMA_NAME", tvs)));
            res.add(new BIRestriction("CUBE_NAME", Connection.super.getSchemaAttribute("CUBE_NAME", tvs)));
            res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tvs)));
            res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tvs)));
            res.add(new BIRestriction("LEVEL_UNIQUE_NAME", Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tvs)));
            Object memberUName = null;
            if (memberName != null) {
                res.add(new BIRestriction("MEMBER_NAME", memberName));
            }
            if (treeOperator != null) {
                res.add(new BIRestriction("TREE_OP", operator));
            }
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            ArrayList<IBIMember> members = new ArrayList<IBIMember>();
            Dimension dimension = level.getDimension();
            IBIMember member = null;
            int k = 0;
            while (k < member_hm.size()) {
                HashMap properties = (HashMap)member_hm.get(k);
                loc.debugT(cat, "Members from XMLA:" + properties.toString());
                member = this.createMember(dimension, memberName, properties);
                members.add(member);
                if (findFirst) break;
                ++k;
            }
            loc.exiting();
            return members;
        }

        private IBIMember createMember(Dimension dimension, String memberName, Map properties) throws BIResourceException {
            IBIMemberFactory memberFactory = this.queryFactory.getMemberFactory();
            IBIMember member = null;
            try {
                member = memberFactory.createMember(dimension, memberName, null, properties);
            }
            catch (BIOlapQueryException e) {
                e.log();
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.olap_1005", (Throwable)e);
            }
            return member;
        }

        public IBIResultSet findMemberData(List restrictions, List selectedAttributes) throws BIResourceException {
            int i;
            loc.entering("getMemberData(" + restrictions + selectedAttributes + ")");
            Cube cube = null;
            Dimension dimension = null;
            Hierarchy hierarchy = null;
            Level level = null;
            String catName = null;
            String schName = null;
            String cubeName = null;
            String dimensionUName = null;
            String hierarchyUName = null;
            String levelUName = null;
            String levelNumber = null;
            String memberName = null;
            String memberUName = null;
            String memberCaption = null;
            String memberType = null;
            String treeOperator = null;
            Object item = null;
            BIResultSet resultSet = null;
            Object cP = null;
            Collection tags = null;
            ArrayList<BIRestriction> res = new ArrayList<BIRestriction>();
            if (restrictions != null) {
                Iterator i2 = restrictions.iterator();
                while (i2.hasNext()) {
                    item = i2.next();
                    loc.debugT(cat, "restrictions:" + item);
                    if (item instanceof Cube) {
                        cube = item;
                        tags = Connection.this.getTaggedValue((ModelElement)cube);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName != null) continue;
                        cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Dimension) {
                        dimension = item;
                        tags = Connection.this.getTaggedValue((ModelElement)dimension);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName != null) continue;
                        dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Hierarchy) {
                        hierarchy = item;
                        tags = Connection.this.getTaggedValue((ModelElement)hierarchy);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName != null) continue;
                        hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Level) {
                        level = item;
                        tags = Connection.this.getTaggedValue((ModelElement)level);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName == null) {
                            hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        }
                        if (levelUName == null) {
                            levelUName = Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tags);
                        }
                        if (levelNumber != null) continue;
                        levelNumber = Connection.super.getSchemaAttribute("LEVEL_NUMBER", tags);
                        continue;
                    }
                    if (item instanceof IBIMember) {
                        IBIMember member = item;
                        tags = Connection.this.getTaggedValue((ModelElement)member);
                        if (memberName == null) {
                            memberName = Connection.super.getSchemaAttribute("MEMBER_NAME", tags);
                        }
                        if (memberUName == null) {
                            memberUName = Connection.super.getSchemaAttribute("MEMBER_UNIQUE_NAME", tags);
                        }
                        if (memberCaption == null) {
                            memberCaption = Connection.super.getSchemaAttribute("MEMBER_CAPTION", tags);
                        }
                        if (memberType == null) {
                            memberType = Connection.super.getSchemaAttribute("MEMBER_TYPE", tags);
                        }
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        if (hierarchyUName == null) {
                            hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        }
                        if (levelUName == null) {
                            levelUName = Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tags);
                        }
                        if (levelNumber != null) continue;
                        levelNumber = Connection.super.getSchemaAttribute("LEVEL_NUMBER", tags);
                        continue;
                    }
                    if (item instanceof BIOdboMetadataConstants.BITreeOperator) {
                        if (treeOperator != null) continue;
                        treeOperator = ((BIOdboMetadataConstants.BITreeOperator)item).toString();
                        continue;
                    }
                    if (!(item instanceof BIRestriction)) continue;
                    String name = ((BIRestriction)item).name;
                    String value = ((BIRestriction)item).value;
                    if (name == null) {
                        name = "";
                    }
                    if (name.equals("CATALOG_NAME") && catName == null) {
                        catName = value;
                    }
                    if (name.equals("SCHEMA_NAME") && schName == null) {
                        schName = value;
                    }
                    if (name.equals("CUBE_NAME") && cubeName == null) {
                        cubeName = value;
                    }
                    if (name.equals("DIMENSION_UNIQUE_NAME") && dimensionUName == null) {
                        dimensionUName = value;
                    }
                    if (name.equals("HIERARCHY_UNIQUE_NAME") && hierarchyUName == null) {
                        hierarchyUName = value;
                    }
                    if (name.equals("LEVEL_UNIQUE_NAME") && levelUName == null) {
                        levelUName = value;
                    }
                    if (name.equals("LEVEL_NUMBER") && levelNumber == null) {
                        levelNumber = value;
                    }
                    if (name.equals("MEMBER_NAME") && memberName == null) {
                        memberName = value;
                    }
                    if (name.equals("MEMBER_CAPTION") && memberCaption == null) {
                        memberCaption = value;
                    }
                    if (name.equals("MEMBER_TYPE") && memberType == null) {
                        memberType = value;
                    }
                    if (name.equals("MEMBER_UNIQUE_NAME") && memberUName == null) {
                        memberUName = value;
                    }
                    if (!name.equals("TREE_OP") || treeOperator != null) continue;
                    treeOperator = value;
                }
                if (catName != null) {
                    res.add(new BIRestriction("CATALOG_NAME", catName));
                }
                if (schName != null) {
                    res.add(new BIRestriction("SCHEMA_NAME", schName));
                }
                if (cubeName != null) {
                    res.add(new BIRestriction("CUBE_NAME", cubeName));
                }
                if (dimensionUName != null) {
                    res.add(new BIRestriction("DIMENSION_UNIQUE_NAME", dimensionUName));
                }
                if (hierarchyUName != null) {
                    res.add(new BIRestriction("HIERARCHY_UNIQUE_NAME", hierarchyUName));
                }
                if (levelUName != null) {
                    res.add(new BIRestriction("LEVEL_UNIQUE_NAME", levelUName));
                }
                if (levelNumber != null) {
                    res.add(new BIRestriction("LEVEL_NUMBER", levelNumber));
                }
                if (memberName != null) {
                    res.add(new BIRestriction("MEMBER_NAME", memberName));
                }
                if (memberCaption != null) {
                    res.add(new BIRestriction("MEMBER_CAPTION", memberCaption));
                }
                if (memberType != null) {
                    res.add(new BIRestriction("MEMBER_TYPE", memberType));
                }
                if (memberUName != null) {
                    res.add(new BIRestriction("MEMBER_UNIQUE_NAME", memberUName));
                }
                if (treeOperator != null) {
                    res.add(new BIRestriction("TREE_OP", treeOperator));
                }
            }
            loc.debugT(cat, "Restrictions for getMemberData:catName" + catName + ";" + "schName" + schName + ";" + "cubeName" + cubeName + ";" + "dimensionUName" + dimensionUName + ";" + "hierarchyUName" + hierarchyUName + ";" + "levelUName" + levelUName + ";" + "levelNumber" + levelNumber + ";" + "memberName" + memberName + ";" + "memberCaption" + memberCaption + ";" + "memberType" + memberType + ";" + "memberUName" + memberUName + ";" + "treeOperator" + treeOperator + ";");
            if (dimensionUName == null && hierarchyUName == null && levelUName == null && levelNumber == null && memberName == null && memberCaption == null && memberType == null && memberUName == null) {
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector.xmla_1011", null);
            }
            BIResultSetData resultSetData = null;
            BIColumnMetaData[] columnMetadata = null;
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            Object[] object = null;
            List member_hm = Connection.this.discoverSchemaRowsetasList("MDSCHEMA_MEMBERS", res);
            int k = 0;
            while (k < member_hm.size()) {
                HashMap hm = (HashMap)member_hm.get(k);
                loc.debugT(cat, hm.toString());
                if (selectedAttributes == null) {
                    object = new Object[]{hm.get("CATALOG_NAME"), hm.get("SCHEMA_NAME"), hm.get("CUBE_NAME"), hm.get("DIMENSION_UNIQUE_NAME"), hm.get("HIERARCHY_UNIQUE_NAME"), hm.get("LEVEL_UNIQUE_NAME"), hm.get("LEVEL_NUMBER"), hm.get("MEMBER_NAME"), hm.get("MEMBER_UNIQUE_NAME"), hm.get("MEMBER_ORDINAL"), hm.get("MEMBER_TYPE"), hm.get("MEMBER_GUID"), hm.get("MEMBER_CAPTION"), hm.get("CHILDREN_CARDINALITY"), hm.get("PARENT_LEVEL"), hm.get("PARENT_UNIQUE_NAME"), hm.get("PARENT_COUNT"), hm.get("DESCRIPTION")};
                } else {
                    object = new Object[selectedAttributes.size()];
                    i = 0;
                    if (selectedAttributes.contains("CATALOG_NAME")) {
                        object[i] = hm.get("CATALOG_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("SCHEMA_NAME")) {
                        object[i] = hm.get("SCHEMA_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("CUBE_NAME")) {
                        object[i] = hm.get("CUBE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("DIMENSION_UNIQUE_NAME")) {
                        object[i] = hm.get("DIMENSION_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("HIERARCHY_UNIQUE_NAME")) {
                        object[i] = hm.get("HIERARCHY_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_UNIQUE_NAME")) {
                        object[i] = hm.get("LEVEL_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_NUMBER")) {
                        object[i] = hm.get("LEVEL_NUMBER");
                        ++i;
                    }
                    if (selectedAttributes.contains("LEVEL_NUMBER")) {
                        object[i] = hm.get("MEMBER_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_UNIQUE_NAME")) {
                        object[i] = hm.get("MEMBER_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_ORDINAL")) {
                        object[i] = hm.get("MEMBER_ORDINAL");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_TYPE")) {
                        object[i] = hm.get("MEMBER_TYPE");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_GUID")) {
                        object[i] = hm.get("MEMBER_GUID");
                        ++i;
                    }
                    if (selectedAttributes.contains("MEMBER_CAPTION")) {
                        object[i] = hm.get("MEMBER_CAPTION");
                        ++i;
                    }
                    if (selectedAttributes.contains("CHILDREN_CARDINALITY")) {
                        object[i] = hm.get("CHILDREN_CARDINALITY");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_LEVEL")) {
                        object[i] = hm.get("PARENT_LEVEL");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_UNIQUE_NAME")) {
                        object[i] = hm.get("PARENT_UNIQUE_NAME");
                        ++i;
                    }
                    if (selectedAttributes.contains("PARENT_COUNT")) {
                        object[i] = hm.get("PARENT_COUNT");
                        ++i;
                    }
                    if (selectedAttributes.contains("DESCRIPTION")) {
                        object[i] = hm.get("DESCRIPTION");
                    }
                }
                data.add(object);
                ++k;
            }
            if (selectedAttributes == null) {
                columnMetadata = new BIColumnMetaData[]{new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CATALOG_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "SCHEMA_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CUBE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DIMENSION_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "HIERARCHY_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "LEVEL_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "LEVEL_NUMBER"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_ORDINAL"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_TYPE"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_GUID"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_CAPTION"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "CHILDREN_CARDINALITY"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_LEVEL"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "PARENT_UNIQUE_NAME"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_COUNT"), new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DESCRIPTION")};
            } else {
                columnMetadata = new BIColumnMetaData[selectedAttributes.size()];
                i = 0;
                if (selectedAttributes.contains("CATALOG_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CATALOG_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("SCHEMA_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "SCHEMA_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("CUBE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "CUBE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("DIMENSION_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DIMENSION_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("HIERARCHY_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "HIERARCHY_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("LEVEL_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "LEVEL_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("LEVEL_NUMBER")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "LEVEL_NUMBER");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_NAME");
                }
                if (selectedAttributes.contains("MEMBER_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_ORDINAL")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_ORDINAL");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_TYPE")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "MEMBER_TYPE");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_GUID")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_GUID");
                    ++i;
                }
                if (selectedAttributes.contains("MEMBER_CAPTION")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "MEMBER_CAPTION");
                    ++i;
                }
                if (selectedAttributes.contains("CHILDREN_CARDINALITY")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "CHILDREN_CARDINALITY");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_LEVEL")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_LEVEL");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_UNIQUE_NAME")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "PARENT_UNIQUE_NAME");
                    ++i;
                }
                if (selectedAttributes.contains("PARENT_COUNT")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 4, "PARENT_COUNT");
                    ++i;
                }
                if (selectedAttributes.contains("DESCRIPTION")) {
                    columnMetadata[i] = new BIColumnMetaData(((CommonConnection)Connection.this).connectionInfo, 12, "DESCRIPTION");
                    ++i;
                }
            }
            try {
                resultSetData = new BIResultSetData(((CommonConnection)Connection.this).connectionInfo, data);
                resultSet = new BIResultSet(((CommonConnection)Connection.this).connectionInfo, (IBIResultSetData)resultSetData, (IBIColumnMetaData[])columnMetadata);
            }
            catch (SQLException e) {
                cat.errorT(loc, e.getLocalizedMessage());
                throw new BIResourceException(Connection.this.locale, cat, 500, loc, "sdk.dac.connector_1053", (Throwable)e);
            }
            loc.exiting();
            return resultSet;
        }

        public IBIMember findMemberFirst(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            List memberList = this.findMember(schemaName, cubeName, dimensionName, hierarchyName, levelName, memberName, treeOperator, true);
            if (memberList != null & memberList.size() > 0) {
                return (IBIMember)memberList.get(0);
            }
            return null;
        }

        public IBIMember findMemberFirst(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            List memberList = this.findMember(level, memberName, treeOperator, true);
            if (memberList != null & memberList.size() > 0) {
                return (IBIMember)memberList.get(0);
            }
            return null;
        }
    }

    private class ConnectionInfo
    implements IBIConnectionInfo {
        Locale locale = null;
        String user = null;

        private ConnectionInfo() {
            this.user = Connection.this.properties.getProperty(BIConnectionConstants.USERNAME.toString());
            this.locale = BILogonLanguage.getLocale((String)Connection.this.properties.getProperty(BIConnectionConstants.LANGUAGE.toString()));
        }

        public String getUser() {
            return this.user;
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

