/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla.impl;

import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.DatasetContentHandler;
import com.sap.ip.bi.sdk.dac.result.IBICursorColumn;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class AxisData {
    private ArrayList members = new ArrayList();
    private HashMap memberTypes;
    private IBIColumnMetaData[] axisMetaData = null;
    private IBIResultSetData axisData = null;
    private ArrayList dataArrayList = new ArrayList();
    private IBIConnectionInfo connectionInfo;

    AxisData(IBIConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    IBIColumnMetaData[] getAxisMataData() {
        return this.axisMetaData;
    }

    IBIResultSetData getAxisData() {
        return this.axisData;
    }

    int getAxisMemberSize(int index) {
        return ((AxisMember)this.members.get(index)).getMetaDataSize();
    }

    void addAxisMember(String memberName) {
        AxisMember member = new AxisMember(memberName);
        this.members.add(member);
    }

    int getAxisMemberCount() {
        return this.members.size();
    }

    String getAxisMemberName(int index) {
        return ((AxisMember)this.members.get(index)).getName();
    }

    private AxisMember getAxisMember(String memberName) {
        AxisMember axisMember = null;
        int i = 0;
        while (i < this.members.size()) {
            if (this.getAxisMemberName(i).equals(memberName)) {
                axisMember = (AxisMember)this.members.get(i);
                break;
            }
            ++i;
        }
        return axisMember;
    }

    void setupAxisData() {
        this.axisData = new BIResultSetData(this.connectionInfo, (List)this.dataArrayList);
    }

    void setMemberTypes(HashMap types) {
        this.memberTypes = types;
    }

    void addMemberDataToArray(String axisMemberName, String value, String type) {
        AxisMember axisMember = this.getAxisMember(axisMemberName);
        if (axisMember != null) {
            axisMember.addMemberDataToArray(value, type);
        }
    }

    void addMemberToArray() {
        Object[] memberContent = new Object[this.getAxisMetaDataSize()];
        int index = 0;
        int i = 0;
        while (i < this.members.size()) {
            Object[] temp = ((AxisMember)this.members.get(i)).getMemberData();
            if (temp == null) break;
            int j = 0;
            while (j < temp.length) {
                memberContent[index] = temp[j];
                ++j;
                ++index;
            }
            ++i;
        }
        this.dataArrayList.add(memberContent);
    }

    private int getAxisMetaDataSize() {
        int size = 0;
        int i = 0;
        while (i < this.members.size()) {
            size += ((AxisMember)this.members.get(i)).getMetaDataSize();
            ++i;
        }
        return size;
    }

    void setupTempMetaData(String axisMemberName, String key, String keyName) {
        AxisMember axisMember = this.getAxisMember(axisMemberName);
        if (axisMember != null) {
            axisMember.setupTempMeta(key, keyName);
        }
    }

    void setupAxisMetaData() {
        this.axisMetaData = new IBIColumnMetaData[this.getAxisMetaDataSize()];
        int index = 0;
        int i = 0;
        while (i < this.members.size()) {
            Object[] tempMeta = ((AxisMember)this.members.get(i)).getTempMeta();
            int j = 0;
            while (j < tempMeta.length) {
                this.axisMetaData[index] = (BIColumnMetaData)tempMeta[j];
                ++j;
                ++index;
            }
            ++i;
        }
    }

    void addMemberCP(String axisMemberName) {
        AxisMember axisMember = this.getAxisMember(axisMemberName);
        if (axisMember != null) {
            axisMember.addMember_CP();
        }
    }

    void calculateCrossJoin(int cpSize) {
        if (this.members.size() == 0) {
            return;
        }
        int[] k = new int[this.members.size()];
        k[this.members.size() - 1] = 1;
        int i = this.members.size() - 1;
        while (i > 0) {
            k[i - 1] = k[i] * ((AxisMember)this.members.get(i)).getMember_CP().size();
            --i;
        }
        int currentPos = 0;
        int index = 0;
        while (cpSize > 0) {
            ArrayList<Object> objects = new ArrayList<Object>();
            int relativePos = currentPos;
            int j = 0;
            while (j < this.members.size()) {
                ArrayList memberData = ((AxisMember)this.members.get(j)).getMember_CP();
                index = relativePos / k[j];
                Object[] temp = (Object[])memberData.get(index);
                int i2 = 0;
                while (i2 < temp.length) {
                    objects.add(temp[i2]);
                    ++i2;
                }
                relativePos %= k[j];
                ++j;
            }
            currentPos += this.members.size();
            this.dataArrayList.add(objects.toArray());
            --cpSize;
        }
        int i3 = 0;
        while (i3 < this.members.size()) {
            ((AxisMember)this.members.get(i3)).refreshMember_CP();
            ++i3;
        }
    }

    class AxisMember {
        private String memberName;
        private Object[] tempMetaData = new Object[4];
        private Object[] metaDataKeys = new Object[4];
        private Object[] dataArray = null;
        private ArrayList cpMember = new ArrayList();

        AxisMember(String name) {
            this.memberName = name;
        }

        String getName() {
            return this.memberName;
        }

        int getMetaDataSize() {
            return this.tempMetaData.length;
        }

        Object[] getTempMeta() {
            return this.tempMetaData;
        }

        Object[] getMemberData() {
            return this.dataArray;
        }

        void setupTempMeta(String key, String keyName) {
            Integer type = (Integer)AxisData.this.memberTypes.get(key);
            if (type == null) {
                type = new Integer(12);
            }
            Object[] key_type = new Object[]{key, type};
            if (key.equals("UName")) {
                this.tempMetaData[1] = new BIColumnMetaData(AxisData.this.connectionInfo, 12, this.memberName + "." + IBICursorColumn.MEMBER_UNIQUE_NAME.toString());
                this.metaDataKeys[1] = key_type;
            } else if (key.equals("Caption")) {
                this.tempMetaData[0] = new BIColumnMetaData(AxisData.this.connectionInfo, 12, this.memberName + "." + IBICursorColumn.MEMBER_CAPTION.toString());
                this.metaDataKeys[0] = key_type;
            } else if (key.equals("LName")) {
                this.tempMetaData[2] = new BIColumnMetaData(AxisData.this.connectionInfo, 12, this.memberName + "." + IBICursorColumn.LEVEL_UNIQUE_NAME.toString());
                this.metaDataKeys[2] = key_type;
            } else if (key.equals("LNum")) {
                this.tempMetaData[3] = new BIColumnMetaData(AxisData.this.connectionInfo, 4, this.memberName + "." + IBICursorColumn.LEVEL_NUMBER.toString());
                this.metaDataKeys[3] = key_type;
            } else if (key.equals("DisplayInfo")) {
                int size = this.tempMetaData.length;
                Object[] tempMetaData = new Object[size + 1];
                System.arraycopy(this.tempMetaData, 0, tempMetaData, 0, size);
                tempMetaData[size] = new BIColumnMetaData(AxisData.this.connectionInfo, 4, this.memberName + "." + IBICursorColumn.DISPLAY_INFO.toString());
                this.tempMetaData = tempMetaData;
                Object[] metaDataKeys = new Object[size + 1];
                System.arraycopy(this.metaDataKeys, 0, metaDataKeys, 0, size);
                metaDataKeys[size] = key_type;
                this.metaDataKeys = metaDataKeys;
            } else {
                String metaDataName = keyName.substring(keyName.lastIndexOf(91) + 1, keyName.lastIndexOf(93));
                metaDataName = this.memberName + "." + "Attribute" + "." + metaDataName + "." + IBICursorColumn.VALUE;
                int size = this.tempMetaData.length;
                Object[] tempMetaData = new Object[size + 1];
                System.arraycopy(this.tempMetaData, 0, tempMetaData, 0, size);
                tempMetaData[size] = new BIColumnMetaData(AxisData.this.connectionInfo, type.intValue(), metaDataName);
                this.tempMetaData = tempMetaData;
                Object[] metaDataKeys = new Object[size + 1];
                System.arraycopy(this.metaDataKeys, 0, metaDataKeys, 0, size);
                metaDataKeys[size] = key_type;
                this.metaDataKeys = metaDataKeys;
            }
        }

        void addMemberDataToArray(String value, String type) {
            if (this.dataArray == null) {
                this.dataArray = new Object[this.getMetaDataSize()];
            }
            int i = 0;
            while (i < this.metaDataKeys.length) {
                if (type.equals((String)((Object[])this.metaDataKeys[i])[0])) break;
                ++i;
            }
            if (i == this.metaDataKeys.length) {
                return;
            }
            this.dataArray[i] = DatasetContentHandler.getValueObject(value, (Integer)((Object[])this.metaDataKeys[i])[1]);
        }

        void addMember_CP() {
            this.cpMember.add(this.dataArray);
        }

        ArrayList getMember_CP() {
            return this.cpMember;
        }

        void refreshMember_CP() {
            this.cpMember.clear();
        }
    }
}

