/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla;

import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.connector.IBIRelationalObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.BIRelational;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.relational.query.impl.BIQuery;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import java.sql.ResultSet;
import java.util.List;
import java.util.Locale;
import javax.jmi.reflect.RefPackage;
import org.omg.cwm.resource.relational.Catalog;
import org.omg.cwm.resource.relational.Schema;
import org.omg.cwm.resource.relational.Table;

public class XmlaRelational
extends BIRelational
implements IBIRelational,
IBIRelationalObjectFinder {
    private XmlaConnection m_connection = null;
    private Connection xmlaConn = null;

    private XmlaRelational() {
    }

    public XmlaRelational(XmlaConnection connection) throws BIResourceException {
        this.m_connection = connection;
        if (this.m_connection == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        this.xmlaConn = this.m_connection.getConnection();
        if (this.xmlaConn == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector.rel_4003");
        }
    }

    public Boolean supports(IBIRelational.Supports feature) throws BIResourceException {
        return Boolean.TRUE;
    }

    public List getCatalog() throws BIResourceException {
        return this.xmlaConn.getCatalogRelational();
    }

    public Catalog getCurrentCatalog() throws BIResourceException {
        return this.xmlaConn.getCurrentCatalogRelational();
    }

    public void setCurrentCatalog(Catalog current) throws BIResourceException {
        this.xmlaConn.setCurrentCatalogRelational(current);
    }

    public List getSchema() throws BIResourceException {
        return this.xmlaConn.getSchemaRelational();
    }

    public void setCurrentSchema(Schema schema) throws BIResourceException {
        this.xmlaConn.setCurrentSchemaRelational(schema);
    }

    public Schema getCurrentSchema() throws BIResourceException {
        return this.xmlaConn.getCurrentSchemaRelational();
    }

    public List getTable() throws BIResourceException {
        return this.xmlaConn.getTableRelational();
    }

    public IBIRelationalObjectFinder getObjectFinder() throws BIResourceException {
        return this.xmlaConn.getObjectFinderRelational();
    }

    public IBIQuery createQuery() throws BIResourceException {
        return new BIQuery((IBIQueryExecute)this.xmlaConn, this.connectionInfo);
    }

    public RefPackage getRefPackage() throws BIResourceException {
        return this.xmlaConn.getRefPackageRelational();
    }

    public List getColumn(Table table) throws BIResourceException {
        return this.xmlaConn.getColumnRelational(table);
    }

    public ResultSet getResultSet(String query) throws BIResourceException {
        return this.xmlaConn.executeRelational(query);
    }
}

