/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.capabilities.IBIBwCapabilities;
import com.sap.ip.bi.sdk.dac.connector.impl.BIOlap;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.dac.olap.query.assoc.AssocPackage;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.BIMdxGenerator;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.IBIMdxGenerator;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.bw.BIBwParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.msolap.BIMsOlapParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIResultSet;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.List;
import java.util.Locale;
import javax.jmi.reflect.RefPackage;
import org.omg.cwm.analysis.olap.Cube;

public class XmlaOlap
extends BIOlap
implements IBIBwCapabilities {
    private XmlaConnection m_connection;
    private Connection connection;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaOlap == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaOlap = XmlaOlap.class$("com.sap.ip.bi.sdk.dac.connector.xmla.XmlaOlap")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaOlap).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private Locale locale;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaOlap;

    public XmlaOlap(XmlaConnection xmlaConn) throws BIResourceException {
        this.m_connection = xmlaConn;
        loc.entering(cat, "XmlaOlap(" + (Object)((Object)xmlaConn) + ")");
        if (this.m_connection == null) {
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        this.connection = this.m_connection.getConnection();
        this.connection.setOlap((IBIOlap)this);
        if (this.connection == null) {
            cat.errorT(loc, "XmlaConnection.getConnection() returns null");
            this.locale = Locale.getDefault();
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        try {
            this.locale = this.connection.getConnectionInfo().getLocale();
        }
        catch (BIResourceException e) {
            this.locale = Locale.getDefault();
        }
        loc.exiting();
    }

    public Boolean supports(IBIOlap.Supports feature) {
        if (feature == IBIOlap.Supports.BW_CAPABILITIES && this.getDataSourceType() == BIOlapDataSourceType.SAP_BW) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List getSchema() throws BIResourceException {
        return this.connection.getSchema();
    }

    public List getCube() throws BIResourceException {
        return this.connection.getCube();
    }

    public RefPackage getTopLevelPackage() throws BIResourceException {
        return this.connection.getTopLevelPackage();
    }

    public IBIConnectionInfo getConnectionInfo() throws BIResourceException {
        return this.connection.getConnectionInfo();
    }

    public IBIResultSet findMemberData(List restrictions, List selectedAttributes) throws BIResourceException {
        return this.connection.getObjectFinder().findMemberData(restrictions, selectedAttributes);
    }

    public IBIOlapObjectFinder getObjectFinder() throws BIResourceException {
        return this.connection.getObjectFinder();
    }

    public List getSapVariables(Cube cube) throws BIResourceException {
        AssocPackage assocPackage = (AssocPackage)this.getTopLevelPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.assoc");
        return assocPackage.getIBICubeOwnsSapVariable().getSapVariable(cube);
    }

    public IBIDataSet execute(Object nativeQuery) throws BIResourceException {
        if (!(nativeQuery instanceof String)) {
            throw new BIResourceException(this.locale, "sdk.dac.connector_1010", new Object[]{nativeQuery == null ? "<null>" : nativeQuery.getClass().getName()});
        }
        IBIDataSet dataset = null;
        try {
            dataset = this.m_connection.getConnection().getDataSet((String)nativeQuery);
        }
        catch (BIResourceException e) {
            e.log();
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector_1018", null, (Throwable)e);
        }
        return dataset;
    }

    public IBIDataSet executeInternal(Object queryParser) throws BIResourceException {
        IBIDataSet dataset = null;
        try {
            dataset = this.execute(((IBIMdxGenerator)queryParser).getMdxExpression());
            dataset = ((IBIMdxGenerator)queryParser).doPostProcessing(dataset);
        }
        catch (BIResourceException e) {
            e.log();
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector_1018", null, (Throwable)e);
        }
        catch (BIOlapQueryException e) {
            e.log();
            throw new BIResourceException(this.locale, cat, 500, loc, "sdk.dac.connector_1018", null, (Throwable)e);
        }
        return dataset;
    }

    public Object transform(Object queryParser) throws BIResourceException {
        String mdx = null;
        try {
            mdx = ((IBIMdxGenerator)queryParser).getMdxExpression();
        }
        catch (BIOlapQueryException e) {
            throw new BIResourceException(this.locale, (Throwable)e);
        }
        return mdx;
    }

    public Object createQueryParser(IBIQuery query) {
        BIOlapDataSourceType olapDataSourceType = this.getDataSourceType();
        if (olapDataSourceType == BIOlapDataSourceType.SAP_BW) {
            return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIBwParserFactory.getInstance(), (IBIOlap)this);
        }
        if (olapDataSourceType == BIOlapDataSourceType.MS_OLAP) {
            return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIMsOlapParserFactory.getInstance(), (IBIOlap)this);
        }
        return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIParserFactory.getInstance(), (IBIOlap)this);
    }

    public BIOlapDataSourceType getDataSourceType() {
        return this.connection.getDataSourceType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

