/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla;

import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnection;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionProperties;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionFactory;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionMetaData;
import com.sap.ip.bi.sdk.dac.connector.xmla.impl.Connection;
import com.sap.ip.bi.sdk.exception.BICapabilityNotSupportedException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class XmlaManagedConnection
implements ManagedConnection {
    private PrintWriter m_logWriter;
    protected XmlaManagedConnectionFactory m_managedConnectionFactory;
    private Subject m_subject;
    private XmlaConnectionProperties m_request_info;
    private Connection connection;
    private String user;
    private String passwd;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection = XmlaManagedConnection.class$("com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnection")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    protected Vector m_associated_connections = new Vector();
    protected Vector m_connection_listeners = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaManagedConnection;

    protected XmlaManagedConnection(XmlaManagedConnectionFactory managed_connection_factory, Subject subject, XmlaConnectionProperties request_info) throws ResourceException {
        loc.entering("XmlaManagedConnection.Constructor(" + managed_connection_factory + "," + subject + "," + request_info + ")");
        this.m_managedConnectionFactory = managed_connection_factory;
        this.m_logWriter = managed_connection_factory.m_logWriter;
        this.m_subject = subject;
        this.m_request_info = request_info;
        try {
            Properties connProps = new Properties(managed_connection_factory.m_properties);
            if (subject != null) {
                Iterator<Object> it = subject.getPrivateCredentials().iterator();
                Object pc = null;
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!pc.getClass().isAssignableFrom(obj.getClass())) continue;
                    pc = (PasswordCredential)obj;
                    break;
                }
                if (pc != null) {
                    connProps.setProperty(XmlaConnectionProperties.Parameter.USER.name, pc.getUserName());
                    connProps.setProperty(XmlaConnectionProperties.Parameter.PASSWD.name, new String(pc.getPassword()));
                }
            } else if (request_info != null && request_info.m_properties != null) {
                Enumeration e = ((Hashtable)request_info.m_properties).keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    connProps.setProperty(key, request_info.getProperty(key));
                }
            }
            this.connection = Connection.connect(connProps);
        }
        catch (Exception ex) {
            if (ex instanceof BIResourceException) {
                ((BIResourceException)((Object)ex)).log();
            } else {
                cat.errorT(loc, ex.toString());
            }
            throw new BIResourceException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), cat, 500, loc, "sdk.dac.connector_1100", null, (Throwable)ex);
        }
        loc.exiting();
    }

    protected boolean equals(XmlaManagedConnectionFactory managed_connection_factory, Subject subject, XmlaConnectionProperties request_info) throws ResourceException {
        String method = "equals( XmlaManagedConnectionFactory, Subject, XmlaConnectionProperties)";
        loc.entering("equals( XmlaManagedConnectionFactory, Subject, XmlaConnectionProperties)");
        if (this.m_subject != null && subject == null || this.m_subject == null && subject != null) {
            return false;
        }
        if (this.m_subject != null && !this.m_subject.equals(subject)) {
            return false;
        }
        if (managed_connection_factory != null && !this.m_managedConnectionFactory.equals(managed_connection_factory)) {
            return false;
        }
        return subject != null || this.compareProperties(request_info);
    }

    protected boolean compareProperties(XmlaConnectionProperties other) throws ResourceException {
        loc.entering("compareProperties(" + other + ")");
        XmlaConnectionProperties request_info = null;
        request_info = other == null ? new XmlaConnectionProperties(this.m_managedConnectionFactory.m_properties) : other;
        if (request_info.m_properties == null) {
            request_info.m_properties = this.m_managedConnectionFactory.m_properties;
        }
        if (((Hashtable)this.connection.getProperties()).size() < ((Hashtable)request_info.m_properties).size()) {
            loc.debugT(cat, "connection.getProperties().size() < request_info.m_properties.size()" + ((Hashtable)this.connection.getProperties()).size() + "  " + ((Hashtable)request_info.m_properties).size());
            loc.exiting((Object)new Boolean(false));
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.connection.getProperties()).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String valueMC = this.connection.getProperty(key);
            String valueNew = request_info.m_properties.getProperty(key);
            loc.debugT(cat, "key:" + key + "valueMC:" + valueMC + "valueNew:" + valueNew);
            if (valueMC != null && valueMC.length() > 0 && (valueNew == null || valueNew.length() == 0)) {
                is_equal = false;
                continue;
            }
            if ((valueMC == null || valueMC.length() == 0) && valueNew != null && valueNew.length() > 0) {
                is_equal = false;
                continue;
            }
            if (valueMC == null || valueNew == null || valueMC.equals(valueNew)) continue;
            is_equal = false;
        }
        loc.debugT(cat, "compareProperties  is_equal " + is_equal);
        loc.exiting((Object)new Boolean(is_equal));
        return is_equal;
    }

    /*
     * Loose catch block
     */
    public void destroy() throws ResourceException {
        block11: {
            if (this.connection == null) {
                return;
            }
            this.cleanup();
            Object var3_1 = null;
            try {
                this.connection.close();
                Object var6_3 = null;
                this.connection = null;
                break block11;
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                this.connection = null;
                throw throwable;
            }
            {
                catch (ResourceException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this.connection.close();
                    Object var6_5 = null;
                    this.connection = null;
                }
                catch (Throwable throwable2) {
                    Object var6_6 = null;
                    this.connection = null;
                    throw throwable2;
                }
                throw throwable;
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        loc.entering("getConnection(Subject, ConnectionRequestInfo)");
        this.assertConnection();
        return new XmlaConnection(this);
    }

    public void cleanup() throws ResourceException {
        Vector vector = this.m_associated_connections;
        synchronized (vector) {
            Vector list = (Vector)this.m_associated_connections.clone();
            int num_connections = list.size();
            int i = 0;
            while (i < num_connections) {
                ((XmlaConnection)((Object)list.elementAt(i))).dissociateManagedConnection();
                ++i;
            }
            this.m_associated_connections.removeAllElements();
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (connection == null) {
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        if (!(connection instanceof XmlaConnection)) {
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1007", new Object[]{connection.getClass()}, null);
        }
        this.assertConnection();
        ((XmlaConnection)((Object)connection)).associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners == null) {
            this.m_connection_listeners = new Vector();
        }
        this.m_connection_listeners.addElement(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (this.m_connection_listeners != null) {
            this.m_connection_listeners.removeElement(listener);
        }
    }

    public XAResource getXAResource() throws ResourceException {
        throw new BICapabilityNotSupportedException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), "sdk_1000");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new BICapabilityNotSupportedException(this.connection == null ? Locale.getDefault() : this.connection.getConnectionInfo().getLocale(), "sdk_1000");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.assertConnection();
        return new XmlaManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.m_logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.m_logWriter;
    }

    public XmlaManagedConnectionFactory getManagedConnectionFactory() {
        return this.m_managedConnectionFactory;
    }

    protected void unregisterConnection(XmlaConnection connection) {
        this.m_associated_connections.removeElement((Object)connection);
    }

    protected void assertConnection() throws BIResourceException {
        if (this.connection == null) {
            cat.errorT(loc, "assertConnection(): Connection is null");
            throw new BIResourceException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1101", null);
        }
        try {
            this.connection.isAlive();
        }
        catch (BIResourceException e) {
            Locale locale;
            e.log();
            try {
                locale = this.connection.getConnectionInfo().getLocale();
            }
            catch (BIResourceException ex) {
                locale = Locale.getDefault();
            }
            throw new BIResourceException(locale, cat, 500, loc, "sdk.dac.connector_1101", new Object[0], (Throwable)e);
        }
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void fireConnectionClosedEvent(javax.resource.cci.Connection connection) throws ResourceException {
        if (this.m_connection_listeners == null) {
            return;
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)connection);
        Vector list = (Vector)this.m_connection_listeners.clone();
        int i = 0;
        while (i < list.size()) {
            ((ConnectionEventListener)list.elementAt(i)).connectionClosed(event);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

