/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.xmla;

import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionManager;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionSpec;
import com.sap.ip.bi.sdk.dac.connector.xmla.XmlaManagedConnectionFactory;
import com.sap.ip.bi.sdk.exception.BICapabilityNotSupportedException;
import com.sap.ip.bi.sdk.exception.BIConnectionFailedException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sapportals.connector.ConnectorException;
import com.sapportals.connector.connection.ConnectionFailedException;
import com.sapportals.connector.connection.IConnection;
import com.sapportals.connector.connection.IConnectionFactory;
import com.sapportals.connector.connection.IConnectionSpec;
import com.sapportals.connector.metadata.IConnectorMetaData;
import java.util.Locale;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

class XmlaConnectionFactory
implements IConnectionFactory,
Referenceable {
    private XmlaManagedConnectionFactory m_managedConnectionFactory;
    private ConnectionManager m_connectionManager;
    private Reference m_reference;
    private int m_timeout;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaConnectionFactory == null ? (class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaConnectionFactory = XmlaConnectionFactory.class$("com.sap.ip.bi.sdk.dac.connector.xmla.XmlaConnectionFactory")) : class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaConnectionFactory).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$xmla$XmlaConnectionFactory;

    public XmlaConnectionFactory(XmlaManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) {
        this.m_managedConnectionFactory = managedConnectionFactory;
        this.m_connectionManager = connectionManager == null ? new XmlaConnectionManager() : connectionManager;
    }

    public Connection getConnection() throws ResourceException {
        loc.entering("getConnection()");
        XmlaManagedConnectionFactory.writeLog(this.m_managedConnectionFactory.getLogWriter(), "XmlaConnectionFactory.getConnection()", 1);
        loc.exiting();
        return this.getConnection(null);
    }

    public Connection getConnection(ConnectionSpec properties) throws ResourceException {
        if (properties != null) {
            loc.entering("getConnection(" + properties.toString() + ")");
        } else {
            loc.entering("getConnection(null)");
        }
        XmlaManagedConnectionFactory.writeLog(this.m_managedConnectionFactory.getLogWriter(), "XmlaConnectionFactory.getConnection(ConnectionSpec)", 1);
        loc.exiting();
        return (Connection)this.m_connectionManager.allocateConnection((ManagedConnectionFactory)this.m_managedConnectionFactory, (ConnectionRequestInfo)properties);
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return this.m_managedConnectionFactory.getResourceAdapterMetaData();
    }

    public void setReference(Reference reference) {
        this.m_reference = reference;
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        throw new BICapabilityNotSupportedException(Locale.getDefault(), "sdk_1000");
    }

    public Reference getReference() {
        return this.m_reference;
    }

    public IConnectionSpec getConnectionSpec() {
        return new XmlaConnectionSpec();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IConnection getConnectionEx(IConnectionSpec connectionSpec) throws ConnectionFailedException {
        IConnection iConnection;
        if (connectionSpec != null) {
            loc.entering("getConnectionEx(" + connectionSpec.toString() + ")");
        } else {
            loc.entering("getConnectionEx(null)");
        }
        try {
            try {
                iConnection = (IConnection)this.m_connectionManager.allocateConnection((ManagedConnectionFactory)this.m_managedConnectionFactory, (ConnectionRequestInfo)connectionSpec);
                Object var4_4 = null;
            }
            catch (ResourceException re) {
                if (re instanceof BIResourceException) {
                    ((BIResourceException)((Object)re)).log();
                    cat.errorT(loc, ((BIResourceException)((Object)re)).getNestedStackTraceString());
                    throw new BIConnectionFailedException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1100", null, (Throwable)re);
                }
                cat.errorT(loc, re.toString());
                throw new BIConnectionFailedException(Locale.getDefault(), cat, 500, loc, "sdk.dac.connector_1100", null, (Throwable)re);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            loc.exiting();
            throw throwable;
        }
        loc.exiting();
        return iConnection;
    }

    public int getConnectionTimeOut() {
        return this.m_timeout;
    }

    public IConnectorMetaData getMetaDataEx() throws ConnectorException {
        throw new BICapabilityNotSupportedException(Locale.getDefault(), "sdk_1000");
    }

    public void setConnectionTimeOut(int parm1) {
        loc.entering("setConnectionTimeOut(" + parm1 + ")");
        this.m_timeout = parm1;
        loc.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

