/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XmiDifference
extends XmiElement {
    private String href;
    private boolean diffReading;
    private Diff currentDiff;
    private Map diffs = new HashMap();
    private int timeStamp = 1;

    public XmiDifference(XmiElement parent, XmiContext context, Attributes attrs) {
        super(parent, context);
        this.href = attrs.getValue("href");
        if (this.href == null) {
            throw new JmiException("2126");
        }
        this.diffReading = false;
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        if (!this.diffReading) {
            if (qName.equals("XMI.difference")) {
                throw new JmiException("2127");
            }
            int kind = 0;
            if (qName.equals("XMI.delete")) {
                kind = 1;
            } else if (qName.equals("XMI.replace")) {
                kind = 2;
            }
            String localHref = attrs.getValue("href");
            int index = localHref.lastIndexOf("|");
            if (index == -1) {
                index = localHref.lastIndexOf("#");
            }
            String id = localHref.substring(index + 1, localHref.length());
            String posString = attrs.getValue("xmi.position");
            int position = 1;
            if (posString != null) {
                try {
                    position = Integer.parseInt(posString);
                }
                catch (NumberFormatException e) {
                    throw new JmiException("2128", new Object[]{posString});
                }
            }
            if (position < 0) {
                throw new JmiException("2129", new Object[]{posString});
            }
            this.currentDiff = new Diff(kind, id, position, this.timeStamp);
            ++this.timeStamp;
            this.diffReading = true;
        } else {
            this.currentDiff.items.add(new Item(qName, attrs));
        }
        return this;
    }

    public void characters(char[] buf, int offset, int len) {
        if (this.diffReading && buf != null && len > 0) {
            this.currentDiff.items.add(new String(buf, offset, len));
        }
    }

    public XmiElement endElement(String qName) {
        if (this.diffReading) {
            if (qName.equals("XMI.add") || qName.equals("XMI.delete") || qName.equals("XMI.replace")) {
                this.diffReading = false;
                LinkedList<Diff> list = (LinkedList<Diff>)this.diffs.get(this.currentDiff.xmiId);
                if (list == null) {
                    list = new LinkedList<Diff>();
                    this.diffs.put(this.currentDiff.xmiId, list);
                }
                if (this.currentDiff.kind == 1) {
                    list.addFirst(this.currentDiff);
                } else {
                    list.addLast(this.currentDiff);
                }
            } else {
                this.currentDiff.items.add(new Item(qName));
            }
            return this;
        }
        return this.parent;
    }

    public static class Item {
        public boolean isStart;
        public String qName;
        public Attributes attrs;

        public Item(String qName) {
            this.qName = qName;
            this.isStart = false;
        }

        public Item(String qName, Attributes attrs) {
            this.qName = qName;
            this.attrs = new AttributesImpl(attrs);
            this.isStart = true;
        }
    }

    public static class Diff {
        public static final int ADD = 0;
        public static final int DELETE = 1;
        public static final int REPLACE = 2;
        public int kind;
        public int position;
        public String xmiId;
        public LinkedList items = new LinkedList();
        public int timeStamp;

        public Diff(int kind, String xmiId, int position, int timeStamp) {
            this.kind = kind;
            this.xmiId = xmiId;
            this.position = position;
            this.timeStamp = timeStamp;
        }
    }
}

