/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofPackage;
import javax.jmi.model.NameNotResolvedException;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class DisplayModelElement {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$DisplayModelElement == null ? (class$com$sap$ip$mmr$tools$DisplayModelElement = DisplayModelElement.class$("com.sap.ip.mmr.tools.DisplayModelElement")) : class$com$sap$ip$mmr$tools$DisplayModelElement);
    Connection cx = null;
    MofPackage root = null;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$DisplayModelElement;

    public static void main(String[] args) {
        if (args.length == 0) {
            DisplayModelElement.writeUsage();
            return;
        }
        String qualifiedName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                DisplayModelElement.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            if (param.compareToIgnoreCase("name") != 0) continue;
            qualifiedName = XMIImport.getValue(args[i]);
        }
        if (qualifiedName == null) {
            DisplayModelElement.writeUsage();
            return;
        }
        DisplayModelElement dme = new DisplayModelElement();
        dme.display(qualifiedName);
        dme.close();
    }

    public static void writeUsage() {
        System.err.println("Usage: DisplayModelElement [-options]");
        System.err.println("where options include:");
        System.err.println("    -name=[qualified name]");
    }

    public DisplayModelElement() {
        try {
            ConnectionSpec cxs = new ConnectionSpec();
            Workspace workspace = new Workspace("DisplayModelElement");
            cxs.setWorkspace(workspace);
            ConnectionFactory cxf = new ConnectionFactory();
            this.cx = cxf.getConnection(cxs);
            this.root = this.cx.getMofPackageRootM2();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    protected void close() {
        if (this.cx != null) {
            try {
                this.cx.close();
            }
            catch (ResourceException e) {
                Repository.category.errorT(location, e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void display(String qualifiedName) {
        LocalTransaction lt = null;
        lt = this.cx.getLocalTransaction();
        lt.begin();
        try {
            ModelElement me = this.root.resolveQualifiedName(Utilities.getUtilities().decodeQualifiedName(qualifiedName));
            if (me != null) {
                if (me instanceof IModelElement) {
                    StringBuffer sb = new StringBuffer(1024);
                    IModelElement me_ = (IModelElement)me;
                    me_.toString(sb);
                    System.out.println(sb.toString());
                } else {
                    System.out.println(me.toString());
                }
            }
        }
        catch (NameNotResolvedException e) {
            Repository.category.errorT(location, e.toString());
        }
        Object var7_8 = null;
        if (lt == null) return;
        try {
            lt.rollback();
            return;
        }
        catch (ResourceException e2) {
            Repository.category.errorT(location, e2.toString());
        }
        return;
        {
            catch (Exception e) {
                Repository.category.errorT(location, e.toString());
                Object var7_9 = null;
                if (lt == null) return;
                try {
                    lt.rollback();
                    return;
                }
                catch (ResourceException e2) {
                    Repository.category.errorT(location, e2.toString());
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (lt == null) throw throwable;
            try {
                lt.rollback();
                throw throwable;
            }
            catch (ResourceException e2) {
                Repository.category.errorT(location, e2.toString());
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

