/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.search;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.Attribute;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.RefObject;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AttributesValues {
    public static final int VALUE_MAX_SIZE = 64;
    private static final String TAG_ID = "id";
    private static final String TAG_ATTRIBUTE_VALUES = "attributeValues";
    private static final String TAG_TYPE = "type";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String TAG_VALUE = "value";
    private static final String TAG_VALUE_ID = "value_id";
    private static final String TAG_MOFID = "mofid";
    private Map mapType = new HashMap();
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$search$AttributesValues == null ? (class$com$sap$ip$mmr$search$AttributesValues = AttributesValues.class$("com.sap.ip.mmr.search.AttributesValues")) : class$com$sap$ip$mmr$search$AttributesValues);
    static /* synthetic */ Class class$com$sap$ip$mmr$search$AttributesValues;

    public int size() {
        return this.mapType.size();
    }

    public void clear() {
        this.mapType.clear();
    }

    public void deleteInstances(Collection instances) {
        String method = "deleteInstances(Collection instances)";
        if (instances == null) {
            return;
        }
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o instanceof RefObject) {
                this.deleteInstance((RefObject)o);
                continue;
            }
            RepositoryServer.getCategory().errorT(location, "deleteInstances(Collection instances)", MMRResourceAccessor.getInstance().getMessageText("3010"), new Object[]{o.toString()});
        }
    }

    public void deleteInstance(RefObject refObject) {
        this.deleteInstance(refObject.refMofId());
    }

    public void deleteInstance(String mofIdToDelete) {
        Iterator i1 = this.mapType.values().iterator();
        while (i1.hasNext()) {
            HashMap mapAtr = (HashMap)i1.next();
            Iterator i2 = mapAtr.values().iterator();
            while (i2.hasNext()) {
                HashMap mapVal = (HashMap)i2.next();
                Iterator i3 = mapVal.values().iterator();
                while (i3.hasNext()) {
                    Set setMofId = (Set)i3.next();
                    setMofId.remove(mofIdToDelete);
                }
            }
        }
    }

    public Set getMofIds() {
        HashSet set = new HashSet();
        Iterator i1 = this.mapType.values().iterator();
        while (i1.hasNext()) {
            HashMap mapAtr = (HashMap)i1.next();
            Iterator i2 = mapAtr.values().iterator();
            while (i2.hasNext()) {
                HashMap mapVal = (HashMap)i2.next();
                Iterator i3 = mapVal.values().iterator();
                while (i3.hasNext()) {
                    Set setMofId = (Set)i3.next();
                    set.addAll(setMofId);
                }
            }
        }
        return set;
    }

    public void addInstances(Collection instances) {
        if (instances == null) {
            return;
        }
        Iterator iter = instances.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof RefObject)) continue;
            this.addInstance((RefObject)o);
        }
    }

    public void addInstance(RefObject refObject) {
        String method = "addInstance(RefObject refObject)";
        this.deleteInstance(refObject);
        RefObject metaObject = refObject.refMetaObject();
        if (metaObject == null) {
            RepositoryServer.getCategory().errorT(location, "addInstance(RefObject refObject)", MMRResourceAccessor.getInstance().getMessageText("3011"), new Object[]{refObject.toString()});
            return;
        }
        if (!(metaObject instanceof MofClass)) {
            RepositoryServer.getCategory().errorT(location, "addInstance(RefObject refObject)", MMRResourceAccessor.getInstance().getMessageText("3012"), new Object[]{refObject.toString()});
            return;
        }
        MofClass mc = (MofClass)metaObject;
        Iterator iter = Utilities.getUtilities().getAllContent((ModelElement)mc).iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof Attribute)) continue;
            String atrName = ((Attribute)o).getName();
            Object atrValue = null;
            try {
                atrValue = refObject.refGetValue(atrName);
            }
            catch (Exception e) {
                atrValue = null;
            }
            if (atrValue == null) continue;
            String str = atrValue instanceof String ? (String)atrValue : atrValue.toString();
            if (str != null && str.length() >= 64) {
                str = str.substring(0, 64);
            }
            this.addAttributeValue(atrName, str, Utilities.getUtilities().encodeQualifiedName(mc.getQualifiedName()), refObject.refMofId());
        }
    }

    protected void addAttributeValue(String atrName, Object atrValue, String type, String mofId) {
        HashSet<String> setMofId;
        HashMap mapVal;
        HashMap mapAtr = (HashMap)this.mapType.get(type);
        if (mapAtr == null) {
            mapAtr = new HashMap();
            this.mapType.put(type, mapAtr);
        }
        if ((mapVal = (HashMap)mapAtr.get(atrName)) == null) {
            mapVal = new HashMap();
            mapAtr.put(atrName, mapVal);
        }
        if ((setMofId = (HashSet<String>)mapVal.get(atrValue)) == null) {
            setMofId = new HashSet<String>();
            mapVal.put(atrValue, setMofId);
        }
        if (!setMofId.contains(mofId)) {
            setMofId.add(mofId);
        }
    }

    public static List queryCollection(Collection colToQuery, List qualifiedNameOfType, QueryFilters filters) {
        if (colToQuery == null || colToQuery.size() < 1) {
            return null;
        }
        ArrayList found = new ArrayList(colToQuery.size());
        found.addAll(colToQuery);
        String qnot = null;
        if (qualifiedNameOfType != null) {
            qnot = Utilities.getUtilities().encodeQualifiedName(qualifiedNameOfType);
        }
        Iterator iter = found.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            String qnot_ = null;
            if (o instanceof IMMRObject) {
                qnot_ = ((IMMRObject)o).get___QualifiedName();
            } else {
                if (!(o instanceof ModelElementImpl)) continue;
                qnot_ = ((ModelElementImpl)o).get___QualifiedNameOfType();
            }
            boolean failed = false;
            if (qnot != null && qnot.compareTo(qnot_) != 0) {
                failed = true;
            }
            if (!failed && filters != null && o instanceof RefObject) {
                RefObject ro = (RefObject)o;
                Iterator iterFilters = filters.iterator();
                while (iterFilters.hasNext() && !failed) {
                    QueryFilter qf = (QueryFilter)iterFilters.next();
                    Object value = null;
                    try {
                        value = ro.refGetValue(qf.getAttribute());
                    }
                    catch (Exception e) {
                        value = null;
                    }
                    if (value == null) continue;
                    if (value instanceof String) {
                        failed = !AttributesValues.compare(qf, (String)value);
                        continue;
                    }
                    failed = !AttributesValues.compare(qf, value.toString());
                }
            }
            if (!failed) continue;
            iter.remove();
        }
        return found;
    }

    protected static boolean compare(QueryFilter qf, String value) {
        String method = "compare(QueryFilter qf, String value)";
        boolean result = false;
        if (value == null) {
            return result;
        }
        switch (qf.getComparator()) {
            case 0: {
                result = value.compareTo(qf.getValue()) == 0;
                break;
            }
            case 1: {
                result = value.compareTo(qf.getValue()) != 0;
                break;
            }
            case 2: {
                result = value.compareTo(qf.getValue()) < 0;
                break;
            }
            case 3: {
                result = value.compareTo(qf.getValue()) > 0;
                break;
            }
            case 4: {
                result = value.compareTo(qf.getValue()) <= 0;
                break;
            }
            case 5: {
                result = value.compareTo(qf.getValue()) >= 0;
                break;
            }
            case 6: {
                result = Utilities.getUtilities().containsPattern(value, qf.getValue());
                break;
            }
            default: {
                RepositoryServer.getCategory().errorT(location, "compare(QueryFilter qf, String value)", MMRResourceAccessor.getInstance().getMessageText("3013"), new Object[]{new Integer(qf.getComparator())});
            }
        }
        return result;
    }

    public List query(List qualifiedNameOfType, QueryFilters filters) {
        LinkedList mofIds = new LinkedList();
        if (qualifiedNameOfType == null) {
            Iterator iter = this.mapType.values().iterator();
            while (iter.hasNext()) {
                HashMap map = (HashMap)iter.next();
                List l = this.query(map, filters);
                if (l == null) continue;
                mofIds.addAll(l);
            }
        } else {
            List l;
            String qn = Utilities.getUtilities().encodeQualifiedName(qualifiedNameOfType);
            HashMap map = (HashMap)this.mapType.get(qn);
            if (map != null && (l = this.query(map, filters)) != null) {
                mofIds.addAll(l);
            }
        }
        return mofIds;
    }

    protected List query(Map mapAtr, QueryFilters filters) {
        LinkedList mofIds = new LinkedList();
        if (filters == null) {
            return mofIds;
        }
        int n = 0;
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            QueryFilter qf = (QueryFilter)iter.next();
            List l = this.queryFilter(mapAtr, qf);
            if (n > 0) {
                if (mofIds.size() == 0) break;
                mofIds.retainAll(l);
            } else {
                mofIds.addAll(l);
            }
            ++n;
        }
        return mofIds;
    }

    protected List queryFilter(Map mapAtr, QueryFilter qf) {
        String method = "queryFilter(Map mapAtr, QueryFilter qf)";
        LinkedList mofIds = new LinkedList();
        HashMap mapVal = (HashMap)mapAtr.get(qf.getAttribute());
        if (mapVal != null) {
            Set setMofId = null;
            switch (qf.getComparator()) {
                case 0: {
                    setMofId = (Set)mapVal.get(qf.getValue());
                    if (setMofId == null) break;
                    mofIds.addAll(setMofId);
                    break;
                }
                case 1: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (value.compareTo(qf.getValue()) == 0) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                case 2: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (value.compareTo(qf.getValue()) >= 0) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                case 3: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (value.compareTo(qf.getValue()) <= 0) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                case 4: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (value.compareTo(qf.getValue()) > 0) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                case 5: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (value.compareTo(qf.getValue()) < 0) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                case 6: {
                    Iterator iter = mapVal.keySet().iterator();
                    while (iter.hasNext()) {
                        String value = (String)iter.next();
                        if (!Utilities.getUtilities().containsPattern(value, qf.getValue())) continue;
                        mofIds.addAll((Set)mapVal.get(value));
                    }
                    break;
                }
                default: {
                    RepositoryServer.getCategory().errorT(location, "queryFilter(Map mapAtr, QueryFilter qf)", MMRResourceAccessor.getInstance().getMessageText("3013"), new Object[]{new Integer(qf.getComparator())});
                }
            }
        }
        return mofIds;
    }

    public String xmlExport() {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        b.append('<');
        b.append(TAG_ATTRIBUTE_VALUES);
        b.append('>');
        Iterator i1 = this.mapType.keySet().iterator();
        while (i1.hasNext()) {
            String type = (String)i1.next();
            b.append('<');
            b.append(TAG_TYPE);
            b.append(' ');
            b.append(TAG_ID);
            b.append("=\"");
            b.append(type);
            b.append("\"");
            b.append('>');
            HashMap mapAtr = (HashMap)this.mapType.get(type);
            Iterator i2 = mapAtr.keySet().iterator();
            while (i2.hasNext()) {
                String attribute = (String)i2.next();
                b.append('<');
                b.append(TAG_ATTRIBUTE);
                b.append(' ');
                b.append(TAG_ID);
                b.append("=\"");
                b.append(attribute);
                b.append("\"");
                b.append('>');
                HashMap mapVal = (HashMap)mapAtr.get(attribute);
                Iterator i3 = mapVal.keySet().iterator();
                while (i3.hasNext()) {
                    String value = this.escape((String)i3.next());
                    b.append('<');
                    b.append(TAG_VALUE);
                    b.append("><");
                    b.append(TAG_VALUE_ID);
                    b.append('>');
                    b.append("<![CDATA[");
                    b.append(value);
                    b.append("]]>");
                    b.append("</");
                    b.append(TAG_VALUE_ID);
                    b.append('>');
                    Set setMofId = (Set)mapVal.get(value);
                    if (setMofId != null) {
                        Iterator i4 = setMofId.iterator();
                        while (i4.hasNext()) {
                            String mofId = (String)i4.next();
                            b.append('<');
                            b.append(TAG_MOFID);
                            b.append('>');
                            b.append(mofId);
                            b.append("</");
                            b.append(TAG_MOFID);
                            b.append('>');
                        }
                    }
                    b.append("</");
                    b.append(TAG_VALUE);
                    b.append('>');
                }
                b.append("</");
                b.append(TAG_ATTRIBUTE);
                b.append('>');
            }
            b.append("</");
            b.append(TAG_TYPE);
            b.append('>');
        }
        b.append("</");
        b.append(TAG_ATTRIBUTE_VALUES);
        b.append('>');
        return b.toString();
    }

    private String escape(String value) {
        String v = "";
        if (value != null) {
            v = value.replace('<', ' ');
            v = v.replace('>', ' ');
        }
        return v;
    }

    public void xmlImport(byte[] data) {
        String method = "xmlImport(byte data[])";
        if (data == null || data.length <= 0) {
            return;
        }
        try {
            MySAXHandler mySAXHandler = new MySAXHandler();
            SAXParser saxParser = ClassLoaderFactory.getClassLoaderFactory().getSAXParser(RepositoryServer.getRepositoryServer(), null);
            saxParser.parse((InputStream)new ByteArrayInputStream(data), (DefaultHandler)mySAXHandler);
        }
        catch (Exception e) {
            RepositoryServer.getCategory().errorT(location, "xmlImport(byte data[])", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
        }
    }

    public Map getMapType() {
        return this.mapType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MySAXHandler
    extends DefaultHandler {
        private String type;
        private String attribute;
        private String value;
        private String lastTag;

        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if (sName.compareTo(AttributesValues.TAG_VALUE) == 0) {
                this.value = attrs.getValue(AttributesValues.TAG_ID);
            } else if (sName.compareTo(AttributesValues.TAG_VALUE_ID) == 0) {
                this.value = attrs.getValue(AttributesValues.TAG_VALUE_ID);
            } else if (sName.compareTo(AttributesValues.TAG_ATTRIBUTE) == 0) {
                this.attribute = attrs.getValue(AttributesValues.TAG_ID);
            } else if (sName.compareTo(AttributesValues.TAG_TYPE) == 0) {
                this.type = attrs.getValue(AttributesValues.TAG_ID);
            }
            this.lastTag = sName;
        }

        public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
            if (arg0.length > 0) {
                if (this.lastTag.compareTo(AttributesValues.TAG_VALUE_ID) == 0) {
                    this.value = new String(arg0, arg1, arg2).trim();
                } else if (this.lastTag.compareTo(AttributesValues.TAG_MOFID) == 0) {
                    AttributesValues.this.addAttributeValue(this.attribute, this.value, this.type, new String(arg0, arg1, arg2).trim());
                } else {
                    AttributesValues.this.addAttributeValue(this.attribute, this.value, this.type, new String(arg0, arg1, arg2).trim());
                }
            }
        }
    }
}

