/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.model.Tag;

public class TagImpl
extends ModelElementImpl
implements Tag {
    static final long serialVersionUID = -50244575979495169L;
    public static final String TAGID = "tagId";
    public static final String VALUES = "values";
    public static final String ELEMENTS = "elements";
    private String tagId = "";
    private List values;

    public TagImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public TagImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public TagImpl(IRepository repository, String name, String annotation, String tagId, List values) {
        super(repository, name, annotation);
        this.initialize();
        this.setAnnotation(annotation);
        this.setTagId(tagId);
        this.values = values;
    }

    private final void initialize() {
        this.values = new ArrayList();
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof TagImpl) {
            TagImpl t = (TagImpl)modelElement;
            this.setTagId(t.tagId);
            if (!this.values.containsAll(t.values)) {
                this.values = new LinkedList(t.values);
                this.setState(StateEnum.STATE_CHANGED);
            }
        }
    }

    public String getTagId() {
        return this.tagId;
    }

    public final void setTagId(String newValue) {
        if (this.tagId == null || this.tagId.compareTo(newValue) != 0) {
            this.tagId = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public List getValues() {
        return this.values;
    }

    public Collection getElements() {
        return this.getModelPackage().getAttachesTo().getModelElement((Tag)this);
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(TAGID) == 0) {
            this.setTagId((String)value);
        } else if (featureName.compareTo(VALUES) == 0) {
            if (value instanceof List) {
                this.values = (List)value;
                this.setState(StateEnum.STATE_CHANGED);
            } else {
                this.values.add(value);
                this.setState(StateEnum.STATE_CHANGED);
            }
        } else if (featureName.compareTo(ELEMENTS) == 0) {
            this.getElements().add(value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(TAGID) == 0) {
                o = this.getTagId();
            } else if (featureName.compareTo(VALUES) == 0) {
                o = this.getValues();
            } else if (featureName.compareTo(ELEMENTS) == 0) {
                o = this.getElements();
            }
        }
        return o;
    }

    public String toStringWithValue() {
        int LENGTH = 15;
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append("   ");
        if (this.values.size() > 0) {
            buf.append(this.getTagId());
            buf.append(" = ");
            for (int i = 0; i < this.values.size(); ++i) {
                String str = this.values.get(i).toString();
                if (str != null) {
                    if (str.length() > 15) {
                        buf.append(str.substring(0, 15) + " ...");
                    } else {
                        buf.append(str);
                    }
                } else {
                    buf.append("[null]");
                }
                if (i + 1 >= this.values.size()) continue;
                buf.append(',');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    public static String encodeValues(List values) {
        StringBuffer buf = new StringBuffer(100);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String label = (String)iter.next();
            buf.append(label);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static List decodeValues(String valuesString) {
        ArrayList<String> list = new ArrayList<String>(1);
        int n = 0;
        while (n >= 0) {
            int m = valuesString.indexOf(10, n);
            String label = null;
            if (m > 0) {
                label = valuesString.substring(n, m);
                n = m + 1;
            } else {
                label = valuesString.substring(n);
                n = m;
            }
            if (label == null) continue;
            list.add(label);
        }
        return list;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        if (this.tagId == null) {
            col = this.addException(col, new JmiVerifyException("2608", new Object[]{this}));
        }
        if (this.values == null) {
            col = this.addException(col, new JmiVerifyException("2609", new Object[]{this}));
        }
        return col;
    }
}

