/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.AttributeWithType;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.ip.mmr.generate.jmi.GeneratorAttributeTemplate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;

public class GeneratorStructureType {
    public static String getJavaInterfaceName(StructureType structureType) {
        return Generator.getJMIIdentifier((ModelElement)structureType);
    }

    public static String getJavaInterfaceNameQualified(StructureType structureType) {
        return Generator.getJMIIdentifierQualified((Namespace)structureType);
    }

    public static String getJavaClassName(StructureType structureType) {
        return Generator.getJMIIdentifier((ModelElement)structureType) + "Impl";
    }

    public static String getJavaClassNameQualified(StructureType structureType) {
        return Generator.getJMIIdentifierQualified((Namespace)structureType) + "Impl";
    }

    public JavaSource generateTemplate(StructureType structureType, boolean noJavaDocs, boolean generateInterfaces) {
        AttributeWithType awt;
        StringBuffer code = new StringBuffer(1000);
        String javaInterfaceName = GeneratorStructureType.getJavaInterfaceName(structureType);
        String javaInterfaceNameQualified = GeneratorStructureType.getJavaInterfaceNameQualified(structureType);
        String javaClassName = GeneratorStructureType.getJavaClassName(structureType);
        String javaClassNameQualified = GeneratorStructureType.getJavaClassNameQualified(structureType);
        Generator.generatePackageStatement(code, (Namespace)structureType);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)structureType);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (generateInterfaces) {
            code.append(" extends javax.jmi.reflect.RefStruct ");
        } else {
            code.append(" implements ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        code.append(Utilities.SystemLineSeparator);
        ArrayList<AttributeWithType> fields = new ArrayList<AttributeWithType>();
        Iterator iter = Generator.getAllContent((ModelElement)structureType).iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof StructureField)) continue;
            StructureField sf = (StructureField)me;
            AttributeWithType awt2 = new AttributeWithType(Generator.getJMIIdentifier((ModelElement)sf), Generator.getType(sf.getType(), generateInterfaces));
            awt2.setClassifier(sf.getType());
            fields.add(awt2);
        }
        if (!generateInterfaces) {
            code.append("// structure fields");
            code.append(Utilities.SystemLineSeparator);
            iter = fields.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                code.append("private " + awt.getType() + " " + Generator.composeVariableName(awt.getName(), false) + ";");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append(Utilities.SystemLineSeparator);
        }
        if (!generateInterfaces) {
            String paramName;
            String variable;
            String paramName2;
            code.append("// constructors");
            code.append(Utilities.SystemLineSeparator);
            code.append("public ");
            code.append(javaClassName);
            code.append("() {}");
            code.append(Utilities.SystemLineSeparator);
            code.append("public ");
            code.append(javaClassName);
            code.append("(");
            code.append("com.sap.ip.mmr.IRepository repository");
            code.append(") {}");
            code.append(Utilities.SystemLineSeparator);
            code.append("public ");
            code.append(javaClassName);
            code.append("(");
            iter = fields.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                paramName2 = Generator.convertFirstCharToLower(awt.getName());
                code.append(awt.getType());
                code.append(" ");
                code.append(paramName2);
                if (!iter.hasNext()) continue;
                code.append(", ");
            }
            code.append(") {");
            code.append(Utilities.SystemLineSeparator);
            iter = fields.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                variable = Generator.composeVariableName(awt.getName(), false);
                paramName = Generator.convertFirstCharToLower(awt.getName());
                code.append("  ");
                code.append(variable);
                code.append(" = ");
                code.append(paramName);
                code.append(";");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
            code.append("public ");
            code.append(javaClassName);
            code.append("(");
            code.append("com.sap.ip.mmr.IRepository repository");
            iter = fields.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                paramName2 = Generator.convertFirstCharToLower(awt.getName());
                code.append(", ");
                code.append(awt.getType());
                code.append(" ");
                code.append(paramName2);
            }
            code.append(") {");
            code.append(Utilities.SystemLineSeparator);
            iter = fields.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                variable = Generator.composeVariableName(awt.getName(), false);
                paramName = Generator.convertFirstCharToLower(awt.getName());
                code.append("  ");
                code.append(variable);
                code.append(" = ");
                code.append(paramName);
                code.append(";");
                code.append(Utilities.SystemLineSeparator);
            }
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
            code.append(Utilities.SystemLineSeparator);
        }
        this.generateTemplateSpecific(fields, code, generateInterfaces);
        this.generateTemplateRef(fields, code, generateInterfaces);
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        JavaSource source = null;
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }

    private void generateTemplateSpecific(List fields, StringBuffer code, boolean generateInterfaces) {
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("// structure type specific methods");
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            AttributeWithType awt = (AttributeWithType)iter.next();
            String end = ";";
            if (!generateInterfaces) {
                end = " {";
            }
            l.add("public " + awt.getType() + " " + GeneratorAttributeTemplate.getAccessorName(awt.getName(), 1, awt.getClassifier()) + "() throws javax.jmi.reflect.JmiException" + end);
            if (!generateInterfaces) {
                l.add("  return " + Generator.composeVariableName(awt.getName(), false) + ";");
                l.add("}");
            }
            l.add("");
        }
        Generator.addToCode(code, l);
    }

    private void generateTemplateRef(List fields, StringBuffer code, boolean generateInterfaces) {
        AttributeWithType awt;
        if (generateInterfaces) {
            return;
        }
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("// structure type reflective methods");
        l.add("public java.util.List refFieldNames() {");
        l.add("  java.util.List list = new java.util.ArrayList(" + fields.size() + ");");
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            AttributeWithType awt2 = (AttributeWithType)iter.next();
            l.add("  list.add(\"" + awt2.getName() + "\");");
        }
        l.add("  return list;");
        l.add("}");
        l.add("public java.lang.Object refGetValue(java.lang.String fieldName) {");
        boolean flag = false;
        iter = fields.iterator();
        while (iter.hasNext()) {
            awt = (AttributeWithType)iter.next();
            String cmp = "fieldName.compareTo(\"" + awt.getName() + "\") == 0";
            String ret = "  return " + Generator.getJavaTypeAsObject(awt.getType(), Generator.composeVariableName(awt.getName(), false)) + ";";
            if (!flag) {
                l.add("if (" + cmp + ") {");
                l.add(ret);
                flag = true;
            } else {
                l.add("else if (" + cmp + ") {");
                l.add(ret);
            }
            l.add("}");
        }
        l.add("else {");
        l.add("  return null;");
        l.add("}");
        l.add("}");
        l.add("public java.util.List refTypeName() {");
        l.add(" return com.sap.ip.mmr.foundation.Utilities.getUtilities().decodeQualifiedName(this.getClass().getName());");
        l.add("}");
        l.add("public boolean equals(java.lang.Object other) {");
        l.add("  if (other == null) {");
        l.add("     return false;");
        l.add("  }");
        l.add("  if (!(other instanceof javax.jmi.reflect.RefStruct)) {");
        l.add("     return false;");
        l.add("  }");
        l.add("  javax.jmi.reflect.RefStruct rs = (javax.jmi.reflect.RefStruct) other;");
        l.add("  if (getClass().getName().compareTo(rs.getClass().getName()) != 0) {");
        l.add("     return false;");
        l.add("  }");
        iter = fields.iterator();
        while (iter.hasNext()) {
            awt = (AttributeWithType)iter.next();
            String var = Generator.getJavaTypeAsObject(awt.getType(), Generator.composeVariableName(awt.getName(), false));
            l.add("  if (" + var + " == null && rs.refGetValue(\"" + awt.getName() + "\") != null) {");
            l.add("     return false;");
            l.add("  }");
            l.add("  if (" + var + " != null && !(" + var + ".equals(rs.refGetValue(\"" + awt.getName() + "\")))) {");
            l.add("     return false;");
            l.add("  }");
        }
        l.add("  return true;");
        l.add("}");
        l.add("public int hashCode() {");
        l.add("  return super.hashCode();");
        l.add("}");
        Generator.addToCode(code, l);
    }
}

