/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.ip.mmr.generate.jmi.GeneratorAttributeTemplate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofException;
import javax.jmi.model.Namespace;
import javax.jmi.model.Parameter;

public class GeneratorException {
    public static String getJavaClassName(MofException mofException) {
        return Generator.getJMIIdentifier((ModelElement)mofException);
    }

    public static String getJavaClassNameQualified(MofException mofException) {
        return Generator.getJMIIdentifierQualified((Namespace)mofException);
    }

    public JavaSource generateTemplate(MofException mofException, boolean noJavaDocs, boolean generateInterfaces) {
        Parameter p;
        StringBuffer code = new StringBuffer(1000);
        if (generateInterfaces) {
            return null;
        }
        String javaClassName = GeneratorException.getJavaClassName(mofException);
        String javaClassNameQualified = GeneratorException.getJavaClassNameQualified(mofException);
        Generator.generatePackageStatement(code, (Namespace)mofException);
        Generator.generateDefaultIncludes(code);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)mofException);
        }
        code.append("public class ");
        code.append(javaClassName);
        code.append(" extends javax.jmi.reflect.RefException ");
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        ArrayList<ModelElement> params = new ArrayList<ModelElement>(10);
        Iterator iter = Generator.getAllContent((ModelElement)mofException).iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof Parameter)) continue;
            params.add(me);
        }
        code.append("// parameters");
        code.append(Utilities.SystemLineSeparator);
        iter = params.iterator();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            code.append("private ");
            code.append(Generator.getType(p.getType(), generateInterfaces));
            code.append(" ");
            code.append(Generator.getJMIIdentifier((ModelElement)p));
            code.append(";");
            code.append(Utilities.SystemLineSeparator);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append("// constructor");
        code.append(Utilities.SystemLineSeparator);
        code.append("public ");
        code.append(javaClassName);
        code.append("(");
        iter = params.iterator();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            code.append(Generator.getType(p.getType(), generateInterfaces));
            code.append(" ");
            code.append(Generator.getJMIIdentifier((ModelElement)p));
            if (!iter.hasNext()) continue;
            code.append(", ");
        }
        code.append(") {");
        code.append(Utilities.SystemLineSeparator);
        code.append("  super();");
        code.append(Utilities.SystemLineSeparator);
        iter = params.iterator();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            code.append("  this.");
            code.append(Generator.getJMIIdentifier((ModelElement)p));
            code.append(" = ");
            code.append(Generator.getJMIIdentifier((ModelElement)p));
            code.append(";");
            code.append(Utilities.SystemLineSeparator);
        }
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        code.append(Utilities.SystemLineSeparator);
        code.append("// accessor methods for all parameters");
        code.append(Utilities.SystemLineSeparator);
        iter = params.iterator();
        while (iter.hasNext()) {
            p = (Parameter)iter.next();
            code.append("public ");
            code.append(Generator.getType(p.getType(), generateInterfaces));
            code.append(" ");
            code.append(GeneratorAttributeTemplate.getAccessorName(Generator.getJMIIdentifier((ModelElement)p), p.getMultiplicity().getUpper(), p.getType()));
            code.append("() {");
            code.append(Utilities.SystemLineSeparator);
            code.append("  return this.");
            code.append(Generator.getJMIIdentifier((ModelElement)p));
            code.append(";");
            code.append(Utilities.SystemLineSeparator);
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
        }
        code.append(Utilities.SystemLineSeparator);
        code.append(Utilities.SystemLineSeparator);
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        JavaSource source = null;
        source = new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }
}

