/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import javax.jmi.model.AliasType;
import javax.jmi.model.CollectionType;
import javax.jmi.model.DataType;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;
import javax.jmi.model.PrimitiveType;

public class GeneratorDataType {
    public static String getJavaInterfaceName(DataType dataType) {
        return Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)dataType));
    }

    public static String getJavaInterfaceNameQualified(DataType dataType) {
        return Generator.getJMIIdentifierQualified((Namespace)dataType);
    }

    public static String getJavaClassName(DataType dataType) {
        return GeneratorDataType.getJavaInterfaceName(dataType) + "Impl";
    }

    public static String getJavaClassNameQualified(DataType dataType) {
        return GeneratorDataType.getJavaInterfaceNameQualified(dataType) + "Impl";
    }

    public JavaSource generateTemplate(DataType dataType, boolean noJavaDocs, boolean generateInterfaces) {
        if (dataType instanceof PrimitiveType && Generator.isJavaType(dataType.getName())) {
            return null;
        }
        if (dataType instanceof CollectionType) {
            return null;
        }
        StringBuffer code = new StringBuffer(1000);
        String javaInterfaceName = GeneratorDataType.getJavaInterfaceName(dataType);
        String javaInterfaceNameQualified = GeneratorDataType.getJavaInterfaceNameQualified(dataType);
        String javaClassName = GeneratorDataType.getJavaClassName(dataType);
        String javaClassNameQualified = GeneratorDataType.getJavaClassNameQualified(dataType);
        Generator.generatePackageStatement(code, (Namespace)dataType);
        if (!noJavaDocs) {
            Generator.generateAnnotationTemplate(code, (ModelElement)dataType);
        }
        if (generateInterfaces) {
            code.append("public interface ");
            code.append(javaInterfaceName);
        } else {
            code.append("public class ");
            code.append(javaClassName);
        }
        if (dataType instanceof PrimitiveType || dataType instanceof CollectionType || dataType instanceof AliasType) {
            return null;
        }
        if (generateInterfaces) {
            code.append(" extends javax.jmi.reflect.RefStruct ");
        } else {
            code.append(" implements ");
            code.append(javaInterfaceNameQualified);
        }
        code.append(" {");
        code.append(Utilities.SystemLineSeparator);
        code.append("}");
        code.append(Utilities.SystemLineSeparator);
        JavaSource source = null;
        source = generateInterfaces ? new JavaSource(javaInterfaceNameQualified) : new JavaSource(javaClassNameQualified);
        source.setSourceCode(code.toString());
        return source;
    }
}

