/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.javamodel;

import com.sap.ip.mmr.generate.javamodel.JavaElement;
import java.util.ArrayList;
import java.util.List;

public class JavaAttribute
extends JavaElement {
    public static final int VISIBILITY_PUBLIC = 2;
    public static final int VISIBILITY_PROTECTED = 1;
    public static final int VISIBILITY_PRIVATE = 0;
    private boolean key = false;
    private int visibility = 0;
    private int multiplicity = 1;
    private String type = "java.lang.String";

    public JavaAttribute(String name) {
        super(JavaAttribute.correctName(name));
    }

    public static String correctName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() < 1) {
            return "";
        }
        String n = name.substring(0, 1).toLowerCase();
        if (name.length() > 1) {
            n = n + name.substring(1);
        }
        return n;
    }

    protected List getCode() {
        ArrayList<String> code = new ArrayList<String>();
        code.add(this.getVisibilityAsString() + " " + this.getType() + " " + this.name + ";");
        return code;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public String getVisibilityAsString() {
        String vis = null;
        switch (this.visibility) {
            case 2: {
                vis = "public";
                break;
            }
            case 1: {
                vis = "protected";
                break;
            }
            case 0: {
                vis = "private";
                break;
            }
            default: {
                vis = "private";
            }
        }
        return vis;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public boolean isKey() {
        return this.key;
    }

    public void setKey(boolean key) {
        this.key = key;
    }
}

