/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.applications;

import com.sap.ip.mmr.applications.IProgressMonitor;
import com.sap.ip.mmr.applications.ProgressMonitorDefault;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressMonitorSwing
extends ProgressMonitorDefault {
    private JFrame frame;
    private Container container = null;
    private JPanel panelMain;
    private JProgressBar jProgressBar;
    private JLabel jLabelTimes;
    private JLabel jLabel;
    private UpdateThread thread;

    public ProgressMonitorSwing(Container containerInput) {
        this.initSwing(containerInput);
    }

    public JFrame getJFrame() {
        return this.frame;
    }

    private void initSwing(Container containerInput) {
        int width = 350;
        if (this.container == null) {
            if (containerInput == null) {
                this.frame = new JFrame();
                this.container = this.frame.getContentPane();
            } else {
                this.container = containerInput;
            }
            this.panelMain = new JPanel();
            this.panelMain.setLayout(new GridLayout(3, 1));
            this.panelMain.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.container.add(this.panelMain);
            this.jProgressBar = new JProgressBar();
            this.jProgressBar.setPreferredSize(new Dimension(350, 20));
            this.jProgressBar.setBorderPainted(true);
            this.jProgressBar.setStringPainted(true);
            this.panelMain.add(this.jProgressBar);
            this.jLabelTimes = new JLabel();
            this.jLabelTimes.setPreferredSize(new Dimension(350, 20));
            this.jLabelTimes.setHorizontalTextPosition(2);
            this.jLabelTimes.setText("                  ");
            this.jLabelTimes.setFont(this.jLabelTimes.getFont().deriveFont(10.0f));
            this.panelMain.add(this.jLabelTimes);
            this.jLabel = new JLabel();
            this.jLabel.setPreferredSize(new Dimension(350, 20));
            this.jLabel.setHorizontalTextPosition(2);
            this.jLabel.setText("                  ");
            this.jLabel.setFont(this.jLabel.getFont().deriveFont(10.0f));
            this.panelMain.add(this.jLabel);
            if (this.frame != null) {
                this.frame.pack();
                this.frame.setVisible(true);
            }
            this.thread = new UpdateThread(this);
            this.thread.start();
        }
    }

    public void finish() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public void setMaximum(int maximum) {
        super.setMaximum(maximum);
        if (this.jProgressBar != null) {
            this.jProgressBar.setMaximum(maximum);
        }
    }

    public void setMinimum(int minimum) {
        super.setMinimum(minimum);
        if (this.jProgressBar != null) {
            this.jProgressBar.setMinimum(minimum);
        }
    }

    class UpdateThread
    extends Thread {
        Runnable update;
        Runnable finish;
        boolean run = true;
        IProgressMonitor pm = null;

        public UpdateThread(IProgressMonitor pm) {
            this.pm = pm;
            ProgressMonitorSwing.this.jProgressBar.setMinimum(pm.getMinimum());
            ProgressMonitorSwing.this.jProgressBar.setMaximum(pm.getMaximum());
            ProgressMonitorSwing.this.jLabel.setText(pm.getNote());
            ProgressMonitorSwing.this.jLabelTimes.setText(ProgressMonitorSwing.this.getTimeInformation());
            this.update = new Runnable(this){
                private final /* synthetic */ UpdateThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProgressMonitorSwing.access$000(UpdateThread.access$300(this.this$1)).setValue(this.this$1.getPm().getProgress());
                    ProgressMonitorSwing.access$100(UpdateThread.access$300(this.this$1)).setText(this.this$1.getPm().getNote());
                    ProgressMonitorSwing.access$200(UpdateThread.access$300(this.this$1)).setText(UpdateThread.access$300(this.this$1).getTimeInformation());
                }
            };
            this.finish = new Runnable(this){
                private final /* synthetic */ UpdateThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProgressMonitorSwing.access$000(UpdateThread.access$300(this.this$1)).setValue(this.this$1.getPm().getProgress());
                    ProgressMonitorSwing.access$100(UpdateThread.access$300(this.this$1)).setText(this.this$1.getPm().getNote());
                    ProgressMonitorSwing.access$200(UpdateThread.access$300(this.this$1)).setText(UpdateThread.access$300(this.this$1).getTimeInformation());
                    this.this$1.run = false;
                }
            };
        }

        public void run() {
            while (this.run) {
                SwingUtilities.invokeLater(this.update);
                try {
                    UpdateThread.sleep(200L);
                }
                catch (InterruptedException e) {
                    this.run = false;
                }
            }
            SwingUtilities.invokeLater(this.finish);
        }

        public IProgressMonitor getPm() {
            return this.pm;
        }

        static /* synthetic */ ProgressMonitorSwing access$300(UpdateThread x0) {
            return x0.ProgressMonitorSwing.this;
        }
    }
}

