/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi.ddtypes;

import com.sap.mdi.ddtypes.DDBuiltInType;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDReferenceType;
import com.sap.mdi.ddtypes.DDUserDefType;
import com.sap.mw.jco.JCO;

public class DDTabletype
extends DDUserDefType {
    private String linetypeName = " ";
    private String rowkind = " ";
    private int typelen = 0;
    private String mac = " ";
    private String f4available = " ";
    private String description = null;

    public DDTabletype(DDFactory factory, JCO.Record dfies, JCO.Record x030l) {
        super(factory, x030l);
        this.setName(dfies.getString("TABNAME"));
        String rowkind = x030l.getString("BUFSTATE");
        String datatype = dfies.getString("DATATYPE");
        if (0 == rowkind.compareToIgnoreCase("R")) {
            this.linetypeName = x030l.getString("REFNAME");
            DDReferenceType referenceType = new DDReferenceType(factory, dfies, this.linetypeName);
            this.setChild(referenceType);
            referenceType.setParent(this);
        } else if (0 == rowkind.length()) {
            DDBuiltInType builtInType = new DDBuiltInType(dfies);
            this.setChild(builtInType);
            builtInType.setParent(this);
        } else {
            this.linetypeName = dfies.getString("ROLLNAME");
            this.setChildName(this.linetypeName);
            this.typelen = x030l.getInt("TABLEN");
            this.mac = dfies.getString("MAC");
            this.f4available = dfies.getString("F4AVAILABL");
        }
    }

    public String getLinetype() {
        if (0 == this.rowkind.compareToIgnoreCase("S")) {
            return "Structure";
        }
        if (0 == this.rowkind.compareToIgnoreCase("L")) {
            return "Tabletype";
        }
        if (0 == this.rowkind.compareToIgnoreCase("E")) {
            return "DDDataelement";
        }
        if (0 == this.rowkind.compareToIgnoreCase("R")) {
            return "ReferenceType";
        }
        return "DDBuiltInType";
    }

    public boolean hasReference() {
        return 0 == this.rowkind.compareToIgnoreCase("R");
    }

    public String getLinetypeName() {
        return this.linetypeName;
    }

    public int getTypelen() {
        return this.typelen;
    }

    public boolean hasSearchhelp() {
        return this.mac.equalsIgnoreCase("X");
    }

    public boolean hasF4() {
        return this.f4available.equalsIgnoreCase("X");
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        JCO.Function function = this.getFactory().getFunction("MDI_TTYP_INFO_GET");
        if (function == null) {
            return " ";
        }
        function.getImportParameterList().setValue(this.getName(), "TTYP_NAME");
        JCO.Structure getState = function.getImportParameterList().getStructure("GET_STATE");
        getState.setValue("A", "TTYP");
        getState.setValue(" ", "TTHD");
        getState.setValue(" ", "TTKF");
        function.getImportParameterList().setValue(this.getFactory().getClient().getLanguage(), "LANGU");
        function.getImportParameterList().setValue("X", "WITHTEXT");
        if (!this.getFactory().execute(function)) {
            return " ";
        }
        JCO.ParameterList paraList = function.getExportParameterList();
        this.description = paraList.getStructure("DD40V_WA_A").getString("DDTEXT");
        return this.description;
    }
}

