/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

class Type
implements Serializable,
Cloneable {
    private int value;
    private transient String desc;
    private static final Hashtable types = new Hashtable();

    protected Type(int value, String desc) {
        this.value = value;
        this.desc = desc;
        this.checkForDuplicates(this);
        this.storeType(this);
    }

    private void checkForDuplicates(Type type) {
        String className = type.getClass().getName();
        Hashtable values = (Hashtable)types.get(className);
        if (values != null && values.get(new Integer(type.getValue())) != null) {
            System.out.println("No Duplicates Allowed: " + className + "=" + type);
            throw new RuntimeException();
        }
    }

    public static Enumeration elements(Class classRef) {
        String className = classRef.getName();
        Hashtable values = (Hashtable)types.get(className);
        if (values != null) {
            return values.elements();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.getValue() == ((Type)obj).getValue();
    }

    public static Type getByValue(Class classRef, int value) {
        Type type = null;
        String className = classRef.getName();
        Hashtable values = (Hashtable)types.get(className);
        if (values != null) {
            type = (Type)values.get(new Integer(value));
        }
        return type;
    }

    public static int getMaxValue(Class classRef) {
        int max = -1;
        Enumeration e = Type.elements(classRef);
        while (e.hasMoreElements()) {
            Type type = (Type)e.nextElement();
            int tmp = type.getValue();
            if (tmp <= max) continue;
            max = tmp;
        }
        return max;
    }

    public int getValue() {
        return this.value;
    }

    private void storeType(Type type) {
        Hashtable<Integer, Type> values;
        String className = type.getClass().getName();
        Hashtable hashtable = types;
        synchronized (hashtable) {
            values = (Hashtable<Integer, Type>)types.get(className);
            if (values == null) {
                values = new Hashtable<Integer, Type>();
                types.put(className, values);
            }
        }
        values.put(new Integer(type.getValue()), type);
    }
}

