/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.Field;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.MetaDataAccessNotBasedOnDictionaryException;
import com.sap.mdi.MetaDataAccessNotImportException;
import com.sap.mdi.MetaDataAccessNotScalarException;
import com.sap.mdi.RfmParameters;
import com.sap.mdi.Structure;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDField;
import com.sap.mdi.ddtypes.DDObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public final class RfmParameter {
    String name;
    String description;
    boolean isOptional;
    boolean isStructure;
    boolean isImport;
    boolean isExport;
    boolean isChanging;
    boolean isTable;
    boolean isTabletype;
    boolean isDataelement;
    String tableName;
    String ddFieldName;
    boolean referencesDD;
    String fieldName;
    String abapDataType;
    int internalLength;
    int decimals;
    String defaultDefinition;
    RfmParameters parent;

    RfmParameter(String name, String description, String tableName, int internalLength, boolean isOptional) {
        this.name = name;
        this.description = description;
        this.tableName = tableName;
        this.isOptional = isOptional;
        this.isTable = true;
        this.isStructure = false;
        this.isImport = true;
        this.isExport = true;
        this.referencesDD = true;
        this.fieldName = null;
        this.abapDataType = null;
        this.internalLength = internalLength;
        this.decimals = -1;
        this.defaultDefinition = null;
    }

    RfmParameter(String name, String description, boolean isImport, String tableName, int internalLength, boolean isOptional) {
        this.name = name;
        this.description = description;
        this.tableName = tableName;
        this.isOptional = isImport ? isOptional : true;
        this.isImport = isImport;
        this.isExport = !isImport;
        this.isTable = false;
        this.isStructure = true;
        this.referencesDD = true;
        this.fieldName = null;
        this.abapDataType = null;
        this.internalLength = internalLength;
        this.decimals = -1;
        this.defaultDefinition = null;
    }

    RfmParameter(String name, String description, boolean isImport, boolean referencesDD, String tableName, String fieldName, boolean isOptional, String abapDataType, int internalLength, int decimals, String defaultDefinition) {
        this.name = name;
        this.description = description;
        this.referencesDD = referencesDD;
        this.isImport = isImport;
        this.isExport = !isImport;
        this.tableName = tableName;
        this.fieldName = fieldName.equals("") ? null : fieldName;
        this.isOptional = isImport ? isOptional : true;
        this.abapDataType = abapDataType;
        this.internalLength = internalLength;
        this.decimals = decimals;
        this.defaultDefinition = defaultDefinition;
        this.isStructure = false;
        this.isTable = false;
    }

    public String getDescription() {
        return this.description;
    }

    public int getInternalLength() {
        return this.internalLength;
    }

    public int getInternalLengthUc(int uclen) {
        if (this.abapDataType == null) {
            return 0;
        }
        if ("CDNT".indexOf(this.abapDataType) == -1) {
            return this.internalLength;
        }
        int intUcLen = this.internalLength;
        int sysUcLen = this.parent.parent.parent.bof.getDDFactory().getUcLengthOfConnectedSystem();
        if (sysUcLen == -1) {
            return -1;
        }
        if (sysUcLen == uclen) {
            return this.internalLength;
        }
        if (sysUcLen != 1) {
            intUcLen = this.internalLength / sysUcLen;
        }
        return intUcLen * uclen;
    }

    public String getName() {
        return this.name;
    }

    String getScalarCheckTable() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).getCheckTable();
    }

    String getScalarConversionExit() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).getConversionExit();
    }

    public String getScalarDataTypeABAP() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.abapDataType;
    }

    String getScalarDataTypeDD() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            return this.tableName;
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).getDataTypeDD();
    }

    int getScalarDecimals() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.decimals;
    }

    public String getScalarDefaultDefinition() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isImport()) {
            throw new MetaDataAccessNotImportException();
        }
        return this.defaultDefinition;
    }

    public String getScalarDefaultValue() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isImport()) {
            throw new MetaDataAccessNotImportException();
        }
        String sDefault = this.defaultDefinition;
        if (sDefault.equals("")) {
            return null;
        }
        if (sDefault.equals("SPACE") || sDefault.equals("''")) {
            return "";
        }
        if (sDefault.equals("SY-LANGU")) {
            return this.parent.parent.parent.bof.getUserLogonLanguage();
        }
        if (sDefault.equals("SY-UNAME")) {
            return this.parent.parent.parent.bof.getUserName();
        }
        if (sDefault.equals("SY-DATUM")) {
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            return formatter.format(date);
        }
        if (sDefault.equals("SY-DATLO")) {
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            return formatter.format(date);
        }
        if (sDefault.startsWith("'") && sDefault.endsWith("'")) {
            return sDefault.substring(1, sDefault.length() - 1);
        }
        return sDefault;
    }

    void setDataelementDefaultValue(String defaultValue) {
        this.defaultDefinition = defaultValue;
    }

    public String getDataelementDefaultValue() {
        return this.defaultDefinition;
    }

    Field getScalarField() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName);
    }

    public String getScalarFieldName() {
        return this.fieldName;
    }

    int getScalarLength() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).getLength();
    }

    int getScalarOutputLength() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).getOutputLength();
    }

    Structure getStructure() throws MetaDataAccessException {
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName);
    }

    public String getStructureName() {
        if (this.isBasedOnDictionaryReference()) {
            return this.tableName;
        }
        return null;
    }

    public boolean isBasedOnDictionaryReference() {
        return this.referencesDD;
    }

    boolean isConsistent() {
        try {
            if (this.isScalar()) {
                Field f;
                if (this.isBasedOnDictionaryReference() ? (f = this.getScalarField()) == null : this.getScalarDataTypeDD().equals("")) {
                    return false;
                }
            } else if (this.isStructure()) {
                Structure s = this.getStructure();
                if (s == null) {
                    return false;
                }
            } else if (this.isTable()) {
                Structure s = this.getStructure();
                if (s == null) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isExport() {
        return this.isExport;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean isChanging() {
        return this.isChanging;
    }

    public void setIsChanging(String paramType) {
        if (paramType.equals("C")) {
            this.isImport = true;
            this.isExport = true;
            this.isChanging = true;
        }
    }

    public void setRealType(String typekind) {
        if (typekind.equalsIgnoreCase("h")) {
            this.isTabletype = true;
        } else if (typekind.equalsIgnoreCase("E")) {
            this.isDataelement = true;
        }
        this.isStructure = false;
    }

    public boolean isTabletype() {
        return this.isTabletype;
    }

    public boolean isDataelement() {
        return this.isDataelement;
    }

    public boolean isMandatory() {
        return !this.isOptional();
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isScalar() {
        return !this.isStructure() && !this.isTable() && !this.isTabletype() && !this.isDataelement();
    }

    boolean isScalarFixedValuesListDefined() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).isFixedValuesListDefined();
    }

    boolean isScalarHelpvaluesSupported() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).isHelpvaluesSupported();
    }

    boolean isScalarMixedCaseSupported() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isBasedOnDictionaryReference()) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.bof.getStructure(this.tableName).getField(this.fieldName).isMixedCaseSupported();
    }

    public boolean isStructure() {
        return this.isStructure;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public DDObject getDDObject() {
        String fname = this.ddFieldName == null ? this.fieldName : this.ddFieldName;
        String currF = "";
        String currT = this.tableName;
        DDObject ddField = null;
        DDFactory df = this.parent.parent.parent.bof.getDDFactory();
        if (fname == null || fname.trim().equalsIgnoreCase("")) {
            return df.getDDObjectWithSubtree(this.tableName);
        }
        StringTokenizer sToken = new StringTokenizer(fname, "-");
        while (sToken.hasMoreTokens()) {
            currF = sToken.nextToken();
            ddField = df.getDDObjectWithSubtree(currT, currF);
            if (!sToken.hasMoreTokens()) continue;
            currT = ddField.getChild().getName();
        }
        return ddField;
    }

    private DDField getDDField() {
        DDObject ddField = this.getDDObject();
        if (ddField instanceof DDField) {
            return (DDField)ddField;
        }
        return null;
    }

    protected void setDdFieldName(String ddFieldName) {
        this.ddFieldName = ddFieldName;
    }
}

