/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.Documentation;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.RfmException;
import com.sap.mdi.RfmExceptions;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.RfmParameters;
import com.sap.mdi.Rfms;

public final class Rfm {
    Rfms parent;
    String name;
    String groupName;
    String application;
    String description;
    String devclass;
    String componentId;
    int released;
    RfmExceptions exceptions;
    RfmParameters params;
    boolean initialized = false;
    boolean descriptionInitialized = false;

    Rfm(String name, RfmParameters params, RfmExceptions exceptions) {
        this.name = name;
        this.params = params;
        this.params.parent = this;
        this.exceptions = exceptions;
        this.exceptions.parent = this;
        this.initialized = true;
    }

    Rfm(String name, String groupName, String application, String description) {
        this.name = name;
        this.groupName = groupName;
        this.application = application;
        this.description = description;
        this.descriptionInitialized = true;
    }

    Rfm(String name, String groupName, String application, String description, String devclass, String componentId) {
        this.name = name;
        this.groupName = groupName;
        this.application = application;
        this.description = description;
        this.devclass = devclass;
        this.componentId = componentId;
        this.descriptionInitialized = true;
    }

    Rfm(String name, String groupName, String application, String description, String devclass, String componentId, int released) {
        this.name = name;
        this.groupName = groupName;
        this.application = application;
        this.description = description;
        this.devclass = devclass;
        this.componentId = componentId;
        this.released = released;
        this.descriptionInitialized = true;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.groupName;
    }

    public String getApplication() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.application;
    }

    public String getDescription() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.description;
    }

    public String getDevclass() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.devclass;
    }

    public String getComponentId() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.componentId;
    }

    public int getReleased() throws MetaDataAccessException {
        if (!this.descriptionInitialized) {
            this.initDescription();
        }
        return this.released;
    }

    public Documentation getDocumentation() throws MetaDataAccessException {
        String id = "FU";
        String language = this.parent.bof.getUserLogonLanguage();
        Documentation documentation = this.parent.bof.getDocumentation(id, this.name, language);
        return documentation;
    }

    public Documentation getDocumentation(String language) throws MetaDataAccessException {
        String id = "FU";
        Documentation documentation = this.parent.bof.getDocumentation(id, this.name, language);
        return documentation;
    }

    public RfmException getRfmException(String name) throws MetaDataAccessException {
        return this.getRfmExceptions().getRfmException(name);
    }

    public RfmExceptions getRfmExceptions() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.exceptions;
    }

    public RfmParameter getRfmParameter(String name) throws MetaDataAccessException {
        return this.getRfmParameters().getRfmParameter(name);
    }

    public RfmParameters getRfmParameters() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.params;
    }

    void init() throws MetaDataAccessException {
        this.parent.bof.initRfm(this);
    }

    void initDescription() throws MetaDataAccessException {
        this.parent.bof.getRfms().search(this.name, "").getRfm(0);
    }

    public boolean isConsistent() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        try {
            int count = this.getRfmParameters().getSize();
            int i = 0;
            while (i < count) {
                RfmParameter rfmParameter = this.getRfmParameters().getRfmParameter(i);
                if (!rfmParameter.isConsistent()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

