/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.BOException;
import com.sap.mdi.BOKeyField;
import com.sap.mdi.BOKeyFields;
import com.sap.mdi.BOMethod;
import com.sap.mdi.BOMethods;
import com.sap.mdi.BOParameter;
import com.sap.mdi.BOTypes;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.Rfm;
import com.sap.mdi.RfmException;
import com.sap.mdi.RfmParameter;
import java.util.Vector;

public final class BOType {
    int index;
    BOTypes parent;
    String objectName;
    String objectType;
    String description;
    String delegationObjectType;
    String parentObjectType;
    boolean isReleased;
    String releaseCreated;
    String releaseChanged;
    String releaseReleased;
    String releaseObsolete;
    String[] documentation;
    BOMethods boMethods;
    BOKeyFields boKeyFields;
    boolean initialized = false;
    boolean documentationInitialized = false;

    BOType(String objectName, String objectType, String description) {
        this.objectName = objectName;
        this.objectType = objectType;
        this.description = description;
        this.boKeyFields = new BOKeyFields();
        this.boKeyFields.parent = this;
        this.boMethods = new BOMethods();
        this.boMethods.parent = this;
    }

    public BOKeyFields getBOKeyFields() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.boKeyFields;
    }

    public BOMethods getBOMethods() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.boMethods;
    }

    public String getDelegationObjectType() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.delegationObjectType;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDocumentation() throws MetaDataAccessException {
        if (!this.documentationInitialized) {
            this.initDocumentation();
        }
        return this.documentation;
    }

    private String[] getInconsistencies() throws MetaDataAccessException {
        Vector<String> results = new Vector<String>();
        if (!this.initialized) {
            this.init();
        }
        if (this.isReleased() && this.getReleaseReleased().equals("")) {
            results.addElement(this.getObjectName() + " is released, but it is not known since which specific release.");
        }
        int i = 0;
        while (i < this.getBOMethods().getSize()) {
            BOMethod boMethod = this.getBOMethods().getBOMethod(i);
            Rfm rfm = boMethod.getRfm();
            if (rfm == null) {
                results.addElement(this.getObjectName() + "." + boMethod.getName() + ": Underlying RFM '" + boMethod.getRfmName() + "' cannot be found.");
            } else {
                BOKeyField boKeyField;
                int j;
                RfmParameter rfmParameter;
                RfmException rfmException;
                BOException boException;
                int j2 = 0;
                while (j2 < boMethod.getBOExceptions().getSize()) {
                    boException = boMethod.getBOExceptions().getBOException(j2);
                    rfmException = boException.getRfmException();
                    if (rfmException == null) {
                        results.addElement(this.getObjectName() + "." + boMethod.getName() + " BAPI Exception '" + boException.getName() + "' cannot be found in underlying RFM.");
                    }
                    ++j2;
                }
                int j3 = 0;
                while (j3 < rfm.getRfmExceptions().getSize()) {
                    rfmException = rfm.getRfmExceptions().getRfmException(j3);
                    boException = boMethod.getBOExceptions().getBOException(rfmException.getName());
                    if (boException == null) {
                        results.addElement(this.getObjectName() + "." + boMethod.getName() + " RFM Exception '" + rfmException.getName() + "' cannot be found in BAPI.");
                    }
                    ++j3;
                }
                int j4 = 0;
                while (j4 < boMethod.getBOParameters().getSize()) {
                    BOParameter boParameter = boMethod.getBOParameters().getBOParameter(j4);
                    rfmParameter = boParameter.getRfmParameter();
                    if (rfmParameter == null) {
                        results.addElement(this.getObjectName() + "." + boMethod.getName() + " BAPI Parameter '" + boParameter.getName() + "' cannot be found in underlying RFM.");
                    }
                    ++j4;
                }
                if (boMethod.isInstanceMethod()) {
                    j = 0;
                    while (j < this.getBOKeyFields().getSize()) {
                        boKeyField = this.getBOKeyFields().getBOKeyField(j);
                        rfmParameter = rfm.getRfmParameter(boKeyField.getName());
                        if (rfmParameter == null) {
                            results.addElement(this.getObjectName() + "." + boMethod.getName() + " is defined as an instance method, yet key field parameter '" + boKeyField.getName() + "' cannot be found in underlying RFM.");
                        } else if (!rfmParameter.isScalar() || !rfmParameter.isImport()) {
                            results.addElement(this.getObjectName() + "." + boMethod.getName() + " is defined as a instance method, yet key field parameter '" + boKeyField.getName() + "' is not defined as a scalar import parameter in underlying RFM.");
                        }
                        ++j;
                    }
                }
                if (boMethod.isFactoryMethod()) {
                    j = 0;
                    while (j < this.getBOKeyFields().getSize()) {
                        boKeyField = this.getBOKeyFields().getBOKeyField(j);
                        rfmParameter = rfm.getRfmParameter(boKeyField.getName());
                        if (rfmParameter == null) {
                            results.addElement(this.getObjectName() + "." + boMethod.getName() + " is defined as a factory method, yet key field parameter '" + boKeyField.getName() + "' cannot be found in underlying RFM.");
                        } else if (!rfmParameter.isScalar() || !rfmParameter.isExport()) {
                            results.addElement(this.getObjectName() + "." + boMethod.getName() + " is defined as a factory method, yet key field parameter '" + boKeyField.getName() + "' is not defined as a scalar export parameter in underlying RFM.");
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        Object[] array = new String[results.size()];
        results.copyInto(array);
        return array;
    }

    public int getIndex() {
        return this.index;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getParentObjectType() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.parentObjectType;
    }

    public String getReleaseChanged() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.releaseChanged;
    }

    public String getReleaseCreated() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.releaseCreated;
    }

    public String getReleaseObsolete() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.releaseObsolete;
    }

    public String getReleaseReleased() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.releaseReleased;
    }

    void init() throws MetaDataAccessException {
        this.parent.bof.initBOType(this);
    }

    void initDocumentation() throws MetaDataAccessException {
        this.parent.bof.initDocumentationBOType(this);
    }

    public boolean isConsistent() {
        try {
            BOMethods boMethods = this.getBOMethods();
            int count = boMethods.getSize();
            int i = 0;
            while (i < count) {
                BOMethod boMethod = boMethods.getBOMethod(i);
                if (!boMethod.isConsistent()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isDelegated() throws MetaDataAccessException {
        return !this.getDelegationObjectType().equals("");
    }

    public boolean isObsolete() throws MetaDataAccessException {
        return !this.getReleaseObsolete().equals("");
    }

    public boolean isReleased() throws MetaDataAccessException {
        if (!this.initialized) {
            this.init();
        }
        return this.isReleased;
    }
}

