/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mdi;

import com.sap.mdi.BOKeyFields;
import com.sap.mdi.BOParameters;
import com.sap.mdi.Field;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.MetaDataAccessNotBasedOnDictionaryException;
import com.sap.mdi.MetaDataAccessNotImportException;
import com.sap.mdi.MetaDataAccessNotScalarException;
import com.sap.mdi.RfmParameter;
import com.sap.mdi.Structure;
import com.sap.mdi.ddtypes.DDFactory;
import com.sap.mdi.ddtypes.DDObject;
import java.util.StringTokenizer;

public final class BOParameter {
    int index;
    BOParameters parent;
    String name;
    String description;
    String rfmParameterName;
    boolean isOptional;
    boolean isStructure;
    boolean isTable;
    boolean isImport;
    boolean isExport;
    String referenceTable;
    String referenceField;
    String dataTypeABAP;
    int internalLength;
    int outputLength;
    int decimals;
    boolean supportsMixedCase;
    String conversionExit;
    String releaseCreated;
    String[] documentation;

    BOParameter(String name, String description, boolean isOptional, String parameterType, String rfmParameterName, String referenceTable, int internalLength, boolean isTable, String releaseCreated) {
        this.name = name;
        this.description = description;
        this.isStructure = !isTable;
        this.isTable = isTable;
        if (parameterType.equals("I")) {
            this.isImport = true;
            this.isExport = false;
            this.isOptional = isOptional;
        } else if (parameterType.equals("E")) {
            this.isImport = false;
            this.isExport = true;
            this.isOptional = true;
        } else if (parameterType.equals("A")) {
            this.isImport = true;
            this.isExport = true;
            this.isOptional = isOptional;
        }
        this.rfmParameterName = rfmParameterName;
        this.referenceTable = referenceTable;
        this.internalLength = internalLength;
        this.releaseCreated = releaseCreated;
    }

    BOParameter(String name, String description, boolean isOptional, String parameterType, String rfmParameterName, String referenceTable, String referenceField, String dataTypeABAP, int internalLength, int outputLength, int decimals, boolean supportsMixedCase, String conversionExit, String releaseCreated) {
        this.name = name;
        this.description = description;
        this.isStructure = false;
        this.isTable = false;
        if (parameterType.equals("I")) {
            this.isImport = true;
            this.isExport = false;
            this.isOptional = isOptional;
        } else if (parameterType.equals("E")) {
            this.isImport = false;
            this.isExport = true;
            this.isOptional = true;
        } else if (parameterType.equals("A")) {
            this.isImport = true;
            this.isExport = true;
            this.isOptional = isOptional;
        }
        this.rfmParameterName = rfmParameterName;
        this.referenceTable = referenceTable;
        this.referenceField = referenceField;
        this.dataTypeABAP = dataTypeABAP;
        this.internalLength = internalLength;
        this.outputLength = outputLength;
        this.decimals = decimals;
        this.supportsMixedCase = supportsMixedCase;
        this.conversionExit = conversionExit;
        this.releaseCreated = releaseCreated;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDocumentation() throws MetaDataAccessException {
        if (!this.parent.parent.parent.parent.documentationInitialized) {
            this.parent.parent.parent.parent.initDocumentation();
        }
        return this.documentation;
    }

    public int getIndex() {
        return this.index;
    }

    public int getInternalLength() {
        return this.internalLength;
    }

    public String getName() {
        return this.name;
    }

    public String getReleaseCreated() {
        return this.releaseCreated;
    }

    public RfmParameter getRfmParameter() throws MetaDataAccessException {
        return this.parent.parent.parent.parent.parent.bof.getRfm(this.parent.parent.getRfmName()).getRfmParameter(this.getRfmParameterName());
    }

    public String getRfmParameterName() {
        return this.rfmParameterName;
    }

    String getScalarCheckTable() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).getCheckTable();
    }

    String getScalarConversionExit() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.conversionExit;
    }

    String getScalarDataTypeABAP() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.dataTypeABAP;
    }

    String getScalarDataTypeDD() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).getDataTypeDD();
    }

    int getScalarDecimals() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.decimals;
    }

    public String getScalarDefaultDefinition() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (!this.isImport()) {
            throw new MetaDataAccessNotImportException();
        }
        return this.parent.parent.parent.parent.parent.bof.getRfm(this.parent.parent.getRfmName()).getRfmParameter(this.getRfmParameterName()).getScalarDefaultDefinition();
    }

    Field getScalarField() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField);
    }

    public String getScalarFieldName() {
        return this.referenceField;
    }

    int getScalarLength() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).getLength();
    }

    int getScalarOutputLength() throws MetaDataAccessNotScalarException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        return this.outputLength;
    }

    Structure getStructure() throws MetaDataAccessException {
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable);
    }

    public String getStructureName() {
        return this.referenceTable;
    }

    boolean isConsistent() {
        try {
            RfmParameter rfmParameter = this.getRfmParameter();
            if (this.isScalar()) {
                Field f = this.getScalarField();
                if (f == null) {
                    return false;
                }
                BOKeyFields boKeyFields = this.parent.parent.parent.parent.getBOKeyFields();
                if (!((this.isExport() == rfmParameter.isExport() && this.isImport() == rfmParameter.isImport() || boKeyFields.exists(this.getName())) && this.getScalarFieldName().equals(rfmParameter.getScalarFieldName()) && this.getStructureName().equals(rfmParameter.getStructureName()) && this.isScalar() == rfmParameter.isScalar() && this.isStructure() == rfmParameter.isStructure() && this.isTable() == rfmParameter.isTable())) {
                    return false;
                }
            } else if (this.isStructure()) {
                Structure s = this.getStructure();
                if (s == null) {
                    return false;
                }
                if (this.isExport() != rfmParameter.isExport() || this.isImport() != rfmParameter.isImport() || !this.getStructureName().equals(rfmParameter.getStructureName()) || this.isScalar() != rfmParameter.isScalar() || this.isStructure() != rfmParameter.isStructure() || this.isTable() != rfmParameter.isTable()) {
                    return false;
                }
            } else if (this.isTable()) {
                Structure s = this.getStructure();
                if (s == null) {
                    return false;
                }
                if (!this.getStructureName().equals(rfmParameter.getStructureName()) || this.isScalar() != rfmParameter.isScalar() || this.isStructure() != rfmParameter.isStructure() || this.isTable() != rfmParameter.isTable()) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isExport() {
        return this.isExport;
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean isMandatory() {
        return !this.isOptional();
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isScalar() {
        return !this.isStructure() && !this.isTable();
    }

    boolean isScalarFixedValuesListDefined() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).isFixedValuesListDefined();
    }

    boolean isScalarHelpvaluesSupported() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).isHelpvaluesSupported();
    }

    boolean isScalarMixedCaseSupported() throws MetaDataAccessException {
        if (!this.isScalar()) {
            throw new MetaDataAccessNotScalarException();
        }
        if (this.referenceField.equals("") || this.referenceTable.equals("")) {
            throw new MetaDataAccessNotBasedOnDictionaryException();
        }
        return this.parent.parent.parent.parent.parent.bof.getStructure(this.referenceTable).getField(this.referenceField).isMixedCaseSupported();
    }

    public boolean isStructure() {
        return this.isStructure;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public DDObject getDDObject() {
        String currF = "";
        String currT = this.referenceTable;
        DDObject ddField = null;
        DDFactory df = this.parent.parent.parent.parent.parent.bof.getDDFactory();
        if (this.referenceField == null || this.referenceField.trim().equalsIgnoreCase("")) {
            return df.getDDObjectWithSubtree(this.referenceTable);
        }
        StringTokenizer sToken = new StringTokenizer(this.referenceField, "-");
        while (sToken.hasMoreTokens()) {
            currF = sToken.nextToken();
            ddField = df.getDDObjectWithSubtree(currT, currF);
            if (!sToken.hasMoreTokens()) continue;
            currT = ddField.getChild().getName();
        }
        return ddField;
    }

    private DDObject getDDField() {
        DDFactory df = this.parent.parent.parent.parent.parent.bof.getDDFactory();
        if (this.referenceField == null || this.referenceField.trim().equalsIgnoreCase("")) {
            return null;
        }
        return df.getDDObjectWithSubtree(this.referenceTable, this.referenceField);
    }
}

