/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.view;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementContextBinding;
import com.sap.ide.metamodel.webdynpro.component.view.UIElementEventBinding;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Group;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Label;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.TabStrip;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Table;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Tray;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.metamodel.webdynpro.enum.BindableEnum;
import com.sap.ide.metamodel.webdynpro.enum.BindingTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.uielib.AbstractViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.TranslatableViewElementPropertyDef;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.UIElementLibrary;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementDefinition;
import com.sap.ide.metamodel.webdynpro.framework.uielib.ViewElementPropertyDef;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.checklayer.controller.ViewControllerChecker;
import com.sap.ide.webdynpro.checklayer.view.GroupChecker;
import com.sap.ide.webdynpro.checklayer.view.LabelChecker;
import com.sap.ide.webdynpro.checklayer.view.TabStripChecker;
import com.sap.ide.webdynpro.checklayer.view.TableChecker;
import com.sap.ide.webdynpro.checklayer.view.TrayChecker;
import com.sap.ide.webdynpro.checklayer.view.UIElementContainerChecker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class ViewElementChecker {
    public static void check(ViewElement element, Vector elements, Vector libraries, CheckResult checkResult) {
        if (element == null) {
            return;
        }
        ViewElementDefinition definition = null;
        definition = ViewElementChecker.getDefinition(element);
        if (!libraries.contains(definition.getParent())) {
            checkResult.addEntry((DevelopmentObject)element, 0, definition.getParent().getName(), "UIElementLibrary is not used in this Component", "Add UIElementLibrary");
        }
        if (element != null) {
            ViewElementChecker.checkProperties(element, definition, checkResult);
        }
        if (element != null) {
            ViewElementChecker.checkEvents(element, checkResult);
        }
        if (element != null) {
            ViewElementChecker.checkBindings(element, checkResult);
        }
        if (element instanceof UIElementContainer) {
            UIElementContainerChecker.check((UIElementContainer)element, elements, libraries, checkResult);
        }
        if (element instanceof Tray) {
            TrayChecker.check((Tray)element, checkResult);
        }
        if (element instanceof Group) {
            GroupChecker.check((Group)element, checkResult);
        }
        if (element instanceof TabStrip) {
            TabStripChecker.check((TabStrip)element, elements, libraries, checkResult);
        }
        if (element instanceof Table) {
            TableChecker.check((Table)element, elements, libraries, checkResult);
        }
        if (element instanceof Label) {
            LabelChecker.check((Label)element, elements, checkResult);
        }
    }

    private static ViewElementDefinition getDefinition(ViewElement element) {
        if (element.getDefinition() != null) {
            return element.getDefinition();
        }
        String elementClass = element.getMetaClass().getName();
        elementClass = elementClass.substring(elementClass.lastIndexOf(".") + 1, elementClass.length());
        Root root = element.getRoot();
        UIElementDefinition definition = null;
        if (root instanceof WebDynproRoot) {
            WebDynproRoot webDynproRoot = (WebDynproRoot)root;
            try {
                UIElementLibrary[] libraries = webDynproRoot.getUIElementLibraries();
                int j = 0;
                while (j < libraries.length) {
                    definition = libraries[j].getViewElementDefinition(elementClass);
                    if (definition == null && (definition = libraries[j].getUIElementDefinition(elementClass)) == null && (definition = libraries[j].getUIElementContainerDefinition(elementClass)) == null && (definition = libraries[j].getLayoutDefinition(elementClass)) == null) {
                        ++j;
                        continue;
                    }
                    break;
                }
            }
            catch (LoadException e) {
                // empty catch block
            }
        }
        return definition;
    }

    private static void checkProperties(ViewElement element, ViewElementDefinition definition, CheckResult checkResult) {
        while (definition != null) {
            AbstractViewElementPropertyDef[] properties = definition.getProperties();
            int i = 0;
            while (i < properties.length) {
                AbstractViewElementPropertyDef property = properties[i];
                if (property.getBindable() == BindableEnum.BINDABLE_MANDATORY) {
                    ViewElementChecker.checkBindableMandatoryProperty(element, property.getName(), checkResult);
                } else if (property.getBindable() == BindableEnum.NOT_BINDABLE) {
                    ViewElementChecker.checkNonBindableProperty(element, property.getName(), checkResult);
                } else if (property.getRequired()) {
                    ViewElementChecker.checkRequiredProperty(element, property.getName(), checkResult);
                }
                ViewElementChecker.checkCssSizeProperty(element, property, checkResult);
                ++i;
            }
            definition = (UIElementDefinition)definition.getSuperClass();
        }
    }

    private static void checkRequiredProperty(ViewElement element, String propertyName, CheckResult checkResult) {
        block6: {
            String methodName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            Class[] lClass = new Class[]{};
            try {
                Method method = element.getClass().getMethod(methodName, lClass);
                if (method == null) break block6;
                Object[] args = new Object[]{};
                try {
                    Object ret = method.invoke((Object)element, args);
                    if (ret instanceof String && ret.equals("")) {
                        checkResult.addEntry((DevelopmentObject)element, 1, propertyName, "Property is required", "");
                    }
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    private static void checkBindableMandatoryProperty(ViewElement element, String propertyName, CheckResult checkResult) {
        UIElementContextBinding binding = element.getContextBinding(propertyName);
        if (binding != null) {
            if (binding.getBoundContextElement() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, propertyName, "ContextElement not valid", "");
            }
            if (binding.getUIElementProperty() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, propertyName, "UIElementProperty not valid", "");
            }
        } else {
            checkResult.addEntry((DevelopmentObject)element, 1, propertyName, "Property not bound", "");
        }
    }

    private static void checkNonBindableProperty(ViewElement element, String propertyName, CheckResult checkResult) {
        UIElementContextBinding binding = element.getContextBinding(propertyName);
        if (binding != null) {
            checkResult.addEntry((DevelopmentObject)element, 0, propertyName, "Non bindable property bound", "");
        }
    }

    private static void checkCssSizeProperty(ViewElement element, AbstractViewElementPropertyDef property, CheckResult checkResult) {
        block7: {
            if (property == null) {
                return;
            }
            String methodName = "get" + Character.toUpperCase(property.getName().charAt(0)) + property.getName().substring(1);
            Class[] lClass = new Class[]{};
            try {
                Method method = element.getClass().getMethod(methodName, lClass);
                if (method == null) break block7;
                Object[] args = new Object[]{};
                try {
                    Object ret = method.invoke((Object)element, args);
                    if (ret instanceof String && !ViewElementChecker.isValid((String)ret, property)) {
                        checkResult.addEntry((DevelopmentObject)element, 1, property.getName(), "Property does not contain cssSize-like value", "");
                    }
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    private static void checkEvents(ViewElement element, CheckResult checkResult) {
        UIElementEventBinding[] actions = element.getEventBindings();
        int i = 0;
        while (i < actions.length) {
            Vector errors;
            if (actions[i].getBoundAction() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, actions[i].getName(), "Action not valid", "Create Action");
            }
            if (actions[i].getUIElementEvent() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, actions[i].getName(), "UIElementEvent not valid", "");
            }
            if ((errors = ViewControllerChecker.areUIElementAndActionParameterCompatible(actions[i].getUIElementEvent(), actions[i].getBoundAction())) != null) {
                checkResult.addEntry((DevelopmentObject)element, 1, actions[i].getName(), "Action and event are not compatible", "");
                Iterator it = ((AbstractList)errors).iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (!(object instanceof Parameter)) continue;
                    Parameter parameter = (Parameter)object;
                    checkResult.addEntry((DevelopmentObject)actions[i], 1, "", "Parameter " + parameter.getName() + "(" + parameter.getType().getName() + ") cannot be supplied", "");
                }
            }
            ++i;
        }
    }

    private static void checkBindings(ViewElement element, CheckResult checkResult) {
        UIElementContextBinding[] bindings = element.getContextBindings();
        int i = 0;
        while (i < bindings.length) {
            if (bindings[i].getBoundContextElement() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, bindings[i].getName(), "ContextElement not valid", "");
            }
            if (bindings[i].getUIElementProperty() == null) {
                checkResult.addEntry((DevelopmentObject)element, 0, bindings[i].getName(), "UIElementEvent not valid", "");
            }
            if (bindings[i].getBoundContextElement() != null && bindings[i].getUIElementProperty() != null && !ViewElementChecker.areUIElementPropertyAndContextElementCompatible(bindings[i].getBoundContextElement(), bindings[i].getUIElementProperty())) {
                checkResult.addEntry((DevelopmentObject)element, 0, bindings[i].getName(), "Context element and property are not compatible", "");
            }
            ++i;
        }
    }

    public static boolean areUIElementPropertyAndContextElementCompatible(ContextElement element, AbstractViewElementPropertyDef property) {
        if (element == null) {
            return false;
        }
        if (element instanceof ContextRecursionNode) {
            return false;
        }
        if (element instanceof ContextAttribute) {
            DevelopmentObject type;
            if (property instanceof ViewElementPropertyDef && (((ViewElementPropertyDef)property).getBindingType() == BindingTypeEnum.MULTIPLENODE || ((ViewElementPropertyDef)property).getBindingType() == BindingTypeEnum.MULTIPLENODERANGE)) {
                return false;
            }
            if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getType() == null) {
                return true;
            }
            if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getBindingType() == BindingTypeEnum.MULTIPLENODEATTRIBUTE) {
                DevelopmentObject parent = element.getParent();
                boolean found = false;
                while (parent instanceof ContextNode) {
                    if (((ContextNode)parent).getCardinality() == CardinalityEnum._0_N || ((ContextNode)parent).getCardinality() == CardinalityEnum._1_N) {
                        found = true;
                        break;
                    }
                    parent = parent.getParent();
                }
                if (!found) {
                    return false;
                }
            }
            if ((type = CheckLayerHelper.getType((ContextAttribute)element)) instanceof DtSimpleType) {
                DtSimpleType lSimpleType = (DtSimpleType)type;
                if (lSimpleType.getBuiltInType() != null && lSimpleType.getBuiltInType().equals("binary")) {
                    return property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getConvertible();
                }
                if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getType() != null && ((ViewElementPropertyDef)property).getType() instanceof DtSimpleType) {
                    String lPropertyType = ((DtSimpleType)((ViewElementPropertyDef)property).getType()).getBuiltInType();
                    if (ViewElementChecker.isEnumTyped(property)) {
                        return ((ViewElementPropertyDef)property).getType() == lSimpleType;
                    }
                    if (lSimpleType.getBuiltInType() != null && lPropertyType != null && lPropertyType.equals(lSimpleType.getBuiltInType().toLowerCase())) {
                        return true;
                    }
                }
            } else {
                return false;
            }
            if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getConvertible()) {
                return true;
            }
            if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getType() != null && type != ((ViewElementPropertyDef)property).getType()) {
                return false;
            }
        } else {
            if (property instanceof ViewElementPropertyDef && (((ViewElementPropertyDef)property).getBindingType() == BindingTypeEnum.ATTRIBUTE || ((ViewElementPropertyDef)property).getBindingType() == BindingTypeEnum.MULTIPLENODEATTRIBUTE)) {
                return false;
            }
            if (property instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)property).getType() == null) {
                return true;
            }
            if (property instanceof TranslatableViewElementPropertyDef) {
                return false;
            }
            if (element instanceof ContextNode && (((ContextNode)element).getCardinality() == CardinalityEnum._0_1 || ((ContextNode)element).getCardinality() == CardinalityEnum._1_1)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEnumTyped(AbstractViewElementPropertyDef definition) {
        return definition != null && definition instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)definition).getType() != null && ((ViewElementPropertyDef)definition).getType() instanceof DtSimpleType && ((DtSimpleType)((ViewElementPropertyDef)definition).getType()).getSchemaType() != null && ((DtSimpleType)((ViewElementPropertyDef)definition).getType()).getSchemaType().getEnumerationValueCount() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(String value, AbstractViewElementPropertyDef propertydefinition) {
        DtSimpleType simpleType;
        if (propertydefinition != null && propertydefinition instanceof ViewElementPropertyDef && ((ViewElementPropertyDef)propertydefinition).getIsCSSSize()) {
            if (value.length() <= 1) return value.equals("");
            String unit = "";
            String real = "";
            int unitpos = -1;
            if (value.lastIndexOf("%") > -1) {
                unitpos = value.lastIndexOf("%");
            } else {
                if (value.lastIndexOf("em") > -1) {
                    unitpos = value.lastIndexOf("em");
                }
                if (value.lastIndexOf("ex") > -1) {
                    unitpos = value.lastIndexOf("ex");
                }
                if (value.lastIndexOf("px") > -1) {
                    unitpos = value.lastIndexOf("px");
                }
                if (value.lastIndexOf("%") > -1) {
                    unitpos = value.lastIndexOf("%");
                }
            }
            if (unitpos <= -1) return false;
            unit = value.substring(unitpos, value.length());
            real = value.substring(0, unitpos);
            try {
                int val = Integer.parseInt(real);
                if (val < 0) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (unit.equals("em") || unit.equals("ex") || unit.equals("px") || unit.equals("%")) return true;
            return false;
        }
        if (propertydefinition == null || !(propertydefinition instanceof ViewElementPropertyDef) || !(((ViewElementPropertyDef)propertydefinition).getType() instanceof DtSimpleType) || !(simpleType = (DtSimpleType)((ViewElementPropertyDef)propertydefinition).getType()).getBuiltInType().equals("integer")) return true;
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

