/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.view;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.FlowData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.FlowLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.GridLayout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.Layout;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.LayoutData;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElement;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.UIElementContainer;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.ViewElement;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.view.ViewElementChecker;
import java.util.Vector;

class UIElementContainerChecker {
    UIElementContainerChecker() {
    }

    static void check(UIElementContainer container, Vector inputelements, Vector libraries, CheckResult checkResult) {
        if (container.getLayout() == null) {
            checkResult.addEntry((DevelopmentObject)container, 0, "Layout", "LayoutManager not set", "Set LayoutManager");
        }
        UIElement[] elements = container.getChildren();
        Layout layout = container.getLayout();
        if (elements.length == 0) {
            checkResult.addEntry((DevelopmentObject)container, 2, "Children", "Container does not contain children", "");
        }
        int i = 0;
        while (i < elements.length) {
            ViewElementChecker.check((ViewElement)elements[i], inputelements, libraries, checkResult);
            LayoutData data = elements[i].getLayoutData();
            if (data != null && layout != null) {
                if (data instanceof GridData && !(layout instanceof GridLayout)) {
                    checkResult.addEntry((DevelopmentObject)elements[i], 0, "LayoutData", "GridData differs from LayoutManager", "Change LayoutData");
                }
                if (data instanceof FlowData && !(layout instanceof FlowLayout)) {
                    checkResult.addEntry((DevelopmentObject)elements[i], 0, "LayoutData", "FlowData differs from LayoutManager", "Change LayoutData");
                }
            }
            ++i;
        }
    }
}

