/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.out;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.CheckResultEntry;
import java.util.ArrayList;

public class ConsoleManager {
    public static final String MESSAGE_CATEGORY_TEXT_ERROR = "[Error]   ";
    public static final String MESSAGE_CATEGORY_TEXT_WARNING = "[Warning] ";
    public static final String MESSAGE_CATEGORY_TEXT_INFO = "[Info]    ";

    private ConsoleManager() {
    }

    public static void showCheckResults(CheckResult checkResult) {
        ArrayList lCheckResultEntries = checkResult.getEntries();
        int i = 0;
        while (i < lCheckResultEntries.size()) {
            System.out.println(ConsoleManager.getCheckResultAsString((CheckResultEntry)lCheckResultEntries.get(i)));
            ++i;
        }
    }

    public static String getCheckResultsAsString(CheckResult checkResult) {
        ArrayList lCheckResultEntries = checkResult.getEntries();
        String lMessageTexts = "";
        int i = 0;
        while (i < lCheckResultEntries.size()) {
            lMessageTexts = lMessageTexts + ConsoleManager.getCheckResultAsString((CheckResultEntry)lCheckResultEntries.get(i)) + "\n";
            ++i;
        }
        return lMessageTexts;
    }

    public static String getCheckResultAsString(CheckResultEntry checkResultEntry) {
        String lMessageCategory = "";
        String lMessageText = "";
        DevelopmentObject lDevObject = checkResultEntry.getDevelopmentObject();
        switch (checkResultEntry.getKind()) {
            case 0: {
                lMessageCategory = MESSAGE_CATEGORY_TEXT_ERROR;
                break;
            }
            case 1: {
                lMessageCategory = MESSAGE_CATEGORY_TEXT_WARNING;
                break;
            }
            case 2: {
                lMessageCategory = MESSAGE_CATEGORY_TEXT_INFO;
                break;
            }
            default: {
                lMessageCategory = MESSAGE_CATEGORY_TEXT_ERROR;
            }
        }
        lMessageText = lDevObject.getMDO().getQualifiedName() + " -->\n   ";
        if (checkResultEntry.getHideDevelopmentObjectProperties()) {
            lMessageText = checkResultEntry.getMessage();
        } else {
            String lMetaClassName = lDevObject.getMetaClass().getName();
            lMetaClassName = lMetaClassName.substring(lMetaClassName.lastIndexOf(46) + 1);
            lMessageText = checkResultEntry.getPropertyName() == null || checkResultEntry.getPropertyName().length() == 0 ? lMessageText + lMetaClassName + " " + lDevObject.getName() + ": " + checkResultEntry.getMessage() : lMessageText + lMetaClassName + " " + lDevObject.getName() + " [" + checkResultEntry.getPropertyName() + "]: " + checkResultEntry.getMessage();
        }
        if (checkResultEntry.getRepairHint() != null && checkResultEntry.getRepairHint().length() > 0) {
            lMessageText = lMessageText + " (Hint: " + checkResultEntry.getRepairHint() + ")";
        }
        lMessageText = lMessageCategory + lMessageText;
        return lMessageText;
    }
}

