/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.model;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.IWebDynproChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.tc.logging.Location;

public final class ModelClassChecker
implements IWebDynproChecker {
    private static final ModelClassChecker mInstance = new ModelClassChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$model$ModelClassChecker == null ? (class$com$sap$ide$webdynpro$checklayer$model$ModelClassChecker = ModelClassChecker.class$("com.sap.ide.webdynpro.checklayer.model.ModelClassChecker")) : class$com$sap$ide$webdynpro$checklayer$model$ModelClassChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$model$ModelClassChecker;

    public static ModelClassChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (developmentObject instanceof ModelClass) {
            ModelClass modelClass = (ModelClass)developmentObject;
            checkResult.addCheckedMDO((MainDevelopmentObject)modelClass);
            this.checkProperties(modelClass, fullCheck, checkResult);
            this.checkMethods(modelClass, fullCheck, checkResult);
        }
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private void checkProperties(ModelClass modelClass, boolean fullCheck, CheckResult checkResult) {
        if (modelClass.getPropertyCount() > 0) {
            Property[] properties = modelClass.getProperties();
            int i = 0;
            while (i < properties.length) {
                if (ModelClassHelper.getType((ModelClassProperty)properties[i]) == null) {
                    checkResult.addEntry((DevelopmentObject)properties[i], 0, "type", "Type missing", "The type might have been deleted from the dictionary");
                }
                ++i;
            }
        }
    }

    private void checkMethods(ModelClass modelClass, boolean fullCheck, CheckResult checkResult) {
        if (modelClass.getMethodCount() > 0) {
            Method[] methods = modelClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getParameterCount() > 0) {
                    Parameter[] parameters = methods[i].getParameters();
                    int j = 0;
                    while (j < parameters.length) {
                        if (!parameters[j].hasType()) {
                            checkResult.addEntry((DevelopmentObject)parameters[j], 0, "type", "Type missing of parameter in corresponding method <" + methods[i].getName() + ">", "");
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

