/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.model;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.IWebDynproChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.tc.logging.Location;

public final class ModelChecker
implements IWebDynproChecker {
    private static final ModelChecker mInstance = new ModelChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$model$ModelChecker == null ? (class$com$sap$ide$webdynpro$checklayer$model$ModelChecker = ModelChecker.class$("com.sap.ide.webdynpro.checklayer.model.ModelChecker")) : class$com$sap$ide$webdynpro$checklayer$model$ModelChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$model$ModelChecker;

    public static ModelChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (developmentObject instanceof Model) {
            Model model = (Model)developmentObject;
            checkResult.addCheckedMDO((MainDevelopmentObject)model);
            ModelType modelType = model.getModelType();
            if (modelType != null) {
                if (modelType.getStructureBindingEnabled() && !model.hasLogicalDictionary()) {
                    checkResult.addEntry((DevelopmentObject)model, 0, "logicalDictionary", "Inconsistent metadata, logical dictionary missing", "");
                }
            } else {
                checkResult.addEntry((DevelopmentObject)model, 0, "modelType", "Inconsistent metadata, model type missing", "");
            }
            if (model.getModelRelationCount() > 0) {
                ModelRelation[] modelRelations = model.getModelRelations();
                int i = 0;
                while (i < modelRelations.length) {
                    ModelChecker.checkModelRelation(modelRelations[i], fullCheck, checkResult);
                    ++i;
                }
            }
        }
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private static void checkModelRelation(ModelRelation modelRelation, boolean fullCheck, CheckResult checkResult) {
        if (modelRelation != null) {
            if (modelRelation.getModelRelationRoleCount() == 2) {
                ModelRelationRole[] roles = modelRelation.getModelRelationRoles();
                int i = 0;
                while (i < roles.length) {
                    if (!roles[i].hasModelClass()) {
                        checkResult.addEntry((DevelopmentObject)roles[i], 0, "modelClass", "Inconsistent metadata, model class missing", "");
                    }
                    ++i;
                }
                if (!roles[0].getNavigable() && !roles[1].getNavigable()) {
                    checkResult.addEntry((DevelopmentObject)modelRelation, 1, "modelRelationRoles", "At least one model relation role has to be navigable", "");
                }
            } else {
                checkResult.addEntry((DevelopmentObject)modelRelation, 0, "modelRelationRoles", "Inconsistent metadata, model relation role(s) missing", "");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

