/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.controller.Action;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.view.View;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.InboundPlugTypeEnum;
import com.sap.ide.metamodel.webdynpro.enum.OutboundPlugTypeEnum;
import com.sap.ide.metamodel.webdynpro.framework.FrameworkEvent;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.IWebDynproChecker;
import com.sap.ide.webdynpro.checklayer.controller.ControllerChecker;
import com.sap.ide.webdynpro.checklayer.view.ViewChecker;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class ViewControllerChecker
implements IWebDynproChecker {
    private static ViewControllerChecker mInstance = new ViewControllerChecker();

    public static ViewControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        ViewControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
    }

    public static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        if (!controller.getType().equals(ControllerTypeEnum.VIEW)) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller is no view controller", "");
        } else {
            AbstractView view = controller.getView();
            if (view == null) {
                checkResult.addEntry((DevelopmentObject)controller, 0, "", "View controller has no view", "");
            } else {
                ViewControllerChecker.checkActions(controller, checkResult);
                ViewControllerChecker.checkInboundPlugs(view, controller, checkResult);
                ViewControllerChecker.checkOutboundPlugs(view, checkResult);
                if (view instanceof View) {
                    ViewChecker.getInstance().check((DevelopmentObject)((View)view), fullCheck, checkResult);
                }
            }
        }
    }

    public static Vector areUIElementAndActionParameterCompatible(FrameworkEvent event, Action action) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)event, (ParameterizedFeature)action);
    }

    public static Vector arePlugsParameterCompatible(OutboundPlug outPlug, InboundPlug inPlug) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)outPlug, (ParameterizedFeature)inPlug);
    }

    public static Vector doesPlugImplementPlug(OutboundPlug plugDefinition, OutboundPlug plugImplementation) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)plugImplementation, (ParameterizedFeature)plugDefinition);
    }

    public static Vector doesPlugImplementPlug(InboundPlug plugDefinition, InboundPlug plugImplementation) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)plugImplementation, (ParameterizedFeature)plugDefinition);
    }

    public static Vector areActionAndEventHandlerParameterCompatible(Action action, EventHandler eventHandler) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)action, (ParameterizedFeature)eventHandler);
    }

    public static Vector areInboundPlugAndEventHandlerParameterCompatible(InboundPlug inboundPlug, EventHandler eventHandler) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)inboundPlug, (ParameterizedFeature)eventHandler);
    }

    private static void checkActions(Controller controller, CheckResult checkResult) {
        Action[] actions = controller.getActions();
        int i = 0;
        while (i < actions.length) {
            if (!actions[i].hasEventHandler()) {
                checkResult.addEntry((DevelopmentObject)controller, 0, actions[i].getName(), "Action has no event handler.", "Set an event handler for the action.");
            } else {
                Vector errors = ViewControllerChecker.areActionAndEventHandlerParameterCompatible(actions[i], (EventHandler)actions[i].getEventHandler());
                if (errors != null) {
                    Iterator it = ((AbstractList)errors).iterator();
                    while (it.hasNext()) {
                        Object object = it.next();
                        if (!(object instanceof Parameter)) continue;
                        Parameter parameter = (Parameter)object;
                        checkResult.addEntry((DevelopmentObject)controller, 0, actions[i].getName(), "Event handler parameter '" + parameter.getName() + "' cannot be supplied.", "Add a parameter with the same name and type to the action.");
                    }
                }
            }
            ControllerChecker.checkParameters((ParameterizedFeature)actions[i], checkResult);
            ++i;
        }
    }

    static void checkInboundPlugs(AbstractView view, Controller controller, CheckResult checkResult) {
        InboundPlug[] inboundPlugs = view.getInboundPlugs();
        int i = 0;
        while (i < inboundPlugs.length) {
            Vector errors;
            if (inboundPlugs[i].hasEventHandler() && (errors = ViewControllerChecker.areInboundPlugAndEventHandlerParameterCompatible(inboundPlugs[i], (EventHandler)inboundPlugs[i].getEventHandler())) != null) {
                Iterator it = ((AbstractList)errors).iterator();
                while (it.hasNext()) {
                    Object object = it.next();
                    if (!(object instanceof Parameter)) continue;
                    Parameter parameter = (Parameter)object;
                    checkResult.addEntry((DevelopmentObject)controller, 0, inboundPlugs[i].getName(), "Event handler parameter '" + parameter.getName() + "' cannot be supplied.", "Add a parameter with the same name and type to the inbound plug.");
                }
            }
            boolean isStartupPlug = inboundPlugs[i].getType().equals(InboundPlugTypeEnum.STARTUP);
            ControllerChecker.checkParameters((ParameterizedFeature)inboundPlugs[i], isStartupPlug, checkResult);
            if (view instanceof InterfaceView && view.getParent() instanceof ComponentInterfaceDefinition && inboundPlugs[i].getType().equals(InboundPlugTypeEnum.STARTUP)) {
                checkResult.addEntry((DevelopmentObject)controller, 1, inboundPlugs[i].getName(), "An inbound plug defined within a component interface definition should not have the type 'Startup'.", "Delete the plug and re-create it as a standard plug.");
            }
            ++i;
        }
    }

    static void checkOutboundPlugs(AbstractView view, CheckResult checkResult) {
        OutboundPlug[] outboundPlugs = view.getOutboundPlugs();
        int i = 0;
        while (i < outboundPlugs.length) {
            boolean isExitPlug = outboundPlugs[i].getType().equals(OutboundPlugTypeEnum.EXIT);
            ControllerChecker.checkParameters((ParameterizedFeature)outboundPlugs[i], isExitPlug, checkResult);
            if (view instanceof InterfaceView && view.getParent() instanceof ComponentInterfaceDefinition && outboundPlugs[i].getType().equals(OutboundPlugTypeEnum.EXIT)) {
                checkResult.addEntry((DevelopmentObject)view.getViewController(), 1, outboundPlugs[i].getName(), "An outbound plug defined within a component interface definition should not have the type 'Exit'.", "Delete the plug and re-create it as a standard plug.");
            }
            ++i;
        }
    }
}

