/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.navigation.InboundPlug;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.componentif.InterfaceViewChecker;
import com.sap.ide.webdynpro.checklayer.controller.ViewControllerChecker;
import java.util.Enumeration;
import java.util.Vector;

public class InterfaceViewControllerChecker {
    static InterfaceViewControllerChecker mInstance = new InterfaceViewControllerChecker();

    public static InterfaceViewControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        InterfaceViewControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
    }

    public static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        if (!controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller is no interface view controller", "");
        } else {
            InterfaceView view = null;
            if (!(controller.getView() instanceof InterfaceView)) {
                checkResult.addEntry((DevelopmentObject)controller, 0, "", "View is no interface view", "");
            } else {
                view = (InterfaceView)controller.getView();
                ViewControllerChecker.checkInboundPlugs((AbstractView)view, controller, checkResult);
                ViewControllerChecker.checkOutboundPlugs((AbstractView)view, checkResult);
                InterfaceViewChecker.getInstance().check((DevelopmentObject)view, fullCheck, checkResult);
                DevelopmentObject parent = controller.getParent();
                if (parent instanceof ComponentInterfaceImplementation) {
                    ComponentInterfaceImplementation cii = (ComponentInterfaceImplementation)parent;
                    ComponentInterfaceDefinition[] definitions = cii.getImplementedInterfaces();
                    int i = 0;
                    while (i < definitions.length) {
                        InterfaceView[] definitionViews = definitions[i].getInterfaceViews();
                        int j = 0;
                        while (j < definitionViews.length) {
                            Controller definition;
                            if (view.getName().equals(definitionViews[j].getName()) && (definition = definitionViews[j].getViewController()) != null) {
                                InterfaceViewControllerChecker.doesInterfaceViewControllerImplementInterfaceViewController(definitionViews[j], definition, view, controller, checkResult);
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private static void doesInterfaceViewControllerImplementInterfaceViewController(InterfaceView viewDefinition, Controller controllerDefinition, InterfaceView viewImplementation, Controller controllerImplementation, CheckResult checkResult) {
        InboundPlug[] inboundPlugs = viewDefinition.getInboundPlugs();
        int k = 0;
        while (k < inboundPlugs.length) {
            if (!viewImplementation.hasInboundPlug(inboundPlugs[k].getName())) {
                checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, "", "Implementation error: Missing inbound plug '" + inboundPlugs[k].getName() + "'", "");
            } else {
                InboundPlug implementingInboundPlug = viewImplementation.getInboundPlug(inboundPlugs[k].getName());
                Vector vector = ViewControllerChecker.doesPlugImplementPlug(inboundPlugs[k], implementingInboundPlug);
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, inboundPlugs[k].getName(), "Implementation error: Missing parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
                if (!inboundPlugs[k].getType().equals(implementingInboundPlug.getType())) {
                    checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, "", "Implementation error: Implementing inbound plug '" + implementingInboundPlug.getName() + "' has the wrong type.", "");
                }
            }
            ++k;
        }
        OutboundPlug[] outboundPlugs = viewDefinition.getOutboundPlugs();
        int k2 = 0;
        while (k2 < outboundPlugs.length) {
            if (!viewImplementation.hasOutboundPlug(outboundPlugs[k2].getName())) {
                checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, "", "Implementation error: Missing outbound plug '" + outboundPlugs[k2].getName() + "'", "");
            } else {
                OutboundPlug implementingOutboundPlug = viewImplementation.getOutboundPlug(outboundPlugs[k2].getName());
                Vector vector = ViewControllerChecker.doesPlugImplementPlug(outboundPlugs[k2], implementingOutboundPlug);
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, outboundPlugs[k2].getName(), "Implementation error: Missing parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
                if (!outboundPlugs[k2].getType().equals(implementingOutboundPlug.getType())) {
                    checkResult.addEntry((DevelopmentObject)controllerImplementation, 0, "", "Implementation error: Implementing outbound plug '" + implementingOutboundPlug.getName() + "' has the wrong type.", "");
                }
            }
            ++k2;
        }
    }
}

