/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.base.ErrorHandler;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.SupplyFunction;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.context.ContextChecker;
import com.sap.ide.webdynpro.checklayer.controller.ControllerChecker;
import java.util.Enumeration;
import java.util.Vector;

public class InterfaceControllerChecker {
    static InterfaceControllerChecker mInstance = new InterfaceControllerChecker();

    public static InterfaceControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        InterfaceControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
    }

    public static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        if (!controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller is no component interface controller", "");
        } else {
            DevelopmentObject parent = controller.getParent();
            if (parent instanceof ComponentInterfaceImplementation) {
                ComponentInterfaceImplementation cii = (ComponentInterfaceImplementation)parent;
                ComponentInterfaceDefinition[] definitions = cii.getImplementedInterfaces();
                int i = 0;
                while (i < definitions.length) {
                    Controller definition = definitions[i].getInterfaceController();
                    if (definition != null) {
                        InterfaceControllerChecker.doesInterfaceControllerImplementInterfaceController(definition, controller, checkResult);
                    }
                    ++i;
                }
            }
        }
    }

    private static void doesInterfaceControllerImplementInterfaceController(Controller definition, Controller implementation, CheckResult checkResult) {
        ContextChecker.checkContextImplementation(definition.getContext(), implementation.getContext(), checkResult);
        EventHandler[] eventHandlers = definition.getEventHandlers();
        int i = 0;
        while (i < eventHandlers.length) {
            if (!implementation.hasEventHandler(eventHandlers[i].getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Missing event handler '" + eventHandlers[i].getName() + "'", "");
            } else {
                Vector vector;
                if (!ControllerChecker.areReturnValuesEqual((Procedure)implementation.getEventHandler(eventHandlers[i].getName()), (Procedure)eventHandlers[i])) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Event handler '" + eventHandlers[i].getName() + "' has wrong return type", "");
                }
                if ((vector = ControllerChecker.doesProcedureImplementProcedure((Procedure)eventHandlers[i], (Procedure)implementation.getEventHandler(eventHandlers[i].getName()))) != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)implementation, 0, eventHandlers[i].getName(), "Implementation error: Missing event handler parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
            }
            ++i;
        }
        ErrorHandler[] errorHandlers = definition.getErrorHandlers();
        int i2 = 0;
        while (i2 < errorHandlers.length) {
            if (!implementation.hasErrorHandler(errorHandlers[i2].getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Missing error handler '" + errorHandlers[i2].getName() + "'", "");
            } else {
                Vector vector;
                if (!ControllerChecker.areReturnValuesEqual((Procedure)implementation.getErrorHandler(errorHandlers[i2].getName()), (Procedure)errorHandlers[i2])) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Error handler '" + errorHandlers[i2].getName() + "' has wrong return type", "");
                }
                if ((vector = ControllerChecker.doesProcedureImplementProcedure((Procedure)errorHandlers[i2], (Procedure)implementation.getErrorHandler(errorHandlers[i2].getName()))) != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)implementation, 0, errorHandlers[i2].getName(), "Implementation error: Missing error handler parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
            }
            ++i2;
        }
        Method[] methods = definition.getMethods();
        int i3 = 0;
        while (i3 < methods.length) {
            if (!implementation.hasMethod(methods[i3].getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Missing method '" + methods[i3].getName() + "'", "");
            } else {
                Vector vector;
                if (!ControllerChecker.areReturnValuesEqual((Procedure)implementation.getMethod(methods[i3].getName()), (Procedure)methods[i3])) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Method '" + methods[i3].getName() + "' has wrong return type", "");
                }
                if ((vector = ControllerChecker.doesProcedureImplementProcedure((Procedure)methods[i3], (Procedure)implementation.getMethod(methods[i3].getName()))) != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)implementation, 0, methods[i3].getName(), "Implementation error: Missing method parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
            }
            ++i3;
        }
        SupplyFunction[] supplyFunctions = definition.getSupplyFunctions();
        int i4 = 0;
        while (i4 < supplyFunctions.length) {
            if (!implementation.hasSupplyFunction(supplyFunctions[i4].getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Missing supply function '" + supplyFunctions[i4].getName() + "'", "");
            } else {
                Vector vector;
                if (!ControllerChecker.areReturnValuesEqual((Procedure)implementation.getSupplyFunction(supplyFunctions[i4].getName()), (Procedure)supplyFunctions[i4])) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Supply function '" + supplyFunctions[i4].getName() + "' has wrong return type", "");
                }
                if ((vector = ControllerChecker.doesProcedureImplementProcedure((Procedure)supplyFunctions[i4], (Procedure)implementation.getSupplyFunction(supplyFunctions[i4].getName()))) != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)implementation, 0, supplyFunctions[i4].getName(), "Implementation error: Missing supply function parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
            }
            ++i4;
        }
        CustomEvent[] events = definition.getEvents();
        int i5 = 0;
        while (i5 < events.length) {
            if (!implementation.hasEvent(events[i5].getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "Implementation error: Missing event '" + events[i5].getName() + "'", "");
            } else {
                Vector vector = ControllerChecker.doesEventImplementEvent(events[i5], implementation.getEvent(events[i5].getName()));
                if (vector != null) {
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Parameter parameter = (Parameter)enumeration.nextElement();
                        checkResult.addEntry((DevelopmentObject)implementation, 0, events[i5].getName(), "Implementation error: Missing event parameter " + parameter.getName() + " type '" + parameter.getType().getName() + "'", "");
                    }
                }
            }
            ++i5;
        }
    }
}

