/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.CustomEvent;
import com.sap.ide.metamodel.webdynpro.base.EventHandler;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.ParameterizedFeature;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.SupplyFunction;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.metamodel.webdynpro.event.Event;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.MDOChecker;
import com.sap.ide.webdynpro.checklayer.context.ContextChecker;
import com.sap.ide.webdynpro.checklayer.controller.ComponentControllerChecker;
import com.sap.ide.webdynpro.checklayer.controller.ConfigurationControllerChecker;
import com.sap.ide.webdynpro.checklayer.controller.CustomControllerChecker;
import com.sap.ide.webdynpro.checklayer.controller.InterfaceControllerChecker;
import com.sap.ide.webdynpro.checklayer.controller.InterfaceViewControllerChecker;
import com.sap.ide.webdynpro.checklayer.controller.ViewControllerChecker;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.tc.logging.Location;
import java.util.Enumeration;
import java.util.Vector;

public class ControllerChecker
extends MDOChecker {
    private static ControllerChecker mInstance = new ControllerChecker();
    private static final String PACKAGE_BUILT_IN_TYPES = "com.sap.dictionary";
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$controller$ControllerChecker == null ? (class$com$sap$ide$webdynpro$checklayer$controller$ControllerChecker = ControllerChecker.class$("com.sap.ide.webdynpro.checklayer.controller.ControllerChecker")) : class$com$sap$ide$webdynpro$checklayer$controller$ControllerChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$controller$ControllerChecker;

    public static ControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        super.check(developmentObject, fullCheck, checkResult);
        ControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
        Utils.traceTime(sLocation, developmentObject, startingTime);
    }

    private static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        checkResult.addCheckedMDO((MainDevelopmentObject)controller);
        ControllerChecker.checkContext(controller, fullCheck, checkResult);
        Controller[] visitedControllers = new Controller[]{controller};
        ControllerUsage[] usages = controller.getOutgoingControllerUsages();
        ControllerChecker.checkUsedControllerCycles(visitedControllers, usages, fullCheck, checkResult);
        ControllerChecker.checkControllerUsages(controller, checkResult);
        ControllerChecker.checkEvents(controller, checkResult);
        ControllerChecker.checkEventHandlers(controller, checkResult);
        ControllerChecker.checkMethods(controller, checkResult);
        ControllerChecker.checkSupplyFunctions(controller, checkResult);
        if (controller.getType().equals(ControllerTypeEnum.COMPONENT)) {
            ComponentControllerChecker.check(controller, fullCheck, checkResult);
        } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            ConfigurationControllerChecker.check(controller, fullCheck, checkResult);
        } else if (controller.getType().equals(ControllerTypeEnum.COMPONENT_INTERFACE)) {
            InterfaceControllerChecker.check(controller, fullCheck, checkResult);
        } else if (controller.getType().equals(ControllerTypeEnum.CUSTOM)) {
            CustomControllerChecker.check(controller, fullCheck, checkResult);
        } else if (controller.getType().equals(ControllerTypeEnum.INTERFACE_VIEW)) {
            InterfaceViewControllerChecker.check(controller, fullCheck, checkResult);
        } else if (controller.getType().equals(ControllerTypeEnum.VIEW)) {
            ViewControllerChecker.check(controller, fullCheck, checkResult);
        }
    }

    public static Vector areEventAndEventHandlerParameterCompatible(Event event, EventHandler eventHandler) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)event, (ParameterizedFeature)eventHandler);
    }

    static Vector areParameterizedFeaturesParameterCompatible(ParameterizedFeature outFeature, ParameterizedFeature inFeature) {
        if (outFeature == null | inFeature == null) {
            return new Vector();
        }
        Parameter[] outPars = outFeature.getParameters();
        Parameter[] inPars = inFeature.getParameters();
        Vector<Parameter> notSupplied = new Vector<Parameter>();
        int in = 0;
        while (in < inPars.length) {
            boolean matched = false;
            int out = 0;
            while (out < outPars.length) {
                if (inPars[in] != null && inPars[in].getName() != null && outPars[out] != null && inPars[in].getName().equals(outPars[out].getName()) && ControllerChecker.areParameterTypesEqual(inPars[in], outPars[out])) {
                    matched = true;
                    break;
                }
                ++out;
            }
            if (!matched) {
                notSupplied.add(inPars[in]);
            }
            ++in;
        }
        if (notSupplied.size() > 0) {
            return notSupplied;
        }
        return null;
    }

    private static void checkContext(Controller controller, boolean fullCheck, CheckResult checkResult) {
        ContextValueNode context = controller.getContext();
        if (context == null) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Context is missing", "");
        } else {
            if (!context.getSingleton()) {
                checkResult.addEntry((DevelopmentObject)context, 0, "", "Context root node must be singleton", "");
            }
            if (!context.getSelection().equals(CardinalityEnum._1_1)) {
                checkResult.addEntry((DevelopmentObject)context, 0, "", "Context root node must have selection 1_1", "");
            }
            if (!context.getCardinality().equals(CardinalityEnum._1_1)) {
                checkResult.addEntry((DevelopmentObject)context, 0, "", "Context root node must have cardinality 1_1", "");
            }
            ContextChecker.check(context, controller.getOutgoingControllerUsages(), fullCheck, checkResult);
        }
    }

    private static void checkUsedControllerCycles(Controller[] visitedControllers, ControllerUsage[] usages, boolean fullCheck, CheckResult checkResult) {
        int i = 0;
        while (i < visitedControllers.length) {
            if (visitedControllers[i] != null) {
                int j = 0;
                while (j < usages.length) {
                    if (visitedControllers[i].equals(usages[j].getUsedController())) {
                        checkResult.addEntry((DevelopmentObject)visitedControllers[i], 1, "", "Cycle in required controller definitions: " + visitedControllers[i].getParent().getName(), "");
                        return;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < usages.length) {
            if (usages[i2].getUsedController() != null) {
                Controller[] newVisitedControllers = new Controller[visitedControllers.length + 1];
                int j = 0;
                while (j < visitedControllers.length) {
                    newVisitedControllers[j] = visitedControllers[j];
                    ++j;
                }
                newVisitedControllers[visitedControllers.length] = usages[i2].getUsedController();
                ControllerUsage[] newUsages = usages[i2].getUsedController().getOutgoingControllerUsages();
                ControllerChecker.checkUsedControllerCycles(newVisitedControllers, newUsages, fullCheck, checkResult);
            }
            ++i2;
        }
    }

    private static void checkControllerUsages(Controller controller, CheckResult checkResult) {
        ControllerUsage[] usages = controller.getOutgoingControllerUsages();
        int i = 0;
        while (i < usages.length) {
            if (usages[i] != null && !usages[i].hasComponentUsage() && !usages[i].hasUsedController()) {
                checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller has invalid controller usage. Please delete it", "");
            }
            ++i;
        }
    }

    private static void checkEvents(Controller controller, CheckResult checkResult) {
        CustomEvent[] events = controller.getEvents();
        int i = 0;
        while (i < events.length) {
            if (events[i] != null) {
                ControllerChecker.checkParameters((ParameterizedFeature)events[i], checkResult);
            }
            ++i;
        }
    }

    private static void checkEventHandlers(Controller controller, CheckResult checkResult) {
        EventHandler[] eventHandlers = controller.getEventHandlers();
        int i = 0;
        while (i < eventHandlers.length) {
            Vector vector;
            DevelopmentObject returnType = eventHandlers[i].getReturnType();
            if (returnType != null && !returnType.getName().equals("com.sap.tc.webdynpro.progmodel.api.IWDAction")) {
                checkResult.addEntry((DevelopmentObject)controller, 1, eventHandlers[i].getName(), "Event handler must have return type 'void' or 'IWDAction'", "");
            }
            ControllerChecker.checkParameters((ParameterizedFeature)eventHandlers[i], checkResult);
            if (eventHandlers[i].hasSubscribedEvent() && (vector = ControllerChecker.areEventAndEventHandlerParameterCompatible(eventHandlers[i].getSubscribedEvent(), eventHandlers[i])) != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Parameter parameter = (Parameter)enumeration.nextElement();
                    checkResult.addEntry((DevelopmentObject)controller, 0, eventHandlers[i].getName(), "Event handler parameter '" + parameter.getName() + "' cannot be supplied.", "Add a parameter with the same name and type to the subscribed event.");
                }
            }
            ++i;
        }
    }

    private static void checkSupplyFunctions(Controller controller, CheckResult checkResult) {
        SupplyFunction[] supplyFunctions = controller.getSupplyFunctions();
        int i = 0;
        while (i < supplyFunctions.length) {
            if (supplyFunctions[i].getReturnType() != null) {
                checkResult.addEntry((DevelopmentObject)controller, 1, supplyFunctions[i].getName(), "Supply function must have return type 'void'", "");
            }
            Parameter parameter = supplyFunctions[i].getParameter("node");
            ControllerChecker.checkParameters((ParameterizedFeature)supplyFunctions[i], checkResult);
            ++i;
        }
    }

    private static void checkMethods(Controller controller, CheckResult checkResult) {
        Method[] methods = controller.getMethods();
        int i = 0;
        while (i < methods.length) {
            ControllerChecker.checkParameters((ParameterizedFeature)methods[i], checkResult);
            ++i;
        }
    }

    static void checkParameters(ParameterizedFeature object, CheckResult checkResult) {
        ControllerChecker.checkParameters(object, false, checkResult);
    }

    static void checkParameters(ParameterizedFeature object, boolean onlyBuildInTypesAllowed, CheckResult checkResult) {
        Parameter[] parameters = object.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i].getType() == null) {
                checkResult.addEntry(object.getParent(), 0, object.getName(), "Parameter '" + parameters[i].getName() + "' has no type", "");
            }
            if (onlyBuildInTypesAllowed) {
                boolean isBuildInType;
                boolean bl = isBuildInType = parameters[i].getType() instanceof DtSimpleType && PACKAGE_BUILT_IN_TYPES.equals(((DtSimpleType)parameters[i].getType()).getPackage());
                if (!isBuildInType) {
                    checkResult.addEntry(object.getParent(), 0, object.getName(), "Parameter type of '" + parameters[i].getName() + "' must be a build-in type.", "");
                }
            }
            ++i;
        }
    }

    public static Vector doesProcedureImplementProcedure(Procedure procedureDefinition, Procedure procedureImplementation) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)procedureImplementation, (ParameterizedFeature)procedureDefinition);
    }

    public static Vector doesEventImplementEvent(CustomEvent eventDefinition, CustomEvent eventImplementation) {
        return ControllerChecker.areParameterizedFeaturesParameterCompatible((ParameterizedFeature)eventImplementation, (ParameterizedFeature)eventDefinition);
    }

    public static boolean areReturnValuesEqual(Procedure one, Procedure two) {
        if (one == null || two == null) {
            return false;
        }
        if (one.getNativeType() != null) {
            if (two.getNativeType() == null) {
                return false;
            }
            String typeNameOne = null;
            String typeNameTwo = null;
            if (one.getNativeType() instanceof JavaNativeType) {
                JavaNativeType javaNativeTypeOne = (JavaNativeType)one.getNativeType();
                String packageNameOne = javaNativeTypeOne.getJavaPackage();
                typeNameOne = packageNameOne != null && packageNameOne.length() > 0 ? packageNameOne + '.' + javaNativeTypeOne.getName() : javaNativeTypeOne.getName();
            }
            if (two.getNativeType() instanceof JavaNativeType) {
                JavaNativeType javaNativeTypeTwo = (JavaNativeType)two.getNativeType();
                String packageNameTwo = javaNativeTypeTwo.getJavaPackage();
                typeNameTwo = packageNameTwo != null && packageNameTwo.length() > 0 ? packageNameTwo + '.' + javaNativeTypeTwo.getName() : javaNativeTypeTwo.getName();
            }
            if (typeNameOne == null || typeNameTwo == null) {
                return false;
            }
            return typeNameOne.equals(typeNameTwo);
        }
        if (two.getNativeType() != null) {
            return false;
        }
        if (one.getReturnType() != null) {
            if (two.getReturnType() == null) {
                return false;
            }
            return one.getReturnType().getName().equals(two.getReturnType().getName());
        }
        return two.getReturnType() == null;
    }

    public static boolean areParameterTypesEqual(Parameter one, Parameter two) {
        if (one == null || two == null) {
            return false;
        }
        if (one.getNativeType() != null) {
            if (two.getNativeType() == null) {
                return false;
            }
            String typeNameOne = null;
            String typeNameTwo = null;
            if (one.getNativeType() instanceof JavaNativeType) {
                JavaNativeType javaNativeTypeOne = (JavaNativeType)one.getNativeType();
                String packageNameOne = javaNativeTypeOne.getJavaPackage();
                typeNameOne = packageNameOne != null && packageNameOne.length() > 0 ? packageNameOne + '.' + javaNativeTypeOne.getName() : javaNativeTypeOne.getName();
            }
            if (two.getNativeType() instanceof JavaNativeType) {
                JavaNativeType javaNativeTypeTwo = (JavaNativeType)two.getNativeType();
                String packageNameTwo = javaNativeTypeTwo.getJavaPackage();
                typeNameTwo = packageNameTwo != null && packageNameTwo.length() > 0 ? packageNameTwo + '.' + javaNativeTypeTwo.getName() : javaNativeTypeTwo.getName();
            }
            if (typeNameOne == null || typeNameTwo == null) {
                return false;
            }
            return typeNameOne.equals(typeNameTwo);
        }
        if (two.getNativeType() != null) {
            return false;
        }
        if (one.getType() != null) {
            if (two.getType() == null) {
                return false;
            }
            return one.getType().getName().equals(two.getType().getName());
        }
        return two.getType() == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

