/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.controller;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.context.ContextChecker;

public class ConfigurationControllerChecker {
    static ConfigurationControllerChecker mInstance = new ConfigurationControllerChecker();

    public static ConfigurationControllerChecker getInstance() {
        return mInstance;
    }

    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof Controller)) {
            return;
        }
        ConfigurationControllerChecker.check((Controller)developmentObject, fullCheck, checkResult);
    }

    public static void check(Controller controller, boolean fullCheck, CheckResult checkResult) {
        if (!controller.getType().equals(ControllerTypeEnum.COMPONENT_CONFIGURATION)) {
            checkResult.addEntry((DevelopmentObject)controller, 0, "", "Controller is no component configuration controller", "");
        } else {
            DevelopmentObject parent = controller.getParent();
            if (parent instanceof ComponentInterfaceImplementation) {
                ComponentInterfaceImplementation cii = (ComponentInterfaceImplementation)parent;
                ComponentInterfaceDefinition[] definitions = cii.getImplementedInterfaces();
                int i = 0;
                while (i < definitions.length) {
                    Controller definition = definitions[i].getConfigurationController();
                    if (definition != null) {
                        ConfigurationControllerChecker.doesConfigurationControllerImplementConfigurationController(definition, controller, checkResult);
                    }
                    ++i;
                }
            }
        }
    }

    private static void doesConfigurationControllerImplementConfigurationController(Controller definition, Controller implementation, CheckResult checkResult) {
        ContextChecker.checkContextImplementation(definition.getContext(), implementation.getContext(), checkResult);
    }
}

