/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer.context;

import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentControllerUsage;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.metamodel.webdynpro.component.controller.AbstractContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElement;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextElementMapping;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextModelNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextRecursionNode;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueAttribute;
import com.sap.ide.metamodel.webdynpro.component.controller.ContextValueNode;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.component.controller.ControllerUsage;
import com.sap.ide.metamodel.webdynpro.enum.ContextElementMappingTypeEnum;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.context.CheckLayerHelper;
import com.sap.ide.webdynpro.checklayer.internal.Utils;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.tc.logging.Location;

public final class ContextChecker {
    private static final ContextChecker mInstance = new ContextChecker();
    private static final Location sLocation = Location.getLocation((String)(class$com$sap$ide$webdynpro$checklayer$context$ContextChecker == null ? (class$com$sap$ide$webdynpro$checklayer$context$ContextChecker = ContextChecker.class$("com.sap.ide.webdynpro.checklayer.context.ContextChecker")) : class$com$sap$ide$webdynpro$checklayer$context$ContextChecker).getName());
    static /* synthetic */ Class class$com$sap$ide$webdynpro$checklayer$context$ContextChecker;

    public static ContextChecker getInstance() {
        return mInstance;
    }

    public static void check(ContextValueNode context, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        long startingTime = System.currentTimeMillis();
        if (context.getChildNodeCount() > 0) {
            ContextChecker.checkNodes(context.getChildNodes(), (ContextNode)context, controllerUsages, fullCheck, checkResult);
        }
        if (context.getAttributeCount() > 0) {
            ContextChecker.checkAttributes(context.getAttributes(), (ContextNode)context, controllerUsages, fullCheck, checkResult);
        }
        Utils.traceTime(sLocation, (DevelopmentObject)context, startingTime);
    }

    public static void checkReverseMappings(ComponentControllerUsage componentControllerUsage, boolean fullCheck, CheckResult checkResult) {
        int i;
        if (componentControllerUsage == null || componentControllerUsage.getUsedComponentController() == null) {
            return;
        }
        ContextValueNode context = componentControllerUsage.getUsedComponentController().getContext();
        ControllerUsage[] controllerUsages = componentControllerUsage.getOutgoingControllerUsages();
        if (context.getChildNodeCount() > 0) {
            AbstractContextNode[] childNodes = context.getChildNodes();
            i = 0;
            while (i < childNodes.length) {
                if (childNodes[i].getIsInputElement() && childNodes[i] instanceof ContextNode) {
                    ContextChecker.checkReverseNodeMapping((ContextNode)childNodes[i], controllerUsages, componentControllerUsage, fullCheck, checkResult);
                }
                ++i;
            }
        }
        if (context.getAttributeCount() > 0) {
            ContextAttribute[] attributes = context.getAttributes();
            i = 0;
            while (i < attributes.length) {
                if (attributes[i].getIsInputElement()) {
                    ContextChecker.checkReverseAttributeMapping(attributes[i], controllerUsages, componentControllerUsage, fullCheck, checkResult);
                }
                ++i;
            }
        }
        int i2 = 0;
        while (i2 < controllerUsages.length) {
            if (controllerUsages[i2].getContextMappingCount() > 0) {
                ContextElementMapping[] mappings = controllerUsages[i2].getContextMappings();
                int j = 0;
                while (j < mappings.length) {
                    if (!mappings[j].hasOwnElement()) {
                        checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mappings[j], 0, ContextChecker.getAbsolutePath(componentControllerUsage, null) + '.' + componentControllerUsage.getName() + ": Found inconsistent mapping definition. The source context element referenced by the mapping does no longer exist.", "Use the repair functionality for the component usage " + ContextChecker.getAbsolutePath(componentControllerUsage, null) + " to remove the mapping.");
                    } else if (!mappings[j].getOwnElement().getIsInputElement()) {
                        checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mappings[j], 0, ContextChecker.getAbsolutePath(componentControllerUsage, null) + '.' + componentControllerUsage.getName() + ": Found inconsistent mapping definition. The source context element referenced by the mapping is not an input element.", "Use the repair functionality for the component usage " + ContextChecker.getAbsolutePath(componentControllerUsage, null) + " to remove the mapping.");
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    public static void checkNodes(AbstractContextNode[] nodes, ContextNode parent, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        int i = 0;
        while (i < nodes.length) {
            if (nodes[i] instanceof ContextNode) {
                ContextChecker.checkNode((ContextNode)nodes[i], controllerUsages, fullCheck, checkResult);
            } else if (nodes[i] instanceof ContextRecursionNode) {
                ContextChecker.checkRecursionNode((ContextRecursionNode)nodes[i], fullCheck, checkResult);
            }
            ++i;
        }
    }

    public static void checkAttributes(ContextAttribute[] attributes, ContextNode parent, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        boolean isContextRoot = parent.getParent().isMDO();
        ContextNode originParent = (ContextNode)CheckLayerHelper.getOriginContextElement((ContextElement)parent, controllerUsages);
        DtStructure structure = CheckLayerHelper.getStructure(originParent, true);
        int i = 0;
        while (i < attributes.length) {
            ContextAttribute attribute = attributes[i];
            DtField structureElement = CheckLayerHelper.getStructureElement(attribute);
            ContextChecker.checkAttribute(attribute, controllerUsages, fullCheck, checkResult);
            if (!isContextRoot && parent.getIsInputElement() != attribute.getIsInputElement()) {
                checkResult.addEntry((DevelopmentObject)attribute, 1, "isInputElement", "As the context node is defined as input element, its attributes have to be defined as input elements, too.", "");
            }
            if (attribute instanceof ContextValueAttribute && structure != null) {
                if (structureElement == null) {
                    checkResult.addEntry((DevelopmentObject)attribute, 1, "structureElement", "All attributes of the corresponding context node have to be bound to fields of a dictionary structure", "");
                } else if (structureElement != null && structureElement.getStructure() != structure) {
                    checkResult.addEntry((DevelopmentObject)attribute, 0, "structureElement", "All attributes of the corresponding context node have to be bound to fields of the same dictionary structure", "Remove the corresponding attribute");
                }
            }
            ++i;
        }
    }

    public static void checkMappings(ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        int i = 0;
        while (i < controllerUsages.length) {
            if (controllerUsages[i].getContextMappingCount() > 0) {
                ContextElementMapping[] mappings = controllerUsages[i].getContextMappings();
                int j = 0;
                while (j < mappings.length) {
                    if (!mappings[j].hasOwnElement()) {
                        checkResult.addEntry((DevelopmentObject)mappings[j].getControllerUsage(), 1, "Mapping", "The controller usage contains inconsistent mapping definitions. The source context element referenced by the mapping does not exist", "");
                    }
                    if (!mappings[j].hasMappedElement()) {
                        checkResult.addEntry((DevelopmentObject)mappings[j].getControllerUsage(), 0, "Mapping", "The controller usage contains inconsistent mapping definitions. The mapped context element does not exist", "");
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void checkAttribute(ContextAttribute attribute, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        ContextAttribute mappedElement = null;
        if (!attribute.getIsInputElement()) {
            mappedElement = ContextChecker.checkAttributeMapping(attribute, controllerUsages, fullCheck, checkResult);
        }
        if (attribute instanceof ContextModelAttribute) {
            ContextChecker.checkModelAttribute((ContextModelAttribute)attribute, (ContextModelAttribute)mappedElement, controllerUsages, fullCheck, checkResult);
        } else if (attribute instanceof ContextValueAttribute) {
            ContextChecker.checkValueAttribute((ContextValueAttribute)attribute, (ContextValueAttribute)mappedElement, controllerUsages, fullCheck, checkResult);
        }
    }

    public static void checkValueAttribute(ContextValueAttribute attribute, ContextValueAttribute mappedAttribute, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        if (mappedAttribute == null && !CheckLayerHelper.hasType((ContextAttribute)attribute)) {
            checkResult.addEntry((DevelopmentObject)attribute, 0, "type", "Type missing", "The type property must be set to a simple type, a built in type or any java native type");
        }
        if (!attribute.getReadOnly() && mappedAttribute != null && mappedAttribute.getReadOnly()) {
            checkResult.addEntry((DevelopmentObject)attribute, 0, "readOnly", "The context attribute has to be read-only.", "As the mapped context attribute is read-only this attribute has to be read-only, too.");
        }
    }

    public static void checkModelAttribute(ContextModelAttribute attribute, ContextModelAttribute mappedAttribute, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        ContextModelAttribute origin = attribute;
        ModelClassProperty modelProperty = null;
        if (mappedAttribute != null) {
            origin = (ContextModelAttribute)CheckLayerHelper.getOriginContextElement((ContextElement)mappedAttribute, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)mappedAttribute));
        }
        modelProperty = CheckLayerHelper.getReferencedProperty(origin, true);
        if (!attribute.getReadOnly()) {
            if (modelProperty != null && modelProperty.getReadonly()) {
                checkResult.addEntry((DevelopmentObject)attribute, 0, "readOnly", "The context attribute has to be read-only.", "In case the corresponding model property is read-only, this attribute has to be read-only, too.");
            } else if (mappedAttribute != null && mappedAttribute.getReadOnly()) {
                checkResult.addEntry((DevelopmentObject)attribute, 0, "readOnly", "The context attribute has to be read-only.", "In case the mapped attribute is read-only, this attribute has to be read-only, too.");
            }
        }
        if (mappedAttribute == null) {
            if (!attribute.hasReferencedProperty()) {
                checkResult.addEntry((DevelopmentObject)attribute, 0, "referencedProperty", "The context model attribute has not been bound to a model property", "");
            } else {
                ModelClass parentNodeModelClass;
                ContextNode originParentNode = (ContextNode)CheckLayerHelper.getOriginContextElement((ContextElement)((ContextNode)attribute.getParent()), CheckLayerHelper.getOutgoingControllerUsages((ContextElement)((ContextNode)attribute.getParent())));
                if (originParentNode instanceof ContextModelNode && (parentNodeModelClass = ((ContextModelNode)originParentNode).getModelClass()) != null && !ModelClassHelper.hasModelClassProperty(parentNodeModelClass, (Property)modelProperty) && (attribute.getPath() == null || attribute.getPath().length() == 0)) {
                    checkResult.addEntry((DevelopmentObject)attribute, 0, "referencedProperty", "The model property is not a member of the model class the parent node is bound to.", "Specify a valid relation path using the 'path' property or correct the binding.");
                }
            }
            if (attribute.getParent().getParent().isMDO()) {
                checkResult.addEntry((DevelopmentObject)attribute, 0, "", "Context model attributes which are defined as top level attributes have to be mapped to attributes of other controllers.", "");
            }
        }
    }

    public static void checkNode(ContextNode node, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        ContextNode originNode = node;
        ContextNode mappedNode = null;
        if (!node.getIsInputElement()) {
            mappedNode = ContextChecker.checkNodeMapping(node, controllerUsages, fullCheck, checkResult);
        }
        if (mappedNode != null) {
            originNode = (ContextNode)CheckLayerHelper.getOriginContextElement((ContextElement)mappedNode, CheckLayerHelper.getOutgoingControllerUsages(mappedNode));
            ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)node, controllerUsages);
            ContextElementMappingTypeEnum mappingType = mapping.getMappingType();
            if (ContextElementMappingTypeEnum.COLLECTION_ONLY.equals(mappingType)) {
                if (!CheckLayerHelper.isValidSelectionCardinality(node.getSelection(), originNode.getCardinality())) {
                    checkResult.addEntry((DevelopmentObject)node, 1, "selection", "Either the selection cardinality of this node or the cardinality of the mapped origin node is not valid", "Choose a valid selection cardinality and ensure that the cardinality of the origin node is correct. You might also want to change the mapping type to 'collection and selection'.");
                }
            } else if (fullCheck && ContextElementMappingTypeEnum.NOT_APPLICABLE.equals(mappingType)) {
                checkResult.addEntry((DevelopmentObject)node, 0, "mappingType", "The mapping type is not valid", "The mapping type has to be set to value of 'collection and selection' or 'selection only'");
            }
            if (!CheckLayerHelper.isIndependentContextElement((ContextElement)node)) {
                ContextNode parent = node.getParentNode();
                ContextElementMapping parentMapping = CheckLayerHelper.getMapping((ContextElement)parent, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)parent));
                if (parentMapping == null) {
                    checkResult.addEntry((DevelopmentObject)parent, 0, "mapping", "Mapping of context node missing", "If a child node is mapped, the corresponding parent node has to be mapped, too.");
                } else if (CheckLayerHelper.getSingleton(originNode, true) && ContextElementMappingTypeEnum.COLLECTION_ONLY.equals(parentMapping.getMappingType())) {
                    checkResult.addEntry((DevelopmentObject)node, 0, "mappingType", "Invalid mapping type or invalid singleton value in origin element", "As the mapped node '" + node.getName() + "' is a singleton node, either the mapping type of the parent has to be set to 'collection_and_collection' or the node has to be defined as a non-singleton node.");
                }
            }
        } else if (!CheckLayerHelper.isValidSelectionCardinality(node.getSelection(), node.getCardinality())) {
            checkResult.addEntry((DevelopmentObject)node, 1, "selection", "The selection cardinality is not valid", "Change the value for the property selection or for the property cardinality.");
        }
        if (!CheckLayerHelper.isValidSingletonValue(originNode, true)) {
            checkResult.addEntry((DevelopmentObject)node, 1, "singleton", "The singleton value is not valid", "The value has to be set to true for top level nodes");
        }
        if (node instanceof ContextModelNode) {
            ContextChecker.checkModelNode((ContextModelNode)node, (ContextModelNode)mappedNode, controllerUsages, fullCheck, checkResult);
        } else if (node instanceof ContextValueNode) {
            ContextChecker.checkValueNode((ContextValueNode)node, (ContextValueNode)mappedNode, controllerUsages, fullCheck, checkResult);
        }
        if (node.getAttributeCount() > 0) {
            ContextChecker.checkAttributes(node.getAttributes(), node, controllerUsages, fullCheck, checkResult);
        }
        if (node.getChildNodeCount() > 0) {
            ContextChecker.checkNodes(node.getChildNodes(), node, controllerUsages, fullCheck, checkResult);
        }
    }

    private static void checkValueNode(ContextValueNode node, ContextValueNode mappedNode, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
    }

    private static void checkModelNode(ContextModelNode node, ContextModelNode mappedNode, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        if (mappedNode == null) {
            if (!node.hasModelClass()) {
                checkResult.addEntry((DevelopmentObject)node, 0, "modelClass", "The context model node has not been bound to a model class", "A Context model node has to be bound to a model class or mapped to a model node of another controller.");
            }
            if (node.hasSupplyingRelationRole()) {
                if (!CheckLayerHelper.isValidSupplyingRelationRole(node, node.getSupplyingRelationRole())) {
                    checkResult.addEntry((DevelopmentObject)node, 0, "supplyingRelationRole", "The supplying relation role is not valid", "");
                }
            } else if (!node.getIsInputElement() && !node.getParentNode().getParent().isMDO()) {
                ContextModelNode tmp = node;
                while (!tmp.hasSupplyFunction()) {
                    if (!(tmp.getParent() instanceof ContextNode)) break;
                    tmp = (ContextNode)tmp.getParent();
                }
                if (tmp.getParent().isMDO()) {
                    checkResult.addEntry((DevelopmentObject)node, 2, "supplyingRelationRole", "Supply function or supplying relation role missing", "A child node which is not mapped must have either a supplying relation role or a supply function or one of its parent nodes must have a supply function.");
                }
            }
        }
    }

    public static void checkRecursionNode(ContextRecursionNode node, boolean fullCheck, CheckResult checkResult) {
        String errorMsg;
        if (node.getRepeatedNode() == null) {
            checkResult.addEntry((DevelopmentObject)node, 0, "repeatedNode", "The repeated node reference has not been set", "The repeated node property must reference a child node of the recursion node");
        } else if (fullCheck && (errorMsg = CheckLayerHelper.isValidRepeatedNode((ContextElement)node.getRepeatedNode(), node)) != null) {
            checkResult.addEntry((DevelopmentObject)node, 0, "repeatedNode", errorMsg, "");
        }
    }

    public static ContextAttribute checkAttributeMapping(ContextAttribute attribute, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        return ContextChecker.checkAttributeMapping(attribute, controllerUsages, fullCheck, checkResult, false);
    }

    public static ContextNode checkNodeMapping(ContextNode node, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        return ContextChecker.checkNodeMapping(node, controllerUsages, fullCheck, checkResult, false);
    }

    public static ContextElement checkMapping(ContextElement element, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult) {
        return ContextChecker.checkMapping(element, controllerUsages, fullCheck, checkResult, false);
    }

    public static void checkReverseNodeMapping(ContextNode node, ControllerUsage[] controllerUsages, ComponentControllerUsage componentControllerUsage, boolean fullCheck, CheckResult checkResult) {
        ContextNode originNode = null;
        ContextNode mappedNode = ContextChecker.checkNodeMapping(node, controllerUsages, fullCheck, checkResult, true);
        if (mappedNode != null) {
            originNode = (ContextNode)CheckLayerHelper.getOriginContextElement((ContextElement)mappedNode, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)mappedNode));
            ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)node, controllerUsages);
            if (originNode.getCardinality() != node.getCardinality()) {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": Invalid cardinality value of the mapped context node.", "The cardinality values of both nodes have to be identical.");
            }
            if (ContextElementMappingTypeEnum.COLLECTION_AND_SELECTION.equals(mapping.getMappingType())) {
                if (CheckLayerHelper.getSelectionCardinality(mappedNode) != node.getSelection()) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": Invalid selection cardinality value of the mapped context node.", "As the mapping type is set to 'collection and selection' the selection cardinality values of both context nodes have to be identical.");
                }
                if (CheckLayerHelper.getInititializeLeadSelection(mappedNode) != node.getInitializeLeadSelection()) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": Invalid initializeLeadSelection value of the mapped context node.", "As the mapping type is set to 'collection and selection' the initializeLeadSelection values of both context nodes have to be identical.");
                }
            } else if (fullCheck && ContextElementMappingTypeEnum.NOT_APPLICABLE.equals(mapping.getMappingType())) {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": The mapping type is not valid.", "The mapping type has to be set to either 'collection and selection' or 'selection only'.");
            }
            if (!CheckLayerHelper.isIndependentContextElement((ContextElement)node)) {
                ContextNode parent = node.getParentNode();
                ContextElementMapping parentMapping = CheckLayerHelper.getMapping((ContextElement)parent, controllerUsages);
                if (parentMapping == null) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)parent) + "Mapping of context node missing", "If a child node is mapped its corresponding parent node has to be mapped, too.");
                } else if (CheckLayerHelper.getSingleton(originNode, true) && ContextElementMappingTypeEnum.COLLECTION_ONLY.equals(parentMapping.getMappingType())) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + "Invalid mapping type.", "As the node '" + node.getName() + "' is a singleton node, the mapping type of the parent has to be set to 'collection_and_collection'.");
                }
            }
            if (originNode.getSingleton() != node.getSingleton()) {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": Invalid singleton value of the mapped context node.", "The singleton values of both context nodes have to be identical.");
            }
            if (node instanceof ContextValueNode) {
                DtStructure nodeStructure = CheckLayerHelper.getStructure(node, true);
                if (nodeStructure != null) {
                    DtStructure originStructure = CheckLayerHelper.getStructure(originNode, true);
                    if (originStructure != null) {
                        if (!nodeStructure.equals(originStructure)) {
                            checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": The Dictionary structure of the mapped context node does not match.", "Both context nodes have to be bound to the same dictionary structure.");
                        }
                    } else {
                        checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": Dictionary structure binding of the mapped context node is missing.", "Both context nodes have to be bound to the same dictionary structure.");
                    }
                }
            } else if (node instanceof ContextModelNode) {
                ModelClass originModelClass = CheckLayerHelper.getModelClass((ContextModelNode)originNode, true);
                ModelClass modelClass = CheckLayerHelper.getModelClass((ContextModelNode)node, true);
                if (originModelClass != null && modelClass != null && !originModelClass.equals(modelClass)) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)node) + ": The model class of the mapped context node does not match.", "Both context nodes have to be bound to the same model class.");
                }
            }
        }
        if (node.getAttributeCount() > 0) {
            ContextAttribute[] attributes = node.getAttributes();
            int i = 0;
            while (i < attributes.length) {
                if (attributes[i].getIsInputElement()) {
                    ContextChecker.checkReverseAttributeMapping(attributes[i], controllerUsages, componentControllerUsage, fullCheck, checkResult);
                }
                ++i;
            }
        }
        if (node.getChildNodeCount() > 0) {
            AbstractContextNode[] childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.length) {
                if (childNodes[i].getIsInputElement() && childNodes[i] instanceof ContextNode) {
                    ContextChecker.checkReverseNodeMapping((ContextNode)childNodes[i], controllerUsages, componentControllerUsage, fullCheck, checkResult);
                }
                ++i;
            }
        }
    }

    public static void checkReverseAttributeMapping(ContextAttribute attribute, ControllerUsage[] controllerUsages, ComponentControllerUsage componentControllerUsage, boolean fullCheck, CheckResult checkResult) {
        ContextAttribute mappedAttribute = ContextChecker.checkAttributeMapping(attribute, controllerUsages, fullCheck, checkResult, true);
        if (mappedAttribute != null) {
            ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)attribute, controllerUsages);
            ContextAttribute origin = (ContextAttribute)CheckLayerHelper.getOriginContextElement((ContextElement)mappedAttribute, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)mappedAttribute));
            if (attribute instanceof ContextValueAttribute) {
                if (((ContextValueAttribute)attribute).hasStructureElement()) {
                    DtField field = CheckLayerHelper.getStructureElement(attribute, true);
                    DtField originField = CheckLayerHelper.getStructureElement(origin, true);
                    if (originField != null) {
                        if (!field.equals(originField)) {
                            checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)attribute) + ": The dictionary field of the mapped context attribute does not match.", "Both context attributes have to be bound to the same dictionary field.");
                        }
                    } else {
                        checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)attribute) + ": The dictionary structure binding of the mapped context attribute is missing.", "Both context attributes have to be bound to the same dictionary fields.");
                    }
                } else {
                    String message = CheckLayerHelper.isValidType(CheckLayerHelper.getType(attribute, true), CheckLayerHelper.getType(origin, true));
                    if (message != null) {
                        checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)attribute) + ": " + message, "Both context attributes have to be of the same type.");
                    }
                }
            } else if (attribute instanceof ContextModelAttribute) {
                ModelClassProperty property = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)attribute, true);
                ModelClassProperty originProperty = CheckLayerHelper.getReferencedProperty((ContextModelAttribute)origin, true);
                if (originProperty != null && property != null && !property.equals(originProperty)) {
                    checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, ContextChecker.getAbsolutePath(componentControllerUsage, (ContextElement)attribute) + ": The model class property of the mapped context attribute does not match.", "Both context attributes have to be bound to the same model class.");
                }
            }
        }
    }

    public static ContextAttribute checkAttributeMapping(ContextAttribute attribute, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult, boolean reverseMapping) {
        ContextElement parentNode;
        ContextAttribute mappedAttribute = (ContextAttribute)ContextChecker.checkMapping((ContextElement)attribute, controllerUsages, fullCheck, checkResult, reverseMapping);
        if (mappedAttribute != null && !(parentNode = (ContextElement)attribute.getParent()).getParent().isMDO() && !CheckLayerHelper.hasValidMapping(parentNode, controllerUsages)) {
            if (reverseMapping) {
                ContextElementMapping mapping = CheckLayerHelper.getMapping((ContextElement)attribute, controllerUsages);
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, CheckLayerHelper.getAbsolutePath((ContextElement)attribute) + ": Invalid mapping definition.", "Either the parent element has to be mapped or the mapping for the attribute has to be removed.");
            } else {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)attribute, 0, CheckLayerHelper.getRelativePath((ContextElement)attribute) + ": Invalid mapping definition.", "Either the parent element has to be mapped or the mapping for the attribute has to be removed.");
            }
        }
        return mappedAttribute;
    }

    public static ContextNode checkNodeMapping(ContextNode node, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult, boolean reverseMapping) {
        return (ContextNode)ContextChecker.checkMapping((ContextElement)node, controllerUsages, fullCheck, checkResult, reverseMapping);
    }

    public static ContextElement checkMapping(ContextElement element, ControllerUsage[] controllerUsages, boolean fullCheck, CheckResult checkResult, boolean reverseMapping) {
        ContextElementMapping mapping = CheckLayerHelper.getMapping(element, controllerUsages);
        ContextElement mappedElement = null;
        if (mapping != null) {
            if (mapping.hasMappedElement()) {
                mappedElement = mapping.getMappedElement();
            } else if (reverseMapping) {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)mapping, 0, CheckLayerHelper.getAbsolutePath(element) + ": The mapping definition is inconsistent, the mapped context element does not exist.", "");
            } else {
                checkResult.addEntryWithHiddenDOProperties((DevelopmentObject)element, 0, CheckLayerHelper.getRelativePath(element) + ": The mapping definition is inconsistent, the mapped context element does not exist.", "");
            }
        }
        return mappedElement;
    }

    public static void checkContextImplementation(ContextValueNode definition, ContextValueNode implementation, CheckResult checkResult) {
        ContextChecker.isEqualTo((AbstractContextNode)definition, (AbstractContextNode)implementation, checkResult);
    }

    public static boolean isEqualTo(AbstractContextNode definition, AbstractContextNode implementation, CheckResult checkResult) {
        AbstractContextNode origin = (AbstractContextNode)CheckLayerHelper.getOriginContextElement((ContextElement)implementation, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)implementation));
        boolean hasMapping = origin != implementation;
        boolean result = true;
        if (hasMapping || !definition.isEqualTo((DevelopmentObject)implementation)) {
            if (definition.getIsInputElement() != implementation.getIsInputElement()) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'isInputElement'");
                result = false;
            }
            if (!definition.getName().equals(implementation.getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property '");
                result = false;
            }
            if (definition instanceof ContextNode && implementation instanceof ContextNode) {
                ContextNode defNode = (ContextNode)definition;
                ContextNode implNode = (ContextNode)implementation;
                ContextNode originImplNode = (ContextNode)origin;
                if (defNode.getChildNodeCount() > 0) {
                    AbstractContextNode[] childNodes = defNode.getChildNodes();
                    int i = 0;
                    while (i < childNodes.length) {
                        AbstractContextNode defChildNode = childNodes[i];
                        AbstractContextNode implChildNode = implNode.getChildNode(childNodes[i].getName());
                        if (implChildNode != null) {
                            if (!defChildNode.isEqualTo((DevelopmentObject)implChildNode)) {
                                result &= ContextChecker.isEqualTo(defChildNode, implChildNode, checkResult);
                            }
                        } else {
                            checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node '" + defChildNode.getName() + "' is missing in the interface implementation.", "You can copy the corresponding node from the interface definition.");
                            result = false;
                        }
                        ++i;
                    }
                }
                if (defNode.getAttributeCount() > 0) {
                    ContextAttribute[] attributes = defNode.getAttributes();
                    int j = 0;
                    while (j < attributes.length) {
                        ContextAttribute defAttribute = attributes[j];
                        ContextAttribute implAttribute = implNode.getAttribute(defAttribute.getName());
                        if (implAttribute != null) {
                            result &= ContextChecker.isEqualTo(defAttribute, implAttribute, checkResult);
                        } else {
                            checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context attribute '" + defAttribute.getName() + "' is missing in the interface implementation.", "You can copy the corresponding attribute from the interface definition.");
                            result = false;
                        }
                        ++j;
                    }
                }
                if (defNode.getCardinality() != CheckLayerHelper.getCardinality(originImplNode, true)) {
                    checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'cardinality'");
                    result = false;
                }
                if (defNode.getInitializeLeadSelection() != implNode.getInitializeLeadSelection()) {
                    checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'initializeLeadSelection'");
                    result = false;
                }
                if (defNode.getSingleton() != CheckLayerHelper.getSingleton(originImplNode, true)) {
                    checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'singleton'");
                    result = false;
                }
                if (defNode.getSelection() != CheckLayerHelper.getSelectionCardinality(implNode)) {
                    checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'selection'");
                    result = false;
                }
                if (defNode instanceof ContextValueNode && implNode instanceof ContextValueNode) {
                    ContextValueNode defValueNode = (ContextValueNode)defNode;
                    ContextValueNode implOriginValueNode = (ContextValueNode)origin;
                    if (CheckLayerHelper.getStructure((ContextNode)defValueNode, true) != CheckLayerHelper.getStructure((ContextNode)implOriginValueNode, true)) {
                        checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "The referenced dictionary structure type is missing or different");
                        result = false;
                    }
                } else if (defNode instanceof ContextModelNode && implNode instanceof ContextModelNode) {
                    ContextModelNode defModelNode = (ContextModelNode)defNode;
                    ContextModelNode implOriginModelNode = (ContextModelNode)origin;
                    if (CheckLayerHelper.getModelClass(defModelNode, true) != CheckLayerHelper.getModelClass(implOriginModelNode, true)) {
                        checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'modelClass'");
                        result = false;
                    }
                    if (!implOriginModelNode.hasSupplyFunction() && defModelNode.getSupplyingRelationRole() != CheckLayerHelper.getSupplyingRelationRole(implOriginModelNode, true)) {
                        checkResult.addEntry((DevelopmentObject)implNode, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Property 'supplyingRelationRole'");
                        result = false;
                    }
                } else {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "");
                    result = false;
                }
            } else {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context node in the interface implementation differs from the corresponding node in the component interface definition.", "Make shure that all properties of both context nodes are identical.");
                result = false;
            }
        }
        return result;
    }

    public static boolean isEqualTo(ContextAttribute definition, ContextAttribute implementation, CheckResult checkResult) {
        ContextAttribute origin = (ContextAttribute)CheckLayerHelper.getOriginContextElement((ContextElement)implementation, CheckLayerHelper.getOutgoingControllerUsages((ContextElement)implementation));
        boolean hasMapping = origin != implementation;
        boolean result = true;
        if (hasMapping) {
            ContextValueAttribute implOriginAttr;
            ContextValueAttribute defAttr;
            if (definition.getIsInputElement() != implementation.getIsInputElement()) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property 'isInputElement'");
            }
            if (!definition.getName().equals(implementation.getName())) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property 'name'");
            }
            if (definition.getReadOnly() != implementation.getReadOnly()) {
                checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property 'readOnly'");
            }
            if (definition instanceof ContextValueAttribute && implementation instanceof ContextValueAttribute) {
                defAttr = (ContextValueAttribute)definition;
                implOriginAttr = (ContextValueAttribute)origin;
                if (CheckLayerHelper.getStructureElement((ContextAttribute)defAttr, true) != CheckLayerHelper.getStructureElement((ContextAttribute)implOriginAttr, true)) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property structureElement");
                }
                DevelopmentObject defType = CheckLayerHelper.getType((ContextAttribute)defAttr, true);
                DevelopmentObject implOriginType = CheckLayerHelper.getType((ContextAttribute)implOriginAttr, true);
                if (defType != null && implOriginType != null) {
                    if (defType instanceof JavaNativeType && implOriginType instanceof JavaNativeType) {
                        if (!CheckLayerHelper.getQualifiedName((JavaNativeType)defType).equals(CheckLayerHelper.getQualifiedName((JavaNativeType)implOriginType))) {
                            checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property type");
                        }
                    } else if (!defType.isEqualTo(implOriginType)) {
                        checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property type");
                    }
                }
            }
            if (definition instanceof ContextModelAttribute && implementation instanceof ContextModelAttribute) {
                defAttr = (ContextModelAttribute)definition;
                implOriginAttr = (ContextModelAttribute)origin;
                if (CheckLayerHelper.getReferencedProperty((ContextModelAttribute)defAttr, true) != CheckLayerHelper.getReferencedProperty((ContextModelAttribute)implOriginAttr, true)) {
                    checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Property referencedProperty");
                }
            }
        } else if (!definition.isEqualTo((DevelopmentObject)implementation)) {
            checkResult.addEntry((DevelopmentObject)implementation, 0, "", "The context attribute in the interface implementation differs from the corresponding attribute in the component interface definition.", "Make shure that all properties of both context attributes are identical.");
            return false;
        }
        return true;
    }

    private static void checkModelUsage(Controller controller, Model model, CheckResult checkResult) {
        DevelopmentObject comp = controller.getParent();
        boolean hasUsage = false;
        if (comp instanceof Component) {
            if (!((Component)comp).hasUsedModel(model)) {
                checkResult.addEntry(comp, 0, "usedModel", "The model '" + model.getName() + "' has not been defined as used model", "Define a model usage for the corresponding component.");
            }
        } else if (comp instanceof ComponentInterfaceDefinition && !((ComponentInterfaceDefinition)comp).hasUsedModel(model)) {
            checkResult.addEntry(comp, 0, "usedModel", "The model '" + model.getName() + "' has not been defined as used model", "Define a model usage for the corresponding component interface definition.");
        }
    }

    private static String getAbsolutePath(ContextElement element) {
        return ContextChecker.getAbsolutePath((ComponentUsage)null, element);
    }

    private static String getAbsolutePath(ComponentControllerUsage componentControllerUsage, ContextElement element) {
        return ContextChecker.getAbsolutePath(componentControllerUsage != null ? componentControllerUsage.getComponentUsage() : null, element);
    }

    private static String getAbsolutePath(ComponentUsage componentUsage, ContextElement element) {
        String path = "";
        if (componentUsage != null) {
            path = path + (componentUsage.getParent() != null ? componentUsage.getParent().getName() + '.' : "");
            path = path + componentUsage.getName();
        }
        if (element != null) {
            path = path + CheckLayerHelper.getRelativePath(element);
            path = path + ": ";
        }
        return path;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

