/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.checklayer;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.SeverityEnum;
import com.sap.ide.metamodel.general.i18n.I18NProblem;
import com.sap.ide.metamodel.general.i18n.I18NTextProblem;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.util.RawLanguageConverter;
import com.sap.ide.webdynpro.checklayer.CheckResult;
import com.sap.ide.webdynpro.checklayer.IWebDynproChecker;

public class MDOChecker
implements IWebDynproChecker {
    public void check(DevelopmentObject developmentObject, boolean fullCheck, CheckResult checkResult) {
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            return;
        }
        MainDevelopmentObject lMDO = (MainDevelopmentObject)developmentObject;
        TextPool lTextPool = lMDO.getTextPool();
        if (lTextPool.isEmpty()) {
            return;
        }
        String lOriginalLanguage = "";
        I18NProblem[] lI18NProblems = lTextPool.validateLanguages();
        int i = 0;
        while (i < lI18NProblems.length) {
            I18NProblem lI18NProblem = lI18NProblems[i];
            int lSeverity = 2;
            if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                lSeverity = 1;
            } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                lSeverity = 0;
            }
            checkResult.addEntry((DevelopmentObject)lMDO, lSeverity, "", lI18NProblem.getMessage(), "");
            ++i;
        }
        if (RawLanguageConverter.isRawLanguageMissing((MainDevelopmentObject)lMDO)) {
            checkResult.addEntry((DevelopmentObject)lMDO, 1, "", "Raw language version is missing", "Activate raw language support for project " + lMDO.getRoot().getMetamodel().getName());
            lOriginalLanguage = lMDO.getMasterLanguage();
        }
        I18NTextProblem[] lI18NTextProblems = lTextPool.validateTexts(lOriginalLanguage);
        int i2 = 0;
        while (i2 < lI18NTextProblems.length) {
            I18NTextProblem lI18NProblem = lI18NTextProblems[i2];
            int lSeverity = 2;
            if (lI18NProblem.getSeverity() == SeverityEnum.WARNING) {
                lSeverity = 1;
            } else if (lI18NProblem.getSeverity() == SeverityEnum.ERROR || lI18NProblem.getSeverity() == SeverityEnum.FATAL) {
                lSeverity = 0;
            }
            DevelopmentObject lDevelopmentObject = lI18NProblem.getText().getDevelopmentObject();
            if (lDevelopmentObject == null) {
                checkResult.addEntry((DevelopmentObject)lMDO, lSeverity, "", lI18NProblem.getMessage(), "Execute \"repair texts\" action for project " + lMDO.getRoot().getMetamodel().getName());
            } else {
                checkResult.addEntry(lDevelopmentObject, lSeverity, lI18NProblem.getText().getAttributeName(), lI18NProblem.getMessage(), "");
            }
            ++i2;
        }
    }
}

