/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.plugindep.impl;

import com.tssap.tools.plugindep.IPlugin;
import com.tssap.tools.plugindep.impl.AbstractPluginManager;
import com.tssap.tools.plugindep.impl.IMutablePlugin;
import com.tssap.tools.plugindep.impl.PluginImpl;
import com.tssap.tools.plugindep.impl.RelationImpl;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginManagerImplFS
extends AbstractPluginManager {
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private DocumentBuilder docBuild;
    private Document domDoc;
    private ArrayList pluginXmlFiles = new ArrayList();
    private HashMap pluginXmlFilesMap = new HashMap();
    private int currentPos = 0;
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$plugindep$impl$PluginManagerImplFS == null ? (class$com$tssap$tools$plugindep$impl$PluginManagerImplFS = PluginManagerImplFS.class$("com.tssap.tools.plugindep.impl.PluginManagerImplFS")) : class$com$tssap$tools$plugindep$impl$PluginManagerImplFS));
    static /* synthetic */ Class class$com$tssap$tools$plugindep$impl$PluginManagerImplFS;

    public PluginManagerImplFS(String folder) throws ParserConfigurationException, IOException, SAXException {
        this.docBuild = this.dbf.newDocumentBuilder();
        this.initXmlFiles(folder);
        this.currentPos = 0;
    }

    private void initXmlFiles(String path2dir) {
        File fil = new File(path2dir);
        String dirName = fil.getName();
        this.pluginXmlFilesMap.clear();
        boolean isFile = fil.isFile();
        boolean isDir = fil.isDirectory();
        String pathAbs = new String();
        String[] dirList = fil.list();
        int j = 0;
        while (j < dirList.length) {
            String path2xml = path2dir + dirList[j] + "\\" + "plugin.xml";
            File f = new File(path2xml);
            if (f.exists()) {
                String id = this.getPluginID(f);
                this.pluginXmlFilesMap.put(id, f);
                this.pluginXmlFiles.add(f);
            } else if (tracer.warning()) {
                tracer.warning("There is no plugin.xml file in folder " + path2xml);
            }
            ++j;
        }
    }

    private String getPluginID(File f) {
        NodeList pluginTag = null;
        try {
            Document domDoc = this.docBuild.parse(f);
            Element docRoot = domDoc.getDocumentElement();
            pluginTag = domDoc.getElementsByTagName("plugin");
        }
        catch (IOException e) {
            if (tracer.error()) {
                tracer.error("IOException: " + e.getMessage());
            }
            System.out.println("IOException: " + e);
        }
        catch (SAXException ex) {
            if (tracer.error()) {
                tracer.error("SAXException: " + ex.getMessage());
            }
            System.out.println("SAXException: " + ex);
        }
        if (pluginTag != null) {
            int number = pluginTag.getLength();
            try {
                if (number == 0) {
                    if (tracer.error()) {
                        tracer.error("An error occured - no plugin tag found");
                    }
                } else {
                    Node plugTag = pluginTag.item(0);
                    if (1 == plugTag.getNodeType()) {
                        Element tagPlugin = (Element)plugTag;
                        String id = tagPlugin.getAttribute("id");
                        return id;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public IPlugin nextObj() {
        NodeList pluginTag = null;
        NodeList importTag = null;
        boolean isExported = false;
        IMutablePlugin requiredPlugin = null;
        String depId = null;
        IMutablePlugin imutablePlugin = null;
        if (this.currentPos < this.pluginXmlFiles.size()) {
            String uniqueID;
            String version;
            try {
                Document domDoc = this.docBuild.parse((File)this.pluginXmlFiles.get(this.currentPos));
                Element docRoot = domDoc.getDocumentElement();
                pluginTag = domDoc.getElementsByTagName("plugin");
                importTag = docRoot.getElementsByTagName("import");
            }
            catch (IOException e) {
                if (tracer.error()) {
                    tracer.error("IOException: " + e.getMessage());
                }
                System.out.println("IOException: " + e);
            }
            catch (SAXException ex) {
                if (tracer.error()) {
                    tracer.error("SAXException: " + ex.getMessage());
                }
                System.out.println("SAXException: " + ex);
            }
            if (pluginTag != null) {
                int number = pluginTag.getLength();
                if (number == 0) {
                    if (tracer.error()) {
                        tracer.error("An error occured - no plugin tag found");
                    }
                } else {
                    Node plugTag = pluginTag.item(0);
                    if (1 == plugTag.getNodeType()) {
                        Element tagPlugin = (Element)plugTag;
                        String id = tagPlugin.getAttribute("id");
                        version = tagPlugin.getAttribute("version");
                        uniqueID = id;
                        imutablePlugin = (IMutablePlugin)this.pluginHt.get(uniqueID);
                        if (imutablePlugin == null) {
                            imutablePlugin = new PluginImpl(uniqueID);
                        }
                    }
                }
            }
            if (importTag != null) {
                int i = 0;
                while (i < importTag.getLength()) {
                    Node impTag = importTag.item(i);
                    if (1 == impTag.getNodeType()) {
                        Element tagImport = (Element)impTag;
                        depId = tagImport.getAttribute("plugin");
                        String export = tagImport.getAttribute("export");
                        version = tagImport.getAttribute("version");
                        isExported = export == "true";
                        uniqueID = depId;
                        requiredPlugin = (IMutablePlugin)this.pluginHt.get(uniqueID);
                        if (requiredPlugin == null) {
                            boolean hasDescription = this.pluginXmlFilesMap.containsKey(uniqueID);
                            requiredPlugin = new PluginImpl(uniqueID, hasDescription);
                            this.pluginHt.put(uniqueID, requiredPlugin);
                        }
                        RelationImpl relation = new RelationImpl(imutablePlugin, requiredPlugin, isExported);
                        imutablePlugin.addRequired(relation);
                        requiredPlugin.addDependent(relation);
                    }
                    ++i;
                }
            }
            ++this.currentPos;
        }
        return imutablePlugin;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

