/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.plugindep.impl;

import com.tssap.tools.plugindep.IPlugin;
import com.tssap.tools.plugindep.IRelation;
import com.tssap.tools.plugindep.impl.IMutablePlugin;
import com.tssap.tools.plugindep.impl.RelationImpl;
import java.util.ArrayList;

public class PluginImpl
implements IPlugin,
IMutablePlugin {
    private String pluginID;
    private boolean hasDescription;
    private ArrayList requiredPlugins = new ArrayList();
    private ArrayList dependentPlugins = new ArrayList();

    public PluginImpl(String pluginID) {
        this(pluginID, true);
    }

    public PluginImpl(String pluginID, boolean hasDescription) {
        this.pluginID = pluginID;
        this.hasDescription = hasDescription;
    }

    public void setID(String id) {
        this.pluginID = id;
    }

    public String getID() {
        return this.pluginID;
    }

    public boolean hasDescription() {
        return this.hasDescription;
    }

    public void addRequired(IRelation relation) {
        this.requiredPlugins.add(relation);
    }

    public void addDependent(IRelation relation) {
        this.dependentPlugins.add(relation);
    }

    public IRelation[] getRequireds() {
        IRelation[] irelation = this.requiredPlugins.toArray(new RelationImpl[0]);
        return irelation;
    }

    public IRelation[] getDependents() {
        IRelation[] irelation = this.dependentPlugins.toArray(new RelationImpl[0]);
        return irelation;
    }

    public IPlugin[] getRequiredPlugins() {
        IRelation[] requiredRelations = this.getRequireds();
        ArrayList<IPlugin> requiredArr = new ArrayList<IPlugin>();
        int i = 0;
        while (i < requiredRelations.length) {
            IRelation rel = requiredRelations[i];
            requiredArr.add(rel.getRequiredPlugin());
            ++i;
        }
        return requiredArr.toArray(new IPlugin[0]);
    }

    public IPlugin[] getDependentPlugins() {
        IRelation[] dependentsRelations = this.getDependents();
        ArrayList<IPlugin> dependentArr = new ArrayList<IPlugin>();
        int i = 0;
        while (i < dependentsRelations.length) {
            IRelation rel = dependentsRelations[i];
            dependentArr.add(rel.getDependentPlugin());
            ++i;
        }
        return dependentArr.toArray(new IPlugin[0]);
    }

    public boolean equals(Object arg) {
        if (arg instanceof PluginImpl) {
            PluginImpl tmpPlugin = (PluginImpl)arg;
            return tmpPlugin.pluginID.equals(this.pluginID);
        }
        return super.equals(arg);
    }
}

