/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.tools.plugindep.impl;

import com.tssap.tools.plugindep.IPlugin;
import com.tssap.tools.plugindep.IPluginManager;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractPluginManager
implements IPluginManager {
    protected Hashtable pluginHt = new Hashtable();
    protected Hashtable rootHt = new Hashtable();
    protected Hashtable leavesHt = new Hashtable();
    protected boolean isInit = false;
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$tools$plugindep$impl$AbstractPluginManager == null ? (class$com$tssap$tools$plugindep$impl$AbstractPluginManager = AbstractPluginManager.class$("com.tssap.tools.plugindep.impl.AbstractPluginManager")) : class$com$tssap$tools$plugindep$impl$AbstractPluginManager));
    static /* synthetic */ Class class$com$tssap$tools$plugindep$impl$AbstractPluginManager;

    abstract IPlugin nextObj();

    protected void init() {
        if (this.isInit) {
            return;
        }
        IPlugin plugin = null;
        if (!this.pluginHt.isEmpty()) {
            this.pluginHt.clear();
        }
        if (!this.rootHt.isEmpty()) {
            this.rootHt.clear();
        }
        int cpos = 0;
        while ((plugin = this.nextObj()) != null) {
            ++cpos;
            Object requiredPlugin = null;
            IPlugin[] requiredPlugins = plugin.getRequiredPlugins();
            String id = plugin.getID();
            if (tracer.debug()) {
                tracer.debug("Plugin(" + cpos + "): \"" + id + "\" requires:");
            }
            if (!this.rootHt.containsKey(id) && plugin.getDependentPlugins().length == 0) {
                this.rootHt.put(id, plugin);
            }
            if (this.rootHt.containsKey(id) && plugin.getDependentPlugins().length != 0) {
                this.rootHt.remove(id);
            }
            if (!this.pluginHt.containsKey(id)) {
                this.pluginHt.put(id, plugin);
            }
            if (!this.leavesHt.containsKey(id) && plugin.getRequiredPlugins().length == 0) {
                this.leavesHt.put(id, plugin);
            }
            if (this.leavesHt.containsKey(id) && plugin.getRequiredPlugins().length != 0) {
                this.leavesHt.remove(id);
            }
            int k = 0;
            while (k < requiredPlugins.length) {
                String reqId = requiredPlugins[k].getID();
                if (tracer.debug()) {
                    tracer.debug("  " + (k + 1) + ". " + reqId);
                }
                if (this.rootHt.containsKey(reqId)) {
                    this.rootHt.remove(reqId);
                }
                ++k;
            }
        }
        this.isInit = true;
    }

    public IPlugin[] getAllRoots() {
        this.init();
        IPlugin[] rootPlugin = new IPlugin[this.rootHt.size()];
        int i = 0;
        Enumeration rootEnum = this.rootHt.elements();
        while (rootEnum.hasMoreElements()) {
            rootPlugin[i] = (IPlugin)rootEnum.nextElement();
            ++i;
        }
        return rootPlugin;
    }

    public IPlugin[] getAllLeaves() {
        this.init();
        IPlugin[] leafPlugins = new IPlugin[this.leavesHt.size()];
        int i = 0;
        Enumeration leavesEnum = this.leavesHt.elements();
        while (leavesEnum.hasMoreElements()) {
            leafPlugins[i] = (IPlugin)leavesEnum.nextElement();
            ++i;
        }
        return leafPlugins;
    }

    public IPlugin getPlugin(String id) {
        this.init();
        IPlugin p = (IPlugin)this.pluginHt.get(id);
        if (p == null) {
            throw new IllegalStateException();
        }
        return p;
    }

    public IPlugin[] getAllPlugins() {
        this.init();
        return this.pluginHt.values().toArray(new IPlugin[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

